/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reference;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry;
import org.broadinstitute.gpp.poolq3.reference.BaseReference;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode$;
import org.broadinstitute.gpp.poolq3.reference.Reference$;
import org.broadinstitute.gpp.poolq3.reference.VariantReference$;
import org.broadinstitute.gpp.poolq3.seq.seq$package$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class VariantReference
extends BaseReference {
    private final Function1<String, String> barcodeProcessor;
    private final boolean includeAmbiguous;
    private final Object2ObjectMap<String, List<String>> truncationVariants;
    private final Object2ObjectMap<String, List<String>> mismatchVariants;

    public static VariantReference apply(Seq<ReferenceEntry> seq2, Function1<String, String> function1, boolean bl) {
        return VariantReference$.MODULE$.apply(seq2, function1, bl);
    }

    public VariantReference(Seq<String> allBarcodes, Object2ObjectMap<String, String> barcodeToInputBarcode, Object2ObjectMap<String, LinkedHashSet<String>> barcodeIds, Function1<String, String> barcodeProcessor, boolean includeAmbiguous) {
        this.barcodeProcessor = barcodeProcessor;
        this.includeAmbiguous = includeAmbiguous;
        super(allBarcodes, barcodeToInputBarcode, barcodeIds);
        this.truncationVariants = Reference$.MODULE$.truncationVariants(allBarcodes, barcodeProcessor, includeAmbiguous);
        this.mismatchVariants = this.generateVariants();
    }

    private Seq<String> allBarcodes$accessor() {
        return super.allBarcodes();
    }

    @Override
    public Seq<MatchedBarcode> find(String barcode2) {
        char[] bases = barcode2.toCharArray();
        int n = seq$package$.MODULE$.singleNIndex(bases);
        if (seq$package$.MODULE$.NoN() == n) {
            List exact = (List)this.truncationVariants.get(barcode2);
            if (exact.nonEmpty()) {
                return exact.map((Function1<String, MatchedBarcode> & Serializable)_$1 -> MatchedBarcode$.MODULE$.apply((String)_$1, 0));
            }
            return ((List)this.mismatchVariants.get(barcode2)).map((Function1<String, MatchedBarcode> & Serializable)_$2 -> MatchedBarcode$.MODULE$.apply((String)_$2, 1));
        }
        if (seq$package$.MODULE$.PolyN() == n) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        int n2 = n;
        Seq<String> variants = this.posVariants(bases, n2, this.posVariants$default$3());
        Seq matchingReferenceBarcodes = (Seq)variants.flatMap((Function1<String, IterableOnce> & Serializable)_$3 -> (IterableOnce)this.truncationVariants.get(_$3));
        if (this.includeAmbiguous || matchingReferenceBarcodes.lengthCompare(1) == 0) {
            return (Seq)matchingReferenceBarcodes.map((Function1<String, MatchedBarcode> & Serializable)bc -> MatchedBarcode$.MODULE$.apply((String)bc, 1));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<String> posVariants(char[] bases, int nIdx, char orig) {
        String[] ret = new String[4];
        bases[nIdx] = 65;
        ret[0] = new String(bases);
        bases[nIdx] = 67;
        ret[1] = new String(bases);
        bases[nIdx] = 71;
        ret[2] = new String(bases);
        bases[nIdx] = 84;
        ret[3] = new String(bases);
        bases[nIdx] = orig;
        return ArraySeq$.MODULE$.unsafeWrapArray(ret);
    }

    private char posVariants$default$3() {
        return 'N';
    }

    private Object2ObjectMap<String, List<String>> generateVariants() {
        Seq initialVariants = (Seq)this.allBarcodes$accessor().map((Function1<String, Tuple2> & Serializable)bc -> Tuple2$.MODULE$.apply(this.barcodeProcessor.apply((String)bc), bc));
        Seq mismatchVariants = (Seq)((IterableOps)initialVariants.withFilter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String variant = (String)tuple2._1();
                String barcode2 = (String)tuple2._2();
                Tuple2 $1$ = tuple2;
                return true;
            }
            return false;
        }).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String variant = (String)tuple2._1();
                String barcode2 = (String)tuple2._2();
                Tuple2 $1$ = tuple2;
                char[] bases = (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(variant), ClassTag$.MODULE$.apply(Character.TYPE));
                return Tuple2$.MODULE$.apply($1$, bases);
            }
            throw new MatchError(tuple2);
        })).flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String variant = (String)tuple2._1();
                String barcode2 = (String)tuple2._2();
                char[] bases = (char[])tuple22._2();
                Object object = Predef$.MODULE$.charArrayOps(bases);
                return (IndexedSeq)ArrayOps$.MODULE$.indices$extension(object).flatMap((Function1<Object, IterableOnce> & Serializable)i -> this.$anonfun$5$$anonfun$1(bases, barcode2, BoxesRunTime.unboxToInt(i)));
            }
            throw new MatchError(tuple22);
        });
        Object2ObjectOpenHashMap<String, List<String>> map = new Object2ObjectOpenHashMap<String, List<String>>();
        map.defaultReturnValue(package$.MODULE$.Nil());
        mismatchVariants.foreach((Function1<Tuple2, List> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String variant = (String)tuple2._1();
                String barcode2 = (String)tuple2._2();
                List bcs = (List)map.get(variant);
                return map.put(variant, bcs.$colon$colon(barcode2));
            }
            throw new MatchError(tuple2);
        });
        if (!this.includeAmbiguous) {
            Reference$.MODULE$.pruneAmbiguous(map);
        }
        return map;
    }

    private final /* synthetic */ IterableOnce $anonfun$5$$anonfun$1(char[] bases$1, String barcode$1, int i) {
        return (IterableOnce)this.posVariants(bases$1, i, bases$1[i]).map((Function1<String, Tuple2> & Serializable)v -> Tuple2$.MODULE$.apply(v, barcode$1));
    }
}

