/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class SamStreams {
    private static int readBytes(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length && (count = stream.read(buffer, offset + bytesRead, length - bytesRead)) > 0; bytesRead += count) {
        }
        return bytesRead;
    }

    public static boolean isCRAMFile(InputStream stream) throws IOException {
        stream.mark(4);
        int buffSize = CramHeader.MAGIC.length;
        byte[] buffer = new byte[buffSize];
        SamStreams.readBytes(stream, buffer, 0, buffSize);
        stream.reset();
        return Arrays.equals(buffer, CramHeader.MAGIC);
    }

    public static boolean isBAMFile(InputStream stream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(stream)) {
            return false;
        }
        int buffSize = 65536;
        stream.mark(65536);
        byte[] buffer = new byte[65536];
        SamStreams.readBytes(stream, buffer, 0, 65536);
        stream.reset();
        try (BlockCompressedInputStream bcis = new BlockCompressedInputStream(new ByteArrayInputStream(buffer));){
            byte[] magicBuf = new byte[4];
            int magicLength = SamStreams.readBytes(bcis, magicBuf, 0, 4);
            boolean bl = magicLength == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, magicBuf);
            return bl;
        }
    }

    @Deprecated
    public static boolean isGzippedSAMFile(InputStream stream) {
        return IOUtil.isGZIPInputStream(stream);
    }

    public static boolean sourceLikeBam(SeekableStream strm) {
        String source2 = strm.getSource();
        if (source2 == null) {
            return true;
        }
        try {
            URL sourceURL = new URL(source2);
            String urlPath = sourceURL.getPath().toLowerCase();
            String queryParams = sourceURL.getQuery();
            if (queryParams != null) {
                queryParams = queryParams.toLowerCase();
            }
            return urlPath.endsWith(".bam") || queryParams != null && (queryParams.endsWith(".bam") || queryParams.contains(".bam?") || queryParams.contains(".bam&") || queryParams.contains(".bam%26"));
        }
        catch (MalformedURLException e) {
            source2 = source2.toLowerCase();
            return source2.endsWith(".bam") || source2.contains(".bam?") || source2.contains(".bam&") || source2.contains(".bam%26");
        }
    }

    public static boolean sourceLikeCram(SeekableStream strm) {
        String source2 = strm.getSource();
        if (source2 == null) {
            return false;
        }
        try {
            URL sourceURL = new URL(source2);
            String urlPath = sourceURL.getPath().toLowerCase();
            String queryParams = sourceURL.getQuery();
            if (queryParams != null) {
                queryParams = queryParams.toLowerCase();
            }
            return urlPath.endsWith(".cram") || queryParams != null && (queryParams.endsWith(".cram") || queryParams.contains(".cram?") || queryParams.contains(".cram&") || queryParams.contains(".cram%26"));
        }
        catch (MalformedURLException e) {
            source2 = source2.toLowerCase();
            return source2.endsWith(".cram") || source2.contains(".cram?") || source2.contains(".cram&") || source2.contains(".cram%26");
        }
    }
}

