/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.external.ExternalEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalLongCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class ExternalLongEncoding
extends ExternalEncoding<Long> {
    public ExternalLongEncoding(int externalBlockContentId) {
        super(externalBlockContentId);
    }

    public static ExternalLongEncoding fromParams(byte[] params) {
        int contentId = ITF8.readUnsignedITF8(params);
        return new ExternalLongEncoding(contentId);
    }

    @Override
    public CRAMCodec<Long> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        ByteArrayInputStream inputStream = externalBlockInputMap == null ? null : externalBlockInputMap.get(this.externalBlockContentId);
        ByteArrayOutputStream outputStream = externalBlockOutputMap == null ? null : externalBlockOutputMap.get(this.externalBlockContentId);
        return new ExternalLongCodec(inputStream, outputStream);
    }
}

