/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.hist;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.hist.ArrayHistogram$;
import org.broadinstitute.gpp.poolq3.hist.Histogram;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0006\f\u0003C!Aq\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u00191\u0004\u0001)A\u0005Y!1q\u0007\u0001Q\u0001\n1Ba\u0001\u000f\u0001!\u0002\u0013I\u0004BB#\u0001A\u0003%A\u0006\u0003\u0004\u0018\u0001\u0001\u0006IA\u0012\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u0006!\u0002!\t%\u0015\u0005\u00065\u0002!\ta\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006O\u0002!\t!\u001a\u0005\u0007Q\u0002!\tAF5\b\u000b-4\u0002\u0012\u00017\u0007\u000bU1\u0002\u0012A7\t\u000bE\u0012B\u0011\u00018\t\r=\u0014B\u0011\u0001\fq\u00059\t%O]1z\u0011&\u001cHo\\4sC6T!a\u0006\r\u0002\t!L7\u000f\u001e\u0006\u00033i\ta\u0001]8pYF\u001c$BA\u000e\u001d\u0003\r9\u0007\u000f\u001d\u0006\u0003;y\taB\u0019:pC\u0012Lgn\u001d;jiV$XMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%RC&D\u0001\u0017\u0013\tYcCA\u0005ISN$xn\u001a:b[B\u00111%L\u0005\u0003]\u0011\u00121!\u00138u\u0003\u0015\u0019H/\u0019:u\u0003\r)g\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M\"T\u0007\u0005\u0002*\u0001!)qf\u0001a\u0001Y!)\u0001g\u0001a\u0001Y\u0005\u0019Q.\u0019=\u0002\u00075Lg.A\u0003sC:<W\r\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u0001\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005\u0005#\u0013a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013QAU1oO\u0016T!!\u0011\u0013\u0002\r1,gn\u001a;i!\r\u0019s\tL\u0005\u0003\u0011\u0012\u0012Q!\u0011:sCf\f\u0011\"\u001b8de\u0016lWM\u001c;\u0015\u00051Z\u0005\"\u0002'\n\u0001\u0004a\u0013!A6\u0002\u000b\r|WO\u001c;\u0015\u00051z\u0005\"\u0002'\u000b\u0001\u0004a\u0013\u0001B6fsN,\u0012A\u0015\t\u0004'^ccB\u0001+V!\taD%\u0003\u0002WI\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\u0007M+GO\u0003\u0002WI\u00051Q.\u001a3jC:,\u0012\u0001\u0018\t\u0003GuK!A\u0018\u0013\u0003\r\u0011{WO\u00197f\u0003\u0011iW-\u00198\u0016\u0003\u0005\u00042a\t2]\u0013\t\u0019GE\u0001\u0004PaRLwN\\\u0001\u000b[&tW\t\\3nK:$X#\u00014\u0011\u0007\r\u0012G&\u0001\u0006nCb,E.Z7f]R\fA\u0002^8BeJ\f\u00170\u00138eKb$\"\u0001\f6\t\u000b1\u0003\u0002\u0019\u0001\u0017\u0002\u001d\u0005\u0013(/Y=ISN$xn\u001a:b[B\u0011\u0011FE\n\u0003%\t\"\u0012\u0001\\\u0001\fa\u0006\u0014H/[1m'Vl7\u000f\u0006\u0002riB\u0019!H\u001d\u0017\n\u0005M$%A\u0002,fGR|'\u000fC\u0003v)\u0001\u0007a/A\u0001b!\rQt\u000fL\u0005\u0003q\u0012\u0013A\"\u0013;fe\u0006\u0014G.Z(oG\u0016\u0004")
public final class ArrayHistogram
implements Histogram<Object> {
    private final int start;
    private final int end;
    private final int max;
    private final int min;
    private final Range range;
    private final int length;
    private final int[] hist;
    private volatile byte bitmap$init$0;

    @Override
    public int increment(int k) {
        int idx = this.toArrayIndex(k);
        this.hist[idx] = this.hist[idx] + 1;
        return this.hist[idx];
    }

    @Override
    public int count(int k) {
        return this.hist[this.toArrayIndex(k)];
    }

    @Override
    public Set<Object> keys() {
        return this.range.toSet();
    }

    public double median() {
        double d;
        Vector<Object> partialSums = ArrayHistogram$.MODULE$.partialSums(Predef$.MODULE$.wrapIntArray(this.hist));
        int total = BoxesRunTime.unboxToInt(partialSums.lastOption().getOrElse(() -> 0));
        if (total == 0) {
            d = Double.NaN;
        } else if (total % 2 == 1) {
            d = (double)this.min + (double)partialSums.indexWhere(x -> x > total / 2);
        } else {
            int idx1 = partialSums.indexWhere(x -> x > total / 2 - 1);
            int idx2 = partialSums.indexWhere(x -> x > total / 2, idx1);
            d = (double)this.min + (double)(idx1 + idx2) / 2.0;
        }
        return d;
    }

    public Option<Object> mean() {
        Option option;
        int elts = BoxesRunTime.unboxToInt(Predef$.MODULE$.wrapIntArray(this.hist).sum(Numeric$IntIsIntegral$.MODULE$));
        if (elts == 0) {
            option = None$.MODULE$;
        } else {
            long sum = BoxesRunTime.unboxToLong(ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hist)).map(idx -> {
                long elt = idx + $this.min;
                return (long)$this.hist[idx] * elt;
            }).sum(Numeric$LongIsIntegral$.MODULE$));
            option = new Some<Double>(BoxesRunTime.boxToDouble((double)sum / (double)elts));
        }
        return option;
    }

    public Option<Object> minElement() {
        return ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hist)).find(x$1 -> $this.hist[x$1] > 0).map(x$2 -> $this.min + x$2);
    }

    public Option<Object> maxElement() {
        return ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hist)).reverse().find(x$3 -> $this.hist[x$3] > 0).map(x$4 -> $this.min + x$4);
    }

    /*
     * WARNING - void declaration
     */
    public int toArrayIndex(int k) {
        void var2_2;
        int nk = k - this.min;
        Predef$.MODULE$.require(nk > -1 && nk < this.length, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(18).append(k).append(" out of range [").append($this.start).append(", ").append($this.end).append("]").toString());
        return (int)var2_2;
    }

    public ArrayHistogram(int start, int end) {
        this.start = start;
        this.end = end;
        this.max = package$.MODULE$.max(start, end);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.min = package$.MODULE$.min(start, end);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.range = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.min), this.max);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.length = this.range.length();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        Predef$.MODULE$.require(this.range.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Cannot build a histogram for an empty range");
        this.hist = (int[])Array$.MODULE$.fill(this.length, () -> 0, ClassTag$.MODULE$.Int());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

