/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.Decoding;
import htsjdk.samtools.cram.compression.rans.Encoding;
import java.nio.ByteBuffer;
import java.util.Arrays;

class Frequencies {
    Frequencies() {
    }

    static void readStats_o0(ByteBuffer cp, Decoding.AriDecoder decoder, Decoding.RansDecSymbol[] syms) {
        int rle = 0;
        int x = 0;
        int j = cp.get() & 0xFF;
        do {
            if (decoder.fc[j] == null) {
                decoder.fc[j] = new Decoding.FC();
            }
            if ((decoder.fc[j].F = cp.get() & 0xFF) >= 128) {
                decoder.fc[j].F &= 0xFFFFFF7F;
                decoder.fc[j].F = (decoder.fc[j].F & 0x7F) << 8 | cp.get() & 0xFF;
            }
            decoder.fc[j].C = x;
            Decoding.RansDecSymbolInit(syms[j], decoder.fc[j].C, decoder.fc[j].F);
            if (decoder.R == null) {
                decoder.R = new byte[4096];
            }
            Arrays.fill(decoder.R, x, x + decoder.fc[j].F, (byte)j);
            x += decoder.fc[j].F;
            if (rle == 0 && j + 1 == (0xFF & cp.get(cp.position()))) {
                j = cp.get() & 0xFF;
                rle = cp.get() & 0xFF;
                continue;
            }
            if (rle != 0) {
                --rle;
                ++j;
                continue;
            }
            j = cp.get() & 0xFF;
        } while (j != 0);
        assert (x < 4096);
    }

    static void readStats_o1(ByteBuffer cp, Decoding.AriDecoder[] D, Decoding.RansDecSymbol[][] syms) {
        int rle_i = 0;
        int i = 0xFF & cp.get();
        do {
            int rle_j = 0;
            int x = 0;
            int j = 0xFF & cp.get();
            if (D[i] == null) {
                D[i] = new Decoding.AriDecoder();
            }
            do {
                if (D[i].fc[j] == null) {
                    D[i].fc[j] = new Decoding.FC();
                }
                if ((D[i].fc[j].F = 0xFF & cp.get()) >= 128) {
                    D[i].fc[j].F &= 0xFFFFFF7F;
                    D[i].fc[j].F = (D[i].fc[j].F & 0x7F) << 8 | 0xFF & cp.get();
                }
                D[i].fc[j].C = x;
                if (D[i].fc[j].F == 0) {
                    D[i].fc[j].F = 4096;
                }
                if (syms[i][j] == null) {
                    syms[i][j] = new Decoding.RansDecSymbol();
                }
                Decoding.RansDecSymbolInit(syms[i][j], D[i].fc[j].C, D[i].fc[j].F);
                if (D[i].R == null) {
                    D[i].R = new byte[4096];
                }
                Arrays.fill(D[i].R, x, x + D[i].fc[j].F, (byte)j);
                assert ((x += D[i].fc[j].F) <= 4096);
                if (rle_j == 0 && j + 1 == (0xFF & cp.get(cp.position()))) {
                    j = 0xFF & cp.get();
                    rle_j = 0xFF & cp.get();
                    continue;
                }
                if (rle_j != 0) {
                    --rle_j;
                    ++j;
                    continue;
                }
                j = 0xFF & cp.get();
            } while (j != 0);
            if (rle_i == 0 && i + 1 == (0xFF & cp.get(cp.position()))) {
                i = 0xFF & cp.get();
                rle_i = 0xFF & cp.get();
                continue;
            }
            if (rle_i != 0) {
                --rle_i;
                ++i;
                continue;
            }
            i = 0xFF & cp.get();
        } while (i != 0);
    }

    static int[] calcFrequencies_o0(ByteBuffer in) {
        int in_size = in.remaining();
        int[] F = new int[256];
        int T = 0;
        for (int i = 0; i < in_size; ++i) {
            int n = 0xFF & in.get();
            F[n] = F[n] + 1;
            ++T;
        }
        long tr = 0x80000000000L / (long)T + (long)(0x40000000 / T);
        int m = 0;
        int M = 0;
        for (int j = 0; j < 256; ++j) {
            if (m >= F[j]) continue;
            m = F[j];
            M = j;
        }
        int fsum = 0;
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            F[j] = (int)((long)F[j] * tr >> 31);
            if (F[j] == 0) {
                F[j] = 1;
            }
            fsum += F[j];
        }
        if (++fsum < 4096) {
            int n = M;
            F[n] = F[n] + (4096 - fsum);
        } else {
            int n = M;
            F[n] = F[n] - (fsum - 4096);
        }
        assert (F[M] > 0);
        return F;
    }

    static int[][] calcFrequencies_o1(ByteBuffer in) {
        int i;
        int in_size = in.remaining();
        int[][] F = new int[256][256];
        int[] T = new int[256];
        int last_i = 0;
        for (i = 0; i < in_size; ++i) {
            int[] nArray = F[last_i];
            int c = 0xFF & in.get();
            nArray[c] = nArray[c] + 1;
            int n = last_i;
            T[n] = T[n] + 1;
            last_i = c;
        }
        int[] nArray = F[0];
        int n = 0xFF & in.get(in_size >> 2);
        nArray[n] = nArray[n] + 1;
        int[] nArray2 = F[0];
        int n2 = 0xFF & in.get(2 * (in_size >> 2));
        nArray2[n2] = nArray2[n2] + 1;
        int[] nArray3 = F[0];
        int n3 = 0xFF & in.get(3 * (in_size >> 2));
        nArray3[n3] = nArray3[n3] + 1;
        T[0] = T[0] + 3;
        for (i = 0; i < 256; ++i) {
            if (T[i] == 0) continue;
            double p = 4096.0 / (double)T[i];
            int t2 = 0;
            int m = 0;
            int M = 0;
            for (int j = 0; j < 256; ++j) {
                if (F[i][j] == 0) continue;
                if (m < F[i][j]) {
                    m = F[i][j];
                    M = j;
                }
                int[] nArray4 = F[i];
                int n4 = j;
                nArray4[n4] = (int)((double)nArray4[n4] * p);
                if (nArray4[n4] == 0) {
                    F[i][j] = 1;
                }
                t2 += F[i][j];
            }
            if (++t2 < 4096) {
                int[] nArray5 = F[i];
                int n5 = M;
                nArray5[n5] = nArray5[n5] + (4096 - t2);
                continue;
            }
            int[] nArray6 = F[i];
            int n6 = M;
            nArray6[n6] = nArray6[n6] - (t2 - 4096);
        }
        return F;
    }

    static Encoding.RansEncSymbol[] buildSyms_o0(int[] F) {
        int[] C = new int[256];
        Encoding.RansEncSymbol[] syms = new Encoding.RansEncSymbol[256];
        for (int i = 0; i < syms.length; ++i) {
            syms[i] = new Encoding.RansEncSymbol();
        }
        int T = 0;
        for (int j = 0; j < 256; ++j) {
            C[j] = T;
            T += F[j];
            if (F[j] == 0) continue;
            Encoding.RansEncSymbolInit(syms[j], C[j], F[j], 12);
        }
        return syms;
    }

    static int writeFrequencies_o0(ByteBuffer cp, int[] F) {
        int start = cp.position();
        int rle = 0;
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            if (rle != 0) {
                --rle;
            } else {
                cp.put((byte)j);
                if (rle == 0 && j != 0 && F[j - 1] != 0) {
                    for (rle = j + 1; rle < 256 && F[rle] != 0; ++rle) {
                    }
                    cp.put((byte)(rle -= j + 1));
                }
            }
            if (F[j] < 128) {
                cp.put((byte)F[j]);
                continue;
            }
            cp.put((byte)(0x80 | F[j] >> 8));
            cp.put((byte)(F[j] & 0xFF));
        }
        cp.put((byte)0);
        return cp.position() - start;
    }

    static Encoding.RansEncSymbol[][] buildSyms_o1(int[][] F) {
        int i;
        Encoding.RansEncSymbol[][] syms = new Encoding.RansEncSymbol[256][256];
        for (i = 0; i < syms.length; ++i) {
            for (int j = 0; j < syms[i].length; ++j) {
                syms[i][j] = new Encoding.RansEncSymbol();
            }
        }
        for (i = 0; i < 256; ++i) {
            int[] F_i_ = F[i];
            int x = 0;
            for (int j = 0; j < 256; ++j) {
                if (F_i_[j] == 0) continue;
                Encoding.RansEncSymbolInit(syms[i][j], x, F_i_[j], 12);
                x += F_i_[j];
            }
        }
        return syms;
    }

    static int writeFrequencies_o1(ByteBuffer cp, int[][] F) {
        int start = cp.position();
        int[] T = new int[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                int n = i;
                T[n] = T[n] + F[i][j];
            }
        }
        int rle_i = 0;
        for (int i = 0; i < 256; ++i) {
            if (T[i] == 0) continue;
            if (rle_i != 0) {
                --rle_i;
            } else {
                cp.put((byte)i);
                if (i != 0 && T[i - 1] != 0) {
                    for (rle_i = i + 1; rle_i < 256 && T[rle_i] != 0; ++rle_i) {
                    }
                    cp.put((byte)(rle_i -= i + 1));
                }
            }
            int[] F_i_ = F[i];
            int rle_j = 0;
            for (int j = 0; j < 256; ++j) {
                if (F_i_[j] == 0) continue;
                if (rle_j != 0) {
                    --rle_j;
                } else {
                    cp.put((byte)j);
                    if (rle_j == 0 && j != 0 && F_i_[j - 1] != 0) {
                        for (rle_j = j + 1; rle_j < 256 && F_i_[rle_j] != 0; ++rle_j) {
                        }
                        cp.put((byte)(rle_j -= j + 1));
                    }
                }
                if (F_i_[j] < 128) {
                    cp.put((byte)F_i_[j]);
                    continue;
                }
                cp.put((byte)(0x80 | F_i_[j] >> 8));
                cp.put((byte)(F_i_[j] & 0xFF));
            }
            cp.put((byte)0);
        }
        cp.put((byte)0);
        return cp.position() - start;
    }
}

