/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldEncoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldWriter;
import htsjdk.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashMap;
import java.util.Map;

public class BCF2FieldWriterManager {
    final Map<String, BCF2FieldWriter.SiteWriter> siteWriters = new HashMap<String, BCF2FieldWriter.SiteWriter>();
    final Map<String, BCF2FieldWriter.GenotypesWriter> genotypesWriters = new HashMap<String, BCF2FieldWriter.GenotypesWriter>();
    final IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();

    public void setup(VCFHeader header, BCF2Encoder encoder, Map<String, Integer> stringDictionary) {
        BCF2FieldWriter writer;
        for (VCFInfoHeaderLine vCFInfoHeaderLine : header.getInfoHeaderLines()) {
            String field2 = vCFInfoHeaderLine.getID();
            writer = this.createInfoWriter(header, vCFInfoHeaderLine, encoder, stringDictionary);
            this.add(this.siteWriters, field2, writer);
        }
        for (VCFFormatHeaderLine vCFFormatHeaderLine : header.getFormatHeaderLines()) {
            String field2 = vCFFormatHeaderLine.getID();
            writer = this.createGenotypesWriter(header, vCFFormatHeaderLine, encoder, stringDictionary);
            this.add(this.genotypesWriters, field2, writer);
        }
    }

    private final <T> void add(Map<String, T> map, String field2, T writer) {
        if (map.containsKey(field2)) {
            throw new IllegalStateException("BUG: field " + field2 + " already seen in VCFHeader while building BCF2 field encoders");
        }
        map.put(field2, writer);
    }

    private BCF2FieldWriter.SiteWriter createInfoWriter(VCFHeader header, VCFInfoHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict) {
        return new BCF2FieldWriter.GenericSiteWriter(header, this.createFieldEncoder(line, encoder, dict, false));
    }

    private BCF2FieldEncoder createFieldEncoder(VCFCompoundHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict, boolean createGenotypesEncoders) {
        if (createGenotypesEncoders && this.intGenotypeFieldAccessors.getAccessor(line.getID()) != null) {
            return new BCF2FieldEncoder.IntArray(line, dict);
        }
        if (createGenotypesEncoders && line.getID().equals("GT")) {
            return new BCF2FieldEncoder.GenericInts(line, dict);
        }
        switch (line.getType()) {
            case Character: 
            case String: {
                return new BCF2FieldEncoder.StringOrCharacter(line, dict);
            }
            case Flag: {
                return new BCF2FieldEncoder.Flag(line, dict);
            }
            case Float: {
                return new BCF2FieldEncoder.Float(line, dict);
            }
            case Integer: {
                if (line.isFixedCount() && line.getCount() == 1) {
                    return new BCF2FieldEncoder.AtomicInt(line, dict);
                }
                return new BCF2FieldEncoder.GenericInts(line, dict);
            }
        }
        throw new IllegalArgumentException("Unexpected type for field " + line.getID());
    }

    private BCF2FieldWriter.GenotypesWriter createGenotypesWriter(VCFHeader header, VCFFormatHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict) {
        String field2 = line.getID();
        BCF2FieldEncoder fieldEncoder = this.createFieldEncoder(line, encoder, dict, true);
        if (field2.equals("GT")) {
            return new BCF2FieldWriter.GTWriter(header, fieldEncoder);
        }
        if (line.getID().equals("FT")) {
            return new BCF2FieldWriter.FTGenotypesWriter(header, fieldEncoder);
        }
        if (this.intGenotypeFieldAccessors.getAccessor(field2) != null) {
            return new BCF2FieldWriter.IGFGenotypesWriter(header, fieldEncoder, this.intGenotypeFieldAccessors.getAccessor(field2));
        }
        if (line.getType() == VCFHeaderLineType.Integer) {
            return new BCF2FieldWriter.IntegerTypeGenotypesWriter(header, fieldEncoder);
        }
        return new BCF2FieldWriter.StaticallyTypeGenotypesWriter(header, fieldEncoder);
    }

    public BCF2FieldWriter.SiteWriter getSiteFieldWriter(String field2) {
        return this.getWriter(field2, this.siteWriters);
    }

    public BCF2FieldWriter.GenotypesWriter getGenotypeFieldWriter(String field2) {
        return this.getWriter(field2, this.genotypesWriters);
    }

    public <T> T getWriter(String key, Map<String, T> map) {
        return map.get(key);
    }
}

