/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.gff.Gff3Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Gff3BaseData {
    private static final String ID_ATTRIBUTE_KEY = "ID";
    private static final String NAME_ATTRIBUTE_KEY = "Name";
    private static final String ALIAS_ATTRIBUTE_KEY = "Alias";
    private final String contig;
    private final String source;
    private final String type;
    private final int start;
    private final int end;
    private final double score;
    private final Strand strand;
    private final int phase;
    private final Map<String, List<String>> attributes;
    private final String id;
    private final String name;
    private final List<String> aliases;
    private final int hashCode;

    public Gff3BaseData(String contig, String source2, String type, int start, int end, Double score, Strand strand, int phase, Map<String, List<String>> attributes) {
        this.contig = contig;
        this.source = source2;
        this.type = type;
        this.start = start;
        this.end = end;
        this.score = score;
        this.phase = phase;
        this.strand = strand;
        this.attributes = Gff3BaseData.copyAttributesSafely(attributes);
        this.id = Gff3Codec.extractSingleAttribute(attributes.get(ID_ATTRIBUTE_KEY));
        this.name = Gff3Codec.extractSingleAttribute(attributes.get(NAME_ATTRIBUTE_KEY));
        this.aliases = attributes.getOrDefault(ALIAS_ATTRIBUTE_KEY, Collections.emptyList());
        this.hashCode = this.computeHashCode();
    }

    private static Map<String, List<String>> copyAttributesSafely(Map<String, List<String>> attributes) {
        LinkedHashMap modifiableDeepMap = new LinkedHashMap();
        for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
            List unmodifiableDeepList = Collections.unmodifiableList(new ArrayList(entry.getValue()));
            modifiableDeepMap.put(entry.getKey(), unmodifiableDeepList);
        }
        return Collections.unmodifiableMap(modifiableDeepMap);
    }

    public boolean equals(Object other) {
        boolean ret;
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(Gff3BaseData.class)) {
            return false;
        }
        Gff3BaseData otherBaseData = (Gff3BaseData)other;
        boolean bl = ret = otherBaseData.getContig().equals(this.getContig()) && otherBaseData.getSource().equals(this.getSource()) && otherBaseData.getType().equals(this.getType()) && otherBaseData.getStart() == this.getStart() && otherBaseData.getEnd() == this.getEnd() && Double.valueOf(otherBaseData.getScore()).equals(this.score) && otherBaseData.getPhase() == this.getPhase() && otherBaseData.getStrand().equals((Object)this.getStrand()) && otherBaseData.getAttributes().equals(this.getAttributes());
        if (this.getId() == null) {
            ret = ret && otherBaseData.getId() == null;
        } else {
            boolean bl2 = ret = ret && otherBaseData.getId() != null && otherBaseData.getId().equals(this.getId());
        }
        ret = this.getName() == null ? ret && otherBaseData.getName() == null : ret && otherBaseData.getName() != null && otherBaseData.getName().equals(this.getName());
        ret = ret && otherBaseData.getAliases().equals(this.getAliases());
        return ret;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int hash2 = this.getContig().hashCode();
        hash2 = 31 * hash2 + this.getSource().hashCode();
        hash2 = 31 * hash2 + this.getType().hashCode();
        hash2 = 31 * hash2 + this.getStart();
        hash2 = 31 * hash2 + this.getEnd();
        hash2 = 31 * hash2 + Double.hashCode(this.getScore());
        hash2 = 31 * hash2 + this.getPhase();
        hash2 = 31 * hash2 + this.getStrand().hashCode();
        hash2 = 31 * hash2 + this.getAttributes().hashCode();
        if (this.getId() != null) {
            hash2 = 31 * hash2 + this.getId().hashCode();
        }
        if (this.getName() != null) {
            hash2 = 31 * hash2 + this.getName().hashCode();
        }
        hash2 = 31 * hash2 + this.aliases.hashCode();
        return hash2;
    }

    public String getContig() {
        return this.contig;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double getScore() {
        return this.score;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getPhase() {
        return this.phase;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttribute(String key) {
        return this.attributes.getOrDefault(key, Collections.emptyList());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }
}

