/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.collection.package$;
import org.broadinstitute.gpp.poolq3.collection.package$ZipWithIndex1$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.control.NonFatal$;

public final class UnexpectedSequenceWriter$ {
    public static final UnexpectedSequenceWriter$ MODULE$ = new UnexpectedSequenceWriter$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter");
    private static volatile boolean bitmap$init$0 = true;

    public Try<BoxedUnit> write(Path outputFile, Path unexpectedSequenceCacheDir, int sequencesToReport, Reference colReference, Option<Reference> globalReference) {
        Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>> tuple2 = this.loadCache(unexpectedSequenceCacheDir, sequencesToReport);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object2ObjectMap<String, Object2IntOpenHashMap<String>> h = tuple2._1();
        Map<String, Object> r = tuple2._2();
        Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>> tuple22 = new Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>>(h, r);
        Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>> tuple23 = tuple22;
        Object2ObjectMap<String, Object2IntOpenHashMap<String>> h2 = tuple23._1();
        Map<String, Object> r2 = tuple23._2();
        return Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(outputFile.toFile()), (Function1<PrintWriter, Object> & Serializable)pw -> {
            UnexpectedSequenceWriter$.MODULE$.printUnexpectedCounts(colReference, globalReference, h2, r2, pw);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public void removeCache(Path unexpectedSequenceCacheDir) {
        Files.list(unexpectedSequenceCacheDir).forEach(p -> this.tryDelete$1((Path)p));
        this.tryDelete$1(unexpectedSequenceCacheDir);
    }

    public Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>> loadCache(Path cacheDir, int sequencesToReport) {
        Object2ObjectOpenHashMap h = new Object2ObjectOpenHashMap();
        HashMap r = new HashMap();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(cacheDir.toFile().listFiles()), (Function1<File, Object> & Serializable)file -> {
            UnexpectedSequenceWriter$.$anonfun$loadCache$1(h, r, sequencesToReport, file);
            return BoxedUnit.UNIT;
        });
        return new Tuple2<Object2ObjectMap<String, Object2IntOpenHashMap<String>>, Map<String, Object>>(h, r.toMap($less$colon$less$.MODULE$.refl()));
    }

    public void printUnexpectedCounts(Reference colReference, Option<Reference> globalReferenceOpt, Object2ObjectMap<String, Object2IntOpenHashMap<String>> h, Map<String, Object> r, PrintWriter pw) {
        Seq colBarcodes = (Seq)colReference.allBarcodes().map((Function1<String, String> & Serializable)dnaBarcode -> colReference.referenceBarcodeForDnaBarcode((String)dnaBarcode));
        pw.println(this.headerText(colBarcodes));
        Seq rows = (Seq)((IterableOps)r.toSeq().sortBy((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bc = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2<Integer, String> tuple22 = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-count), bc);
            return tuple22;
        }, Ordering$.MODULE$.Tuple2(Ordering$Int$.MODULE$, Ordering$String$.MODULE$))).map((Function1<Tuple2, String> & Serializable)x0$2 -> {
            String k;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String string = k = (String)tuple2._1();
            return string;
        });
        rows.foreach((Function1<String, Object> & Serializable)rowBc -> {
            UnexpectedSequenceWriter$.$anonfun$printUnexpectedCounts$4(h, globalReferenceOpt, colReference, pw, rowBc);
            return BoxedUnit.UNIT;
        });
    }

    public String headerText(Seq<String> colBarcodes) {
        return new StringBuilder(29).append("Sequence\tTotal\t").append(colBarcodes.mkString("\t")).append("\tPotential IDs").toString();
    }

    public void parseFile(Object2ObjectMap<String, Object2IntOpenHashMap<String>> h, scala.collection.mutable.Map<String, Object> r, File file) {
        Using$.MODULE$.resource(Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()), (Function1<BufferedSource, Object> & Serializable)src -> {
            UnexpectedSequenceWriter$.$anonfun$parseFile$1(file, r, h, src);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public <A> void truncateToN(Object2ObjectMap<A, Object2IntOpenHashMap<A>> h, scala.collection.mutable.Map<A, Object> r, int n) {
        Seq drop = (Seq)((IterableOps)r.toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToInteger(UnexpectedSequenceWriter$.$anonfun$truncateToN$1(x0$1)), Ordering$Int$.MODULE$)).drop(n);
        drop.foreach((Function1<Tuple2, Object2IntOpenHashMap> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object bc = tuple2._1();
            r.remove(bc);
            Object2IntOpenHashMap object2IntOpenHashMap = (Object2IntOpenHashMap)h.remove(bc);
            return object2IntOpenHashMap;
        });
    }

    private final void tryDelete$1(Path p) {
        try {
            Files.delete(p);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                if (log.isWarnEnabled()) {
                    log.warn(new StringBuilder(17).append("Unable to delete ").append(p.toAbsolutePath()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$1(Object2ObjectOpenHashMap h$2, HashMap r$2, int sequencesToReport$1, File file) {
        if (log.isDebugEnabled()) {
            log.debug(new StringBuilder(11).append("Processing ").append(file.getName()).toString());
        }
        MODULE$.parseFile(h$2, r$2, file);
        MODULE$.truncateToN(h$2, r$2, sequencesToReport$1);
    }

    public static final /* synthetic */ void $anonfun$printUnexpectedCounts$4(Object2ObjectMap h$3, Option globalReferenceOpt$1, Reference colReference$2, PrintWriter pw$1, String rowBc) {
        Object2IntOpenHashMap rowCounts = (Object2IntOpenHashMap)h$3.get(rowBc);
        String possibleIds = (String)globalReferenceOpt$1.map((Function1<Reference, String> & Serializable)globalReference -> globalReference.idsForBarcode(rowBc).mkString(",")).getOrElse((Function0<String> & Serializable)() -> "");
        Seq counts = (Seq)colReference$2.allBarcodes().map((Function1<String, Object> & Serializable)colBc -> BoxesRunTime.boxToInteger(rowCounts.getInt(colBc)));
        int total = BoxesRunTime.unboxToInt(counts.sum(Numeric$IntIsIntegral$.MODULE$));
        pw$1.println(new StringBuilder(3).append(rowBc).append("\t").append(total).append("\t").append(counts.mkString("\t")).append("\t").append(possibleIds).toString());
    }

    public static final /* synthetic */ void $anonfun$parseFile$1(File file$1, scala.collection.mutable.Map r$3, Object2ObjectMap h$4, BufferedSource src) {
        package$ZipWithIndex1$.MODULE$.zipWithIndex1$extension(package$.MODULE$.ZipWithIndex1(src.getLines())).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Serializable serializable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            String line = (String)tuple2._1();
            int lineNo = tuple2._2$mcI$sp();
            if (line == null) throw new MatchError(tuple2);
            String string = line;
            if (!true) throw new MatchError(tuple2);
            int n = lineNo;
            String[] fields = string.split(",", -1);
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(fields)) != 2) {
                if (log.isWarnEnabled()) {
                    log.warn(new StringBuilder(38).append("Found ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(fields))).append(" fields on line ").append(n).append(" of ").append(file$1).append(", expected 2").toString());
                    serializable = BoxedUnit.UNIT;
                    return serializable;
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                return serializable;
            } else {
                String rowBc = fields[0];
                String colBc = fields[1];
                r$3.put(rowBc, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(r$3.getOrElseUpdate(rowBc, () -> 0)) + 1));
                h$4.putIfAbsent(rowBc, new Object2IntOpenHashMap());
                serializable = BoxesRunTime.boxToInteger(((Object2IntOpenHashMap)h$4.get(rowBc)).addTo(colBc, 1));
            }
            return serializable;
        });
    }

    public static final /* synthetic */ int $anonfun$truncateToN$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int count = tuple2._2$mcI$sp();
        int n = -count;
        return n;
    }

    private UnexpectedSequenceWriter$() {
    }
}

