/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.PositionalBufferedStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class BinaryFeatureCodec<T extends Feature>
implements FeatureCodec<T, PositionalBufferedStream> {
    @Override
    public PositionalBufferedStream makeSourceFromStream(InputStream bufferedInputStream) {
        if (bufferedInputStream instanceof PositionalBufferedStream) {
            return (PositionalBufferedStream)bufferedInputStream;
        }
        return new PositionalBufferedStream(bufferedInputStream);
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        return this.makeSourceFromStream(bufferedInputStream);
    }

    @Override
    public void close(PositionalBufferedStream source2) {
        CloserUtil.close(source2);
    }

    @Override
    public boolean isDone(PositionalBufferedStream source2) {
        try {
            return source2.isDone();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failure reading from stream.", e);
        }
    }

    @Override
    public final TabixFormat getTabixFormat() {
        throw new TribbleException("Binary codecs does not support tabix");
    }
}

