/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3;

import cats.implicits$;
import cats.syntax.OptionIdOps$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.PoolQConfig;
import org.broadinstitute.gpp.poolq3.PoolQConfig$;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.package$;
import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.OpenHashMapHistogram;
import org.broadinstitute.gpp.poolq3.hist.TupleHistogram;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.NoOpConsumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import org.broadinstitute.gpp.poolq3.process.ScoringConsumer;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.process.State$;
import org.broadinstitute.gpp.poolq3.reference.ExactReference;
import org.broadinstitute.gpp.poolq3.reference.ExactReference$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.BarcodeCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter$;
import org.broadinstitute.gpp.poolq3.reports.CountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.LogNormalizedCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.QualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.RunInfoWriter$;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter$;
import org.broadinstitute.gpp.poolq3.types.BarcodeCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.CountsFileType$;
import org.broadinstitute.gpp.poolq3.types.LogNormalizedCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.OutputFileType;
import org.broadinstitute.gpp.poolq3.types.PoolQRunSummary;
import org.broadinstitute.gpp.poolq3.types.PoolQSummary;
import org.broadinstitute.gpp.poolq3.types.QualityFileType$;
import org.broadinstitute.gpp.poolq3.types.RunInfoFileType$;
import org.broadinstitute.gpp.poolq3.types.UnexpectedSequencesFileType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.control.NonFatal$;

public final class PoolQ$ {
    public static final PoolQ$ MODULE$ = new PoolQ$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.PoolQ");
    private static final Set<OutputFileType> AlwaysWrittenFiles;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        AlwaysWrittenFiles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OutputFileType[]{CountsFileType$.MODULE$, QualityFileType$.MODULE$, LogNormalizedCountsFileType$.MODULE$, BarcodeCountsFileType$.MODULE$, RunInfoFileType$.MODULE$}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    /*
     * Unable to fully structure code
     */
    public final void main(String[] args) {
        block5: {
            block6: {
                block8: {
                    block7: {
                        block4: {
                            var4_2 = PoolQConfig$.MODULE$.parse(args);
                            if (!None$.MODULE$.equals(var4_2)) break block4;
                            System.exit(-1);
                            var2_3 = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (!(var4_2 instanceof Some)) break block6;
                        var5_5 = (Some)var4_2;
                        config = (PoolQConfig)var5_5.value();
                        var7_7 = false;
                        var8_8 = null;
                        var9_9 = this.run(config);
                        if (!(var9_9 instanceof Success)) break block7;
                        var3_10 = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!(var9_9 instanceof Failure)) ** GOTO lbl-1000
                    var7_7 = true;
                    var8_8 = (Failure)var9_9;
                    var10_13 = var8_8.exception();
                    if (var10_13 != null && !(var11_14 = NonFatal$.MODULE$.unapply(var10_13)).isEmpty()) {
                        t = var11_14.get();
                        PoolQ$.log.error("PoolQ failed", t);
                        System.exit(-1);
                        var3_11 = BoxedUnit.UNIT;
                    } else if (var7_7) {
                        System.exit(-1);
                        var3_12 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(var9_9);
                    }
                }
                var2_4 = BoxedUnit.UNIT;
                break block5;
            }
            throw new MatchError(var4_2);
        }
    }

    public final Try<PoolQSummary> run(PoolQConfig config) {
        LazyRef unexpectedSequenceCacheDir$lzy = new LazyRef();
        if (log.isInfoEnabled()) {
            log.info(PoolQConfig$.MODULE$.summarize(config));
        }
        log.info("Reading row reference data");
        ReferenceData rowReferenceData = ReferenceData$.MODULE$.apply(config.input().rowReference(), ReferenceData$.MODULE$.apply$default$2());
        log.info("Reading column reference data");
        ReferenceData colReferenceData = ReferenceData$.MODULE$.apply(config.input().colReference(), ReferenceData$.MODULE$.apply$default$2());
        Option<Path> option = config.input().globalReference();
        log.info("Reading global reference data");
        Option globalReferenceDataOpt = option.map((Function1<Path, ReferenceData> & Serializable)x$1 -> ReferenceData$.MODULE$.apply((Path)x$1, ReferenceData$.MODULE$.apply$default$2()));
        BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(config.rowBarcodePolicyStr(), rowReferenceData.barcodeLength(), config.skipShortReads());
        BarcodePolicy colBarcodePolicy = BarcodePolicy$.MODULE$.apply(config.colBarcodePolicyStr(), colReferenceData.barcodeLength(), config.skipShortReads());
        log.info("Building row reference");
        Reference rowReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.rowMatchFn(), ReferenceData$.MODULE$.truncator(rowBarcodePolicy.length()), config.countAmbiguous(), rowReferenceData.mappings());
        log.info("Building column reference");
        Reference colReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.colMatchFn(), ReferenceData$.MODULE$.truncator(colBarcodePolicy.length()), config.countAmbiguous(), colReferenceData.mappings());
        Option globalReference = globalReferenceDataOpt.map((Function1<ReferenceData, ExactReference> & Serializable)referenceData -> {
            log.info("Building global reference");
            return ExactReference$.MODULE$.apply(referenceData.mappings(), (Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x), false);
        });
        CloseableIterable<Barcodes> barcodes = package$.MODULE$.barcodeSource(config.input(), rowBarcodePolicy, colBarcodePolicy);
        State state = new State(new TupleHistogram<String>(), new OpenHashMapHistogram<String>(), new OpenHashMapHistogram<String>(), State$.MODULE$.$lessinit$greater$default$4(), State$.MODULE$.$lessinit$greater$default$5(), State$.MODULE$.$lessinit$greater$default$6(), State$.MODULE$.$lessinit$greater$default$7(), State$.MODULE$.$lessinit$greater$default$8(), State$.MODULE$.$lessinit$greater$default$9(), State$.MODULE$.$lessinit$greater$default$10());
        Consumer consumer = config.noopConsumer() ? new NoOpConsumer() : new ScoringConsumer(rowReference, colReference, config.countAmbiguous(), PoolQ$.unexpectedSequenceCacheDir$1(unexpectedSequenceCacheDir$lzy, config), state);
        return this.runProcess(barcodes, consumer).flatMap((Function1<PoolQRunSummary, Try> & Serializable)ret -> {
            Histogram<Tuple2<String, String>> counts = state.known();
            return Try$.MODULE$.apply(() -> {
                block0: {
                    if (!log.isInfoEnabled()) break block0;
                    log.info(new StringBuilder(20).append("Writing counts file ").append(config.output().countsFile()).toString());
                }
            }).flatMap((Function1<BoxedUnit, Try> & Serializable)x$20 -> {
                BoxedUnit boxedUnit = x$20;
                Try try_ = CountsWriter$.MODULE$.write(config.output().countsFile(), counts, rowReference, colReference, config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$3 -> {
                    BoxedUnit boxedUnit;
                    if (log.isInfoEnabled()) {
                        log.info(new StringBuilder(21).append("Writing quality file ").append(config.output().qualityFile()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return QualityWriter$.MODULE$.write(config.output().qualityFile(), state, rowReference, colReference).flatMap((Function1<BoxedUnit, Try> & Serializable)x$5 -> {
                        BoxedUnit boxedUnit;
                        if (log.isInfoEnabled()) {
                            log.info(new StringBuilder(35).append("Writing log-normalized counts file ").append(config.output().normalizedCountsFile()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        Map<String, Map<String, Object>> normalizedCounts = LogNormalizedCountsWriter$.MODULE$.logNormalizedCounts(counts, rowReference, colReference);
                        return LogNormalizedCountsWriter$.MODULE$.write(config.output().normalizedCountsFile(), normalizedCounts, rowReference, colReference, config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$7 -> {
                            BoxedUnit boxedUnit;
                            if (log.isInfoEnabled()) {
                                log.info(new StringBuilder(28).append("Writing barcode counts file ").append(config.output().barcodeCountsFile()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return BarcodeCountsWriter$.MODULE$.write(config.output().barcodeCountsFile(), counts, rowReference, colReference, config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$9 -> {
                                BoxedUnit boxedUnit;
                                if (log.isInfoEnabled()) {
                                    log.info(new StringBuilder(25).append("Writing correlation file ").append(config.output().correlationFile()).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return CorrelationFileWriter$.MODULE$.write(config.output().correlationFile(), normalizedCounts, rowReference, colReference).flatMap((Function1<Option, Try> & Serializable)cfto -> ((Try)PoolQ$.unexpectedSequenceCacheDir$1(unexpectedSequenceCacheDir$lzy, config).fold((Function0<Try> & Serializable)() -> Try$.MODULE$.apply((Function0<Option> & Serializable)() -> Option$.MODULE$.empty()), (Function1<Path, Try> & Serializable)dir -> {
                                    Try<BoxedUnit> ret;
                                    block2: {
                                        if (log.isInfoEnabled()) {
                                            log.info(new StringBuilder(35).append("Writing unexpected sequence report ").append(config.output().unexpectedSequencesFile()).toString());
                                        }
                                        ret = implicits$.MODULE$.toFunctorOps(UnexpectedSequenceWriter$.MODULE$.write(config.output().unexpectedSequencesFile(), (Path)dir, config.unexpectedSequencesToReport(), colReference, globalReference), implicits$.MODULE$.catsStdInstancesForTry()).as(OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId(UnexpectedSequencesFileType$.MODULE$)));
                                        if (!config.removeUnexpectedSequenceCache()) break block2;
                                        if (log.isInfoEnabled()) {
                                            log.info(new StringBuilder(35).append("Removing unexpected sequence cache ").append(config.unexpectedSequenceCacheDir()).toString());
                                        }
                                        UnexpectedSequenceWriter$.MODULE$.removeCache((Path)dir);
                                    }
                                    return ret;
                                })).flatMap((Function1<Option, Try> & Serializable)usfto -> {
                                    BoxedUnit boxedUnit;
                                    if (log.isInfoEnabled()) {
                                        log.info(new StringBuilder(17).append("Writing run info ").append(config.output().unexpectedSequencesFile()).toString());
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit2 = boxedUnit;
                                    return RunInfoWriter$.MODULE$.write(config.output().runInfoFile(), config).map((Function1<BoxedUnit, PoolQSummary> & Serializable)x$12 -> {
                                        log.info("PoolQ complete");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return new PoolQSummary((PoolQRunSummary)ret, (Set)AlwaysWrittenFiles.$plus$plus((IterableOnce)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{cfto, usfto}))).flatten(Predef$.MODULE$.$conforms())));
                                    });
                                }));
                            });
                        });
                    });
                });
                return try_;
            });
        });
    }

    public Try<PoolQRunSummary> runProcess(CloseableIterable<Barcodes> barcodes, Consumer consumer) {
        return Using$.MODULE$.apply((Function0<CloseableIterator> & Serializable)() -> barcodes.iterator(), (Function1<CloseableIterator, PoolQRunSummary> & Serializable)iterator -> {
            PoolQProcess process = new PoolQProcess((Iterator<Barcodes>)iterator, consumer, PoolQProcess$.MODULE$.$lessinit$greater$default$3(), PoolQProcess$.MODULE$.$lessinit$greater$default$4());
            return process.run();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$run$6(Path path) {
        block0: {
            if (!log.isInfoEnabled()) break block0;
            log.info(new StringBuilder(43).append("Writing unexpected sequence cache files to ").append(path).toString());
        }
    }

    private static final /* synthetic */ Option unexpectedSequenceCacheDir$lzycompute$1(LazyRef unexpectedSequenceCacheDir$lzy$1, PoolQConfig config$1) {
        Option option;
        LazyRef lazyRef = unexpectedSequenceCacheDir$lzy$1;
        synchronized (lazyRef) {
            Option option2;
            if (unexpectedSequenceCacheDir$lzy$1.initialized()) {
                option2 = (Option)unexpectedSequenceCacheDir$lzy$1.value();
            } else {
                Option option3;
                if (config$1.skipUnexpectedSequenceReport()) {
                    option3 = None$.MODULE$;
                } else {
                    Option ret = config$1.unexpectedSequenceCacheDir().map((Function1<Path, Path> & Serializable)x$2 -> Files.createDirectories(x$2, new FileAttribute[0])).orElse((Function0<Some> & Serializable)() -> {
                        Path ret = Files.createTempDirectory("unexpected-sequence-cache", new FileAttribute[0]);
                        return new Some<Path>(ret);
                    });
                    ret.foreach((Function1<Path, Object> & Serializable)path -> {
                        PoolQ$.$anonfun$run$6(path);
                        return BoxedUnit.UNIT;
                    });
                    option3 = ret;
                }
                option2 = unexpectedSequenceCacheDir$lzy$1.initialize(option3);
            }
            option = option2;
        }
        return option;
    }

    private static final Option unexpectedSequenceCacheDir$1(LazyRef unexpectedSequenceCacheDir$lzy$1, PoolQConfig config$1) {
        return unexpectedSequenceCacheDir$lzy$1.initialized() ? (Option)unexpectedSequenceCacheDir$lzy$1.value() : PoolQ$.unexpectedSequenceCacheDir$lzycompute$1(unexpectedSequenceCacheDir$lzy$1, config$1);
    }

    private PoolQ$() {
    }
}

