/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.ScoringConsumer$;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001B\u000b\u0017\u0005\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\r]\u0003\u0001\u0015!\u0003Y\u0011\u0019q\u0006\u0001)A\u0005?\"1\u0001\u000f\u0001Q\u0001\nEDa!\u001e\u0001!B\u00139\u0004B\u0002>\u0001A\u0003%1\u0010C\u0003\u007f\u0001\u0011\u0005s\u0010\u0003\u0004\u0002\b\u0001!\te \u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011!\ti\u0002\u0001Q\u0005\n\u0005}\u0001\u0002CA'\u0001\u0001&I!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011q\f\u0001\u0005B\u0005]\u0003bBA1\u0001\u0011\u0005\u00131\r\u0002\u0010'\u000e|'/\u001b8h\u0007>t7/^7fe*\u0011q\u0003G\u0001\baJ|7-Z:t\u0015\tI\"$\u0001\u0004q_>d\u0017o\r\u0006\u00037q\t1a\u001a9q\u0015\tib$\u0001\bce>\fG-\u001b8ti&$X\u000f^3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0012+!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u00142kK\u000e$\bCA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005!\u0019uN\\:v[\u0016\u0014\u0018\u0001\u0004:poJ+g-\u001a:f]\u000e,\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0019\u0003%\u0011XMZ3sK:\u001cW-\u0003\u00025c\tI!+\u001a4fe\u0016t7-Z\u0001\rG>d'+\u001a4fe\u0016t7-Z\u0001\u000fG>,h\u000e^!nE&<Wo\\;t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0011un\u001c7fC:\fQ#\u001e8fqB,7\r^3e%\u0016\u0004xN\u001d;DC\u000eDW\rE\u00029\u007f\u0005K!\u0001Q\u001d\u0003\r=\u0003H/[8o!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003gS2,'B\u0001$'\u0003\rq\u0017n\\\u0005\u0003\u0011\u000e\u0013A\u0001U1uQ\u0006)1\u000f^1uKV\t1\n\u0005\u0002,\u0019&\u0011QJ\u0006\u0002\u0006'R\fG/Z\u0001\u0007gR\fG/\u001a\u0011\u0002\rqJg.\u001b;?)\u0019\t&k\u0015+V-B\u00111\u0006\u0001\u0005\u0006]\u001d\u0001\ra\f\u0005\u0006k\u001d\u0001\ra\f\u0005\u0006m\u001d\u0001\ra\u000e\u0005\u0006{\u001d\u0001\rA\u0010\u0005\u0006\u0013\u001e\u0001\raS\u0001\u0004Y><\u0007CA-]\u001b\u0005Q&BA.\u001f\u0003\u0015awn\u001a\u001bt\u0013\ti&L\u0001\u0004M_\u001e<WM]\u0001\u0018k:,\u0007\u0010]3di\u0016$7+Z9vK:\u001cW-U;fk\u0016\u00042\u0001Y3h\u001b\u0005\t'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u001a\nA!\u001e;jY&\u0011a-\u0019\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u00039Q*T\u0017BA5:\u0005\u0019!V\u000f\u001d7feA\u0019\u0001h[7\n\u00051L$!B!se\u0006L\bC\u0001\u001do\u0013\ty\u0017H\u0001\u0003DQ\u0006\u0014\u0018\u0001H;oKb\u0004Xm\u0019;fIN+\u0017/^3oG\u0016$&/Y2lKJ|\u0005\u000f\u001e\t\u0004q}\u0012\bCA\u0016t\u0013\t!hCA\rV]\u0016D\b/Z2uK\u0012\u001cV-];f]\u000e,GK]1dW\u0016\u0014\u0018\u0001\u00023p]\u0016D#aC<\u0011\u0005aB\u0018BA=:\u0005!1x\u000e\\1uS2,\u0017aH;oKb\u0004Xm\u0019;fIN+\u0017/^3oG\u0016$&/Y2lKJ$\u0006N]3bIB\u00111\u0005`\u0005\u0003{\u0012\u0012a\u0001\u00165sK\u0006$\u0017!B:uCJ$HCAA\u0001!\rA\u00141A\u0005\u0004\u0003\u000bI$\u0001B+oSR\fQa\u00197pg\u0016\fqaY8ogVlW\r\u0006\u0003\u0002\u0002\u00055\u0001bBA\b\u001f\u0001\u0007\u0011\u0011C\u0001\u000ea\u0006\u00148/\u001a3CCJ\u001cw\u000eZ3\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0019\u0003\u001d\u0011\u0017M]2pI\u0016LA!a\u0007\u0002\u0016\tA!)\u0019:d_\u0012,7/\u0001\rva\u0012\fG/Z\"pYVlgNQ1sG>$Wm\u0015;biN$b!!\u0001\u0002\"\u0005\r\u0003bBA\u0012!\u0001\u0007\u0011QE\u0001\u0006G>d'i\u0019\t\u0007\u0003O\t9$!\u0010\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014bAA\u001bs\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u00111aU3r\u0015\r\t)$\u000f\t\u0004a\u0005}\u0012bAA!c\tqQ*\u0019;dQ\u0016$')\u0019:d_\u0012,\u0007bBA#!\u0001\u0007\u0011qI\u0001\u0004G>d\u0007\u0003BA\n\u0003\u0013JA!a\u0013\u0002\u0016\taai\\;oI\n\u000b'oY8eK\u0006iR\u000f\u001d3bi\u0016\u0014vn\u001e\"be\u000e|G-\u001a)pg&$\u0018n\u001c8Ti\u0006$8\u000f\u0006\u0003\u0002\u0002\u0005E\u0003bBA*#\u0001\u0007\u0011qI\u0001\u0004e><\u0018A\u0004:fC\u0012\u001c\bK]8dKN\u001cX\rZ\u000b\u0003\u00033\u00022\u0001OA.\u0013\r\ti&\u000f\u0002\u0004\u0013:$\u0018!D7bi\u000eD\u0017N\\4SK\u0006$7/\u0001\u0007nCR\u001c\u0007\u000eU3sG\u0016tG/\u0006\u0002\u0002fA\u0019\u0001(a\u001a\n\u0007\u0005%\u0014HA\u0003GY>\fG\u000f")
public final class ScoringConsumer
implements Consumer {
    private final Reference rowReference;
    private final Reference colReference;
    private final boolean countAmbiguous;
    private final Option<Path> unexpectedReportCache;
    private final State state;
    public final Logger org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log;
    public final ArrayBlockingQueue<Tuple2<char[], char[]>> org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue;
    public final Option<UnexpectedSequenceTracker> org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt;
    public volatile boolean org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done;
    private final Thread unexpectedSequenceTrackerThread;
    private volatile byte bitmap$init$0;

    public State state() {
        return this.state;
    }

    @Override
    public void start() {
        this.unexpectedReportCache.foreach((Function1<Path, Object> & Serializable)x$2 -> {
            this.unexpectedSequenceTrackerThread.start();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void close() {
        this.unexpectedReportCache.foreach((Function1<Path, Object> & Serializable)x$3 -> {
            ScoringConsumer.$anonfun$close$1(this, x$3);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void consume(Barcodes parsedBarcode) {
        this.state().reads_$eq(this.state().reads() + 1);
        if (parsedBarcode.row().isDefined()) {
            FoundBarcode parsedRow = parsedBarcode.row().get();
            this.updateRowBarcodePositionStats(parsedRow);
            Seq<MatchedBarcode> rowBc = this.rowReference.find(parsedRow.barcode());
            if (parsedBarcode.col().isDefined()) {
                FoundBarcode parsedCol = parsedBarcode.col().get();
                Seq<MatchedBarcode> colBc = this.colReference.find(parsedCol.barcode());
                this.updateColumnBarcodeStats(colBc, parsedCol);
                rowBc.foreach((Function1<MatchedBarcode, Object> & Serializable)row -> {
                    colBc.foreach((Function1<MatchedBarcode, Object> & Serializable)col -> {
                        ScoringConsumer.$anonfun$consume$2($this, row, col);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                if (this.unexpectedReportCache.isDefined() && colBc.nonEmpty() && rowBc.isEmpty() && !org.broadinstitute.gpp.poolq3.seq.package$.MODULE$.containsN(parsedRow.barcode())) {
                    this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.put(new Tuple2<char[], char[]>(parsedRow.barcode(), parsedCol.barcode()));
                }
            }
        } else {
            this.state().rowBarcodeNotFound_$eq(this.state().rowBarcodeNotFound() + 1);
        }
    }

    private void updateColumnBarcodeStats(Seq<MatchedBarcode> colBc, FoundBarcode col) {
        block1: {
            block0: {
                if (!this.countAmbiguous && colBc.lengthCompare(1) != 0) break block0;
                colBc.foreach((Function1<MatchedBarcode, Object> & Serializable)mb -> BoxesRunTime.boxToInteger(ScoringConsumer.$anonfun$updateColumnBarcodeStats$1(this, mb)));
                break block1;
            }
            if (!colBc.isEmpty() || org.broadinstitute.gpp.poolq3.seq.package$.MODULE$.containsN(col.barcode())) break block1;
            int n = this.state().unknownCol().increment(new String(col.barcode()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    private void updateRowBarcodePositionStats(FoundBarcode row) {
        this.state().minRowBarcodePos_$eq(package$.MODULE$.min(this.state().minRowBarcodePos(), row.offset0()));
        this.state().maxRowBarcodePos_$eq(package$.MODULE$.max(this.state().maxRowBarcodePos(), row.offset0()));
        this.state().rowBarcodePosSum_$eq(this.state().rowBarcodePosSum() + (long)row.offset0());
    }

    @Override
    public int readsProcessed() {
        return this.state().reads();
    }

    @Override
    public int matchingReads() {
        return this.state().matches();
    }

    @Override
    public float matchPercent() {
        return (float)this.state().matchPercent();
    }

    public static final /* synthetic */ void $anonfun$close$1(ScoringConsumer $this, Path x$3) {
        $this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done = true;
        $this.unexpectedSequenceTrackerThread.join();
        $this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.foreach((Function1<UnexpectedSequenceTracker, Object> & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$consume$2(ScoringConsumer $this, MatchedBarcode row$1, MatchedBarcode col) {
        block1: {
            String r = row$1.barcode();
            String c = col.barcode();
            if ($this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log.isDebugEnabled()) {
                $this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log.debug(new StringBuilder(29).append("Incrementing state for (").append(r).append(", ").append(c).append("}).").toString());
            }
            $this.state().known().increment(new Tuple2<String, String>(r, c));
            $this.state().matches_$eq($this.state().matches() + 1);
            if (row$1.distance() != 0) break block1;
            $this.state().exactMatches_$eq($this.state().exactMatches() + 1);
        }
    }

    public static final /* synthetic */ int $anonfun$updateColumnBarcodeStats$1(ScoringConsumer $this, MatchedBarcode mb) {
        return $this.state().knownCol().increment(mb.barcode());
    }

    public ScoringConsumer(Reference rowReference, Reference colReference, boolean countAmbiguous, Option<Path> unexpectedReportCache, State state) {
        this.rowReference = rowReference;
        this.colReference = colReference;
        this.countAmbiguous = countAmbiguous;
        this.unexpectedReportCache = unexpectedReportCache;
        this.state = state;
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log = LoggerFactory.getLogger(ScoringConsumer.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue = new ArrayBlockingQueue(1000);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt = unexpectedReportCache.map((Function1<Path, UnexpectedSequenceTracker> & Serializable)x$1 -> new UnexpectedSequenceTracker((Path)x$1));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.unexpectedSequenceTrackerThread = new Thread(this){
            private final /* synthetic */ ScoringConsumer $outer;

            public final void run() {
                Predef$.MODULE$.assert(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.isDefined());
                UnexpectedSequenceTracker unexpectedSequenceTracker = this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.get();
                while (!this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done || !this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.isEmpty()) {
                    try {
                        Option$.MODULE$.apply(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.poll(100L, TimeUnit.MILLISECONDS)).foreach((Function1<Tuple2, Object> & Serializable)barcodes -> {
                            $anon$1.$anonfun$run$1(unexpectedSequenceTracker, barcodes);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log.isDebugEnabled()) continue;
                        this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log.debug(new StringBuilder(37).append("Interrupted. Done = ").append(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done).append("; queue length = ").append(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.size()).toString());
                    }
                }
            }

            public static final /* synthetic */ void $anonfun$run$1(UnexpectedSequenceTracker unexpectedSequenceTracker$1, Tuple2 barcodes) {
                unexpectedSequenceTracker$1.reportUnexpected(barcodes);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker scala.Tuple2 )}, serializedLambda);
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

