/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.numeric.package$;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class QualityWriter$ {
    public static final QualityWriter$ MODULE$ = new QualityWriter$();

    public Try<BoxedUnit> write(Path file, State state, Reference rowReference, Reference colReference) {
        return Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(file.toFile()), (Function1<PrintWriter, Object> & Serializable)writer -> {
            QualityWriter$.$anonfun$write$2(state, colReference, rowReference, writer);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private <A> Seq<String> perBarcodeQualityData(State state, Reference rowReference, Reference colReference, String colBarcode) {
        String conditions = colReference.idsForBarcode(colBarcode).mkString(",");
        int matchedRowAndCol = BoxesRunTime.unboxToInt(((IterableOnceOps)rowReference.allBarcodes().map((Function1<String, Object> & Serializable)rowBarcode -> BoxesRunTime.boxToInteger(QualityWriter$.$anonfun$perBarcodeQualityData$1(state, colBarcode, rowBarcode)))).sum(Numeric$IntIsIntegral$.MODULE$));
        int matchedCol = state.knownCol().count(colBarcode);
        double pct = package$.MODULE$.percent(matchedRowAndCol, matchedCol);
        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{colReference.referenceBarcodeForDnaBarcode(colBarcode), conditions, ((Object)BoxesRunTime.boxToInteger(matchedRowAndCol)).toString(), ((Object)BoxesRunTime.boxToInteger(matchedCol)).toString(), package$.MODULE$.Decimal00Format().format(pct), package$.MODULE$.Decimal000Format().format(package$.MODULE$.logNormalize(matchedRowAndCol, state.reads()))}));
    }

    public static final /* synthetic */ String $anonfun$write$3(double x$1) {
        return package$.MODULE$.Decimal00Format().format(x$1);
    }

    public static final /* synthetic */ void $anonfun$write$5(State state$1, Reference rowReference$1, Reference colReference$1, PrintWriter writer$1, String colBarcode) {
        Seq<String> data = MODULE$.perBarcodeQualityData(state$1, rowReference$1, colReference$1, colBarcode);
        writer$1.println(data.mkString("\t"));
    }

    public static final /* synthetic */ void $anonfun$write$8(PrintWriter writer$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int count = tuple2._1$mcI$sp();
        String barcode = (String)tuple2._2();
        writer$1.println(new StringBuilder(1).append(barcode).append("\t").append(((Object)BoxesRunTime.boxToInteger(count)).toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$write$2(State state$1, Reference colReference$1, Reference rowReference$1, PrintWriter writer) {
        String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(319).append("Total reads: ").append(state$1.reads()).append("\n           |Matching reads: ").append(state$1.matches()).append("\n           |1-base mismatch reads: ").append(state$1.matches() - state$1.exactMatches()).append("\n           |\n           |Overall % match: ").append(package$.MODULE$.Decimal00Format().format(state$1.matchPercent())).append("\n           |\n           |Reads with no construct barcode: ").append(state$1.rowBarcodeNotFound()).append("\n           |Max construct barcode index: ").append(state$1.maxRowBarcodePos() < 0 ? "N/A" : BoxesRunTime.boxToInteger(state$1.maxRowBarcodePos())).append("\n           |Min construct barcode index: ").append(state$1.minRowBarcodePos() == Integer.MAX_VALUE ? "N/A" : BoxesRunTime.boxToInteger(state$1.minRowBarcodePos())).append("\n           |Avg construct barcode index: ").append(state$1.avgRowBarcodeIndex().map((Function1<Object, String> & Serializable)x$1 -> QualityWriter$.$anonfun$write$3(BoxesRunTime.unboxToDouble(x$1))).getOrElse((Function0<String> & Serializable)() -> "N/A")).append("\n           |").toString()));
        writer.println(header);
        writer.println("Read counts for sample barcodes with associated conditions:");
        writer.println("Barcode\tCondition\tMatched (Construct+Sample Barcode)\tMatched Sample Barcode\t% Match\tNormalized Match");
        colReference$1.allBarcodes().foreach((Function1<String, Object> & Serializable)colBarcode -> {
            QualityWriter$.$anonfun$write$5(state$1, rowReference$1, colReference$1, writer, colBarcode);
            return BoxedUnit.UNIT;
        });
        writer.println();
        writer.println("Read counts for most common sample barcodes without associated conditions:");
        ((IterableOnceOps)((IterableOps)((IterableOnceOps)state$1.unknownCol().keys().map((Function1<String, Tuple2> & Serializable)barcode -> new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(state$1.unknownCol().count((String)barcode)), (String)barcode))).toSeq().sortBy((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int c = tuple2._1$mcI$sp();
            String b = (String)tuple2._2();
            Tuple2<Integer, String> tuple22 = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-c), b);
            return tuple22;
        }, Ordering$.MODULE$.Tuple2(Ordering$Int$.MODULE$, Ordering$String$.MODULE$))).take(100)).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            QualityWriter$.$anonfun$write$8(writer, x0$2);
            return BoxedUnit.UNIT;
        });
        writer.println();
    }

    public static final /* synthetic */ int $anonfun$perBarcodeQualityData$1(State state$2, String colBarcode$1, String rowBarcode) {
        return state$2.known().count(new Tuple2<String, String>(rowBarcode, colBarcode$1));
    }

    private QualityWriter$() {
    }
}

