/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.IndexStreamBuffer;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.MemoryMappedFileBuffer;
import htsjdk.samtools.RandomAccessFileBuffer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBAMFileIndex
implements BAMIndex {
    private final IndexFileBuffer mIndexBuffer;
    private final SAMSequenceDictionary mBamDictionary;
    long[] sequenceIndexes;

    protected AbstractBAMFileIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        this(new IndexStreamBuffer(stream), stream.getSource(), dictionary);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        this(new MemoryMappedFileBuffer(file), file.getName(), dictionary);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        this(useMemoryMapping ? new MemoryMappedFileBuffer(file) : new RandomAccessFileBuffer(file), file.getName(), dictionary);
    }

    protected AbstractBAMFileIndex(IndexFileBuffer indexFileBuffer, String source2, SAMSequenceDictionary dictionary) {
        this.mIndexBuffer = indexFileBuffer;
        this.mBamDictionary = dictionary;
        this.verifyIndexMagicNumber(source2);
        this.initParameters();
    }

    @Override
    public void close() {
        this.mIndexBuffer.close();
    }

    public static int getNumIndexLevels() {
        return GenomicIndexUtil.LEVEL_STARTS.length;
    }

    private static void assertLevelIsValid(int levelNumber) {
        if (levelNumber >= AbstractBAMFileIndex.getNumIndexLevels()) {
            throw new SAMException("Level number (" + levelNumber + ") is greater than or equal to maximum (" + AbstractBAMFileIndex.getNumIndexLevels() + ").");
        }
    }

    public static int getFirstBinInLevel(int levelNumber) {
        AbstractBAMFileIndex.assertLevelIsValid(levelNumber);
        return GenomicIndexUtil.LEVEL_STARTS[levelNumber];
    }

    public int getLevelSize(int levelNumber) {
        AbstractBAMFileIndex.assertLevelIsValid(levelNumber);
        if (levelNumber == AbstractBAMFileIndex.getNumIndexLevels() - 1) {
            return 37450 - GenomicIndexUtil.LEVEL_STARTS[levelNumber] - 1;
        }
        return GenomicIndexUtil.LEVEL_STARTS[levelNumber + 1] - GenomicIndexUtil.LEVEL_STARTS[levelNumber];
    }

    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() >= 37450) {
            throw new SAMException("Tried to get level for invalid bin.");
        }
        for (int i = AbstractBAMFileIndex.getNumIndexLevels() - 1; i >= 0; --i) {
            if (bin.getBinNumber() < GenomicIndexUtil.LEVEL_STARTS[i]) continue;
            return i;
        }
        throw new SAMException("Unable to find correct bin for bin " + bin);
    }

    public int getFirstLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = GenomicIndexUtil.LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : GenomicIndexUtil.LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart) * (0x20000000 / levelSize) + 1;
    }

    public int getLastLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = GenomicIndexUtil.LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : GenomicIndexUtil.LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart + 1) * (0x20000000 / levelSize);
    }

    public int getNumberOfReferences() {
        this.seek(4L);
        return this.readInteger();
    }

    @Override
    public long getStartOfLastLinearBin() {
        this.seek(4L);
        int sequenceCount = this.readInteger();
        long lastLinearIndexPointer = -1L;
        for (int i = 0; i < sequenceCount; ++i) {
            int nBins = this.readInteger();
            for (int j1 = 0; j1 < nBins; ++j1) {
                this.skipBytes(4);
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            if (nLinearBins <= 0) continue;
            this.skipBytes(8 * (nLinearBins - 1));
            lastLinearIndexPointer = this.readLong();
        }
        return lastLinearIndexPointer;
    }

    @Override
    public BAMIndexMetaData getMetaData(int reference) {
        this.seek(4L);
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.readInteger();
        if (reference >= sequenceCount) {
            return null;
        }
        this.skipToSequence(reference);
        int binCount = this.readInteger();
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            int indexBin = this.readInteger();
            int nChunks = this.readInteger();
            if (indexBin == 37450) {
                this.readChunks(nChunks, metaDataChunks);
                continue;
            }
            this.skipBytes(16 * nChunks);
        }
        return new BAMIndexMetaData(metaDataChunks);
    }

    public Long getNoCoordinateCount() {
        this.seek(4L);
        int sequenceCount = this.readInteger();
        this.skipToSequence(sequenceCount);
        try {
            return this.readLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        this.seek(4L);
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.readInteger();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        BitSet regionBins = GenomicIndexUtil.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        int binCount = this.readInteger();
        boolean metaDataSeen = false;
        Bin[] bins = new Bin[this.getMaxBinNumberForReference(referenceSequence) + 1];
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            int indexBin = this.readInteger();
            int nChunks = this.readInteger();
            List<Chunk> chunks = null;
            Chunk lastChunk = null;
            if (regionBins.get(indexBin)) {
                chunks = new ArrayList<Chunk>(nChunks);
                this.readChunks(nChunks, chunks);
            } else {
                if (indexBin == 37450) {
                    this.readChunks(nChunks, metaDataChunks);
                    metaDataSeen = true;
                    continue;
                }
                this.skipBytes(16 * nChunks);
                chunks = Collections.emptyList();
            }
            Bin bin = new Bin(referenceSequence, indexBin);
            bin.setChunkList(chunks);
            bin.setLastChunk(lastChunk);
            bins[indexBin] = bin;
        }
        int nLinearBins = this.readInteger();
        int regionLinearBinStart = LinearIndex.convertToLinearIndexOffset(startPos);
        int regionLinearBinStop = endPos > 0 ? LinearIndex.convertToLinearIndexOffset(endPos) : nLinearBins - 1;
        int actualStop = Math.min(regionLinearBinStop, nLinearBins - 1);
        long[] linearIndexEntries = new long[]{};
        if (regionLinearBinStart < nLinearBins) {
            linearIndexEntries = new long[actualStop - regionLinearBinStart + 1];
            this.skipBytes(8 * regionLinearBinStart);
            for (int linearBin = regionLinearBinStart; linearBin <= actualStop; ++linearBin) {
                linearIndexEntries[linearBin - regionLinearBinStart] = this.readLong();
            }
        }
        LinearIndex linearIndex = new LinearIndex(referenceSequence, regionLinearBinStart, linearIndexEntries);
        return new BAMIndexContent(referenceSequence, bins, binCount - (metaDataSeen ? 1 : 0), new BAMIndexMetaData(metaDataChunks), linearIndex);
    }

    private int getMaxBinNumberForReference(int reference) {
        try {
            int sequenceLength = this.mBamDictionary.getSequence(reference).getSequenceLength();
            return AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(sequenceLength);
        }
        catch (Exception e) {
            return 37450;
        }
    }

    static int getMaxBinNumberForSequenceLength(int sequenceLength) {
        return AbstractBAMFileIndex.getFirstBinInLevel(AbstractBAMFileIndex.getNumIndexLevels() - 1) + (sequenceLength >> 14);
    }

    protected abstract BAMIndexContent getQueryResults(int var1);

    protected int getMaxAddressibleGenomicLocation() {
        return 0x20000000;
    }

    @Deprecated
    protected BitSet regionToBins(int startPos, int endPos) {
        return GenomicIndexUtil.regionToBins(startPos, endPos);
    }

    @Deprecated
    protected List<Chunk> optimizeChunkList(List<Chunk> chunks, long minimumOffset) {
        return Chunk.optimizeChunkList(chunks, minimumOffset);
    }

    protected void verifyIndexMagicNumber(String sourceName) {
        this.seek(0L);
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAI_INDEX_MAGIC)) {
            throw new RuntimeIOException("Invalid file header in BAM index " + sourceName + ": " + new String(buffer));
        }
    }

    protected void initParameters() {
        this.setSequenceIndexes(this.getNumberOfReferences());
    }

    protected void readChunks(int nChunks, List<Chunk> chunks) {
        for (int ci = 0; ci < nChunks; ++ci) {
            long chunkBegin = this.readLong();
            long chunkEnd = this.readLong();
            Chunk lastChunk = new Chunk(chunkBegin, chunkEnd);
            chunks.add(lastChunk);
        }
    }

    protected void skipToSequence(int sequenceIndex) {
        int startSequenceIndex;
        if (this.sequenceIndexes[sequenceIndex] != -1L) {
            this.seek(this.sequenceIndexes[sequenceIndex]);
            return;
        }
        int previousSequenceIndex = sequenceIndex - 1;
        if (sequenceIndex > 0 && this.sequenceIndexes[previousSequenceIndex] != -1L) {
            this.seek(this.sequenceIndexes[previousSequenceIndex]);
            startSequenceIndex = previousSequenceIndex;
        } else {
            startSequenceIndex = 0;
        }
        for (int i = startSequenceIndex; i < sequenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                this.readInteger();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            this.skipBytes(8 * nLinearBins);
        }
        this.sequenceIndexes[sequenceIndex] = this.position();
    }

    protected final void readBytes(byte[] bytes) {
        this.mIndexBuffer.readBytes(bytes);
    }

    protected final int readInteger() {
        return this.mIndexBuffer.readInteger();
    }

    protected final long readLong() {
        return this.mIndexBuffer.readLong();
    }

    protected final void skipBytes(int count) {
        this.mIndexBuffer.skipBytes(count);
    }

    protected final void seek(long position) {
        this.mIndexBuffer.seek(position);
    }

    protected final long position() {
        return this.mIndexBuffer.position();
    }

    protected final SAMSequenceDictionary getBamDictionary() {
        return this.mBamDictionary;
    }

    protected final void setSequenceIndexes(int nReferences) {
        this.sequenceIndexes = new long[nReferences + 1];
        Arrays.fill(this.sequenceIndexes, -1L);
    }
}

