/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.SubexponentialIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombLongEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombRiceIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalLongEncoding;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingID;

public class EncodingFactory {
    public static <T> CRAMEncoding<T> createEncoding(DataSeriesType valueType, EncodingID id, byte[] params) {
        switch (valueType) {
            case BYTE: {
                switch (id) {
                    case EXTERNAL: {
                        return ExternalByteEncoding.fromParams(params);
                    }
                    case HUFFMAN: {
                        return CanonicalHuffmanByteEncoding.fromParams(params);
                    }
                }
                break;
            }
            case INT: {
                switch (id) {
                    case HUFFMAN: {
                        return CanonicalHuffmanIntegerEncoding.fromParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalIntegerEncoding.fromParams(params);
                    }
                    case GOLOMB: {
                        return GolombIntegerEncoding.fromParams(params);
                    }
                    case GOLOMB_RICE: {
                        return GolombRiceIntegerEncoding.fromParams(params);
                    }
                    case BETA: {
                        return BetaIntegerEncoding.fromParams(params);
                    }
                    case GAMMA: {
                        return GammaIntegerEncoding.fromParams(params);
                    }
                    case SUBEXPONENTIAL: {
                        return SubexponentialIntegerEncoding.fromParams(params);
                    }
                }
                break;
            }
            case LONG: {
                switch (id) {
                    case GOLOMB: {
                        return GolombLongEncoding.fromParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalLongEncoding.fromParams(params);
                    }
                }
                break;
            }
            case BYTE_ARRAY: {
                switch (id) {
                    case BYTE_ARRAY_LEN: {
                        return ByteArrayLenEncoding.fromParams(params);
                    }
                    case BYTE_ARRAY_STOP: {
                        return ByteArrayStopEncoding.fromParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalByteArrayEncoding.fromParams(params);
                    }
                }
                break;
            }
        }
        throw new IllegalArgumentException("Encoding not found: value type=" + valueType.name() + ", encoding id=" + id.name());
    }
}

