/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiRefSliceAlignmentSpanReader
extends CramRecordReader {
    private final Map<ReferenceContext, AlignmentSpan> spans = new HashMap<ReferenceContext, AlignmentSpan>();

    public MultiRefSliceAlignmentSpanReader(BitInputStream coreInputStream, Map<Integer, ByteArrayInputStream> externalInputMap, CompressionHeader header, ValidationStringency validationStringency, int initialAlignmentStart, int recordCount) {
        super(coreInputStream, externalInputMap, header, ReferenceContext.MULTIPLE_REFERENCE_CONTEXT, validationStringency);
        int prevAlignmentStart = initialAlignmentStart;
        for (int i = 0; i < recordCount; ++i) {
            CramCompressionRecord cramRecord = new CramCompressionRecord();
            prevAlignmentStart = super.read(cramRecord, prevAlignmentStart);
            this.processRecordSpan(cramRecord);
        }
    }

    public Map<ReferenceContext, AlignmentSpan> getReferenceSpans() {
        return Collections.unmodifiableMap(this.spans);
    }

    private void processRecordSpan(CramCompressionRecord cramRecord) {
        AlignmentSpan span;
        boolean mappedCount;
        if (!cramRecord.isPlaced()) {
            this.spans.put(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, AlignmentSpan.UNPLACED_SPAN);
            return;
        }
        if (cramRecord.isSegmentUnmapped()) {
            mappedCount = false;
            boolean unmappedCount = true;
            span = new AlignmentSpan(cramRecord.alignmentStart, cramRecord.readLength, 0, 1);
        } else {
            mappedCount = true;
            boolean unmappedCount = false;
            span = new AlignmentSpan(cramRecord.alignmentStart, cramRecord.readLength, 1, 0);
        }
        ReferenceContext recordContext = new ReferenceContext(cramRecord.sequenceId);
        this.spans.merge(recordContext, span, AlignmentSpan::combine);
    }
}

