/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.core.CoreCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;

class SubexponentialIntegerCodec
extends CoreCodec<Integer> {
    private final int offset;
    private final int k;

    public SubexponentialIntegerCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, int offset, int k) {
        super(coreBlockInputStream, coreBlockOutputStream);
        this.offset = offset;
        this.k = k;
    }

    @Override
    public final Integer read() {
        int n;
        int u = 0;
        while (this.coreBlockInputStream.readBit()) {
            ++u;
        }
        if (u == 0) {
            int b = this.k;
            n = this.coreBlockInputStream.readBits(b);
        } else {
            int b = u + this.k - 1;
            n = 1 << b | this.coreBlockInputStream.readBits(b);
        }
        return n - this.offset;
    }

    @Override
    public final void write(Integer value) {
        int u;
        int b;
        if (value + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + value);
        }
        long newValue = value + this.offset;
        if (newValue < 1L << this.k) {
            b = this.k;
            u = 0;
        } else {
            b = (int)(Math.log(newValue) / Math.log(2.0));
            u = b - this.k + 1;
        }
        this.coreBlockOutputStream.write(true, (long)u);
        this.coreBlockOutputStream.write(false);
        this.coreBlockOutputStream.write(newValue, b);
    }

    @Override
    public Integer read(int length) {
        throw new RuntimeException("Not implemented.");
    }
}

