/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package$all$;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException$;
import org.broadinstitute.gpp.poolq3.parser.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.matching.Regex;

public final class BarcodeSet$ {
    public static final BarcodeSet$ MODULE$ = new BarcodeSet$();
    private static final Regex BarcodeRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([ACGT]+)"));
    private static volatile boolean bitmap$init$0 = true;

    public Try<String> parseBarcode(Function1<String, Exception> makeException, String line) {
        Try try_;
        Option<List<String>> option;
        String string = line;
        if (string != null && !(option = BarcodeRe.unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0) {
            String bc = (String)((LinearSeqOps)option.get()).apply(0);
            try_ = new Success<String>(bc);
        } else {
            try_ = new Failure<String>(makeException.apply(line));
        }
        return try_;
    }

    public BarcodeSet apply(Path file) {
        return (BarcodeSet)Using$.MODULE$.resource(new FileInputStream(file.toFile()), (Function1<FileInputStream, BarcodeSet> & Serializable)fin -> {
            BOMInputStream in = new BOMInputStream((InputStream)fin, false, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            package$.MODULE$.skipHeader(br, BarcodeRe);
            Function1<String, InvalidFileException> & Serializable intersect = (Function1<String, InvalidFileException> & Serializable)s -> InvalidFileException$.MODULE$.apply(file, new StringBuilder(22).append("Invalid DNA barcode '").append((String)s).append("'").toString());
            return (BarcodeSet)package$all$.MODULE$.toFlatMapOps(((Try)package$all$.MODULE$.toTraverseOps(CollectionConverters$.MODULE$.ListHasAsScala(br.lines().collect(Collectors.toList())).asScala().toList().map((Function1<String, String> & Serializable)x$1 -> x$1.trim()), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1<String, Try> & Serializable)line -> MODULE$.parseBarcode((Function1<String, Exception>)intersect, (String)line), Invariant$.MODULE$.catsInstancesForTry())).map((Function1<List, BarcodeSet> & Serializable)bcs -> new BarcodeSet(bcs.toSet())), Invariant$.MODULE$.catsInstancesForTry()).flatTap((Function1<BarcodeSet, Try> & Serializable)x$2 -> MODULE$.checkSet(file, (BarcodeSet)x$2)).get();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public Try<BoxedUnit> checkSet(Path file, BarcodeSet barcodeSet) {
        Try try_;
        if (barcodeSet.barcodes().isEmpty()) {
            try_ = new Failure<BoxedUnit>(InvalidFileException$.MODULE$.apply(file, "Empty barcode file"));
        } else {
            Try try_2;
            int expectedLength = barcodeSet.barcodeLength();
            Option option = barcodeSet.barcodes().find((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(BarcodeSet$.$anonfun$checkSet$1(expectedLength, x$3)));
            if (None$.MODULE$.equals(option)) {
                try_2 = new Success<BoxedUnit>(BoxedUnit.UNIT);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String b = (String)some.value();
                try_2 = new Failure(InvalidFileException$.MODULE$.apply(file, new StringBuilder(41).append("Barcode '").append(b).append("' did not match expected length ").append(expectedLength).toString()));
            } else {
                throw new MatchError(option);
            }
            try_ = try_2;
        }
        return try_;
    }

    public static final /* synthetic */ boolean $anonfun$checkSet$1(int expectedLength$1, String x$3) {
        return x$3.length() != expectedLength$1;
    }

    private BarcodeSet$() {
    }
}

