/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.broadinstitute.gpp.poolq3.numeric.package$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.types.CorrelationFileType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class CorrelationFileWriter$ {
    public static final CorrelationFileWriter$ MODULE$ = new CorrelationFileWriter$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter");
    private static volatile boolean bitmap$init$0 = true;

    public Try<Option<CorrelationFileType$>> write(Path file, Map<String, Map<String, Object>> normalizedCounts, Reference rowReference, Reference colReference) {
        Try try_;
        if (colReference.allIds().size() < 2 || rowReference.allBarcodes().size() < 2) {
            if (log.isWarnEnabled()) {
                log.warn(new StringBuilder(46).append("Skipping correlation file for trivial dataset ").append(new StringBuilder(20).append("(").append(colReference.allIds().size()).append(" columns and ").append(rowReference.allBarcodes().size()).append(" rows)").toString()).toString());
            }
            try_ = new Success<Option<CorrelationFileType$>>(None$.MODULE$);
        } else {
            PearsonsCorrelation cor = new PearsonsCorrelation();
            double[][] countsMatrix = this.makeCountsMatrix(normalizedCounts, rowReference, colReference);
            RealMatrix pearsonMatrix = cor.computeCorrelationMatrix(countsMatrix);
            try_ = Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(file.toFile()), (Function1<PrintWriter, Some> & Serializable)pw -> {
                MODULE$.printHeaders(colReference, (PrintWriter)pw);
                colReference.allIds().indices().foreach$mVc$sp(i -> {
                    pw.print((String)colReference.allIds().apply(i));
                    colReference.allIds().indices().foreach$mVc$sp(j -> pw.print(new StringBuilder(1).append("\t").append(package$.MODULE$.Decimal00Format().format(pearsonMatrix.getEntry(i, j))).toString()));
                    pw.println();
                });
                return new Some<CorrelationFileType$>(CorrelationFileType$.MODULE$);
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
        }
        return try_;
    }

    public void printHeaders(Reference colReference, PrintWriter pw) {
        pw.println(new StringBuilder(1).append("\t").append(colReference.allIds().mkString("\t")).toString());
    }

    private double[][] makeCountsMatrix(Map<String, Map<String, Object>> counts, Reference rowReference, Reference colReference) {
        double[][] matrix = (double[][])Array$.MODULE$.ofDim(rowReference.allBarcodes().size(), colReference.allIds().size(), ClassTag$.MODULE$.Double());
        rowReference.allBarcodes().indices().foreach$mVc$sp(i -> {
            String row = (String)rowReference.allBarcodes().apply(i);
            Map rowCounts = (Map)counts.apply(row);
            colReference.allIds().indices().foreach$mVc$sp(j -> {
                matrix$1[i$2][j] = BoxesRunTime.unboxToDouble(rowCounts.apply(colReference.allIds().apply(j)));
            });
        });
        return matrix;
    }

    private CorrelationFileWriter$() {
    }
}

