/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.reads;

import htsjdk.beta.io.IOPathUtils;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleJSON;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Tuple;
import htsjdk.utils.ValidationUtils;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public class ReadsBundle<T extends IOPath>
extends Bundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getInstance(ReadsBundle.class);

    public ReadsBundle(T reads) {
        this((Collection<BundleResource>)Arrays.asList(ReadsBundle.toInputResource(BundleResourceType.ALIGNED_READS, (IOPath)ValidationUtils.nonNull(reads, BundleResourceType.ALIGNED_READS))));
    }

    public ReadsBundle(T reads, T index) {
        this((Collection<BundleResource>)Arrays.asList(ReadsBundle.toInputResource(BundleResourceType.ALIGNED_READS, (IOPath)ValidationUtils.nonNull(reads, BundleResourceType.ALIGNED_READS)), ReadsBundle.toInputResource("READS_INDEX", (IOPath)ValidationUtils.nonNull(index, "READS_INDEX"))));
    }

    protected ReadsBundle(Collection<BundleResource> resources) {
        super(BundleResourceType.ALIGNED_READS, resources);
    }

    public BundleResource getReads() {
        return this.getOrThrow(BundleResourceType.ALIGNED_READS);
    }

    public Optional<BundleResource> getIndex() {
        return this.get("READS_INDEX");
    }

    public static ReadsBundle<IOPath> getReadsBundleFromPath(IOPath jsonPath) {
        return ReadsBundle.getReadsBundleFromString(IOPathUtils.getStringFromPath(jsonPath));
    }

    public static ReadsBundle<IOPath> getReadsBundleFromString(String jsonString) {
        return ReadsBundle.getReadsBundleFromString(jsonString, HtsPath::new);
    }

    public static <T extends IOPath> ReadsBundle<T> getReadsBundleFromString(String jsonString, Function<String, T> ioPathConstructor) {
        return new ReadsBundle<T>(BundleJSON.toBundle(jsonString, ioPathConstructor).getResources());
    }

    public static ReadsBundle<IOPath> resolveIndex(IOPath reads) {
        return ReadsBundle.resolveIndex(reads, HtsPath::new);
    }

    public static <T extends IOPath> ReadsBundle<T> resolveIndex(T reads, Function<String, T> ioPathConstructor) {
        if (reads.hasFileSystemProvider()) {
            Path index = SamFiles.findIndex(reads.toPath());
            if (index == null) {
                return new ReadsBundle<T>(reads);
            }
            return new ReadsBundle<IOPath>(reads, (IOPath)ioPathConstructor.apply(index.toUri().toString()));
        }
        return new ReadsBundle<T>(reads);
    }

    public static boolean looksLikeAReadsBundle(IOPath rawReadPath) {
        return rawReadPath.getURI().getPath().endsWith(".json");
    }

    private static <T extends IOPath> IOPathResource toInputResource(String providedContentType, T ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        Optional<Tuple<String, String>> typePair = ReadsBundle.getInferredContentTypes(ioPath);
        if (typePair.isPresent() && providedContentType != null && !((String)typePair.get().a).equals(providedContentType)) {
            LOG.warn(String.format("Provided content type \"%s\" for \"%s\" doesn't match derived content type \"%s\"", providedContentType, ioPath.getRawInputString(), typePair.get().a));
        }
        return new IOPathResource(ioPath, providedContentType);
    }

    private static <T extends IOPath> Optional<Tuple<String, String>> getInferredContentTypes(T ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        Optional<String> extension2 = ioPath.getExtension();
        if (extension2.isPresent()) {
            String ext = extension2.get();
            if (ext.equals(".bam")) {
                return Optional.of(new Tuple<String, String>(BundleResourceType.ALIGNED_READS, "BAM"));
            }
            if (ext.equals(".cram")) {
                return Optional.of(new Tuple<String, String>(BundleResourceType.ALIGNED_READS, "CRAM"));
            }
            if (ext.equals(".sam")) {
                return Optional.of(new Tuple<String, String>(BundleResourceType.ALIGNED_READS, "SAM"));
            }
        }
        return Optional.empty();
    }
}

