/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.NameAwareCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFAltHeaderLine;
import htsjdk.variant.vcf.VCFConstants;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFMetaHeaderLine;
import htsjdk.variant.vcf.VCFPassThruTextTransformer;
import htsjdk.variant.vcf.VCFPedigreeHeaderLine;
import htsjdk.variant.vcf.VCFPercentEncodedTextTransformer;
import htsjdk.variant.vcf.VCFSampleHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import htsjdk.variant.vcf.VCFTextTransformer;
import htsjdk.variant.vcf.VCFUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public abstract class AbstractVCFCodec
extends AsciiFeatureCodec<VariantContext>
implements NameAwareCodec {
    public static final int MAX_ALLELE_SIZE_BEFORE_WARNING = (int)Math.pow(2.0, 20.0);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeader header = null;
    protected VCFHeaderVersion version = null;
    private static final VCFTextTransformer percentEncodingTextTransformer = new VCFPercentEncodedTextTransformer();
    private static final VCFTextTransformer passThruTextTransformer = new VCFPassThruTextTransformer();
    private VCFTextTransformer vcfTextTransformer = passThruTextTransformer;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected final String[] locParts = new String[6];
    protected HashMap<String, List<String>> filterHash = new HashMap();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();
    protected boolean warnedAboutNoEqualsForNonFlag = false;
    protected boolean doOnTheFlyModifications = true;
    protected String remappedSampleName = null;

    protected AbstractVCFCodec() {
        super(VariantContext.class);
    }

    protected abstract List<String> parseFilters(String var1);

    protected VCFHeader parseHeaderFromLines(List<String> headerStrings, VCFHeaderVersion version) {
        this.version = version;
        LinkedHashSet<VCFHeaderLine> metaData = new LinkedHashSet<VCFHeaderLine>();
        LinkedHashSet<String> sampleNames = new LinkedHashSet<String>();
        int contigCounter = 0;
        for (String str : headerStrings) {
            if (!str.startsWith("##")) {
                String[] strings = str.substring(1).split("\t");
                if (strings.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + str);
                }
                int arrayIndex = 0;
                for (VCFHeader.HEADER_FIELDS field2 : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (field2 != VCFHeader.HEADER_FIELDS.valueOf(strings[arrayIndex])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)field2) + "' but we saw '" + strings[arrayIndex] + "'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + strings[arrayIndex] + "'; it does not match a legal column header name.");
                    }
                    ++arrayIndex;
                }
                boolean sawFormatTag = false;
                if (arrayIndex < strings.length) {
                    if (!strings[arrayIndex].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + strings[arrayIndex] + "'");
                    }
                    sawFormatTag = true;
                    ++arrayIndex;
                }
                while (arrayIndex < strings.length) {
                    sampleNames.add(strings[arrayIndex++]);
                }
                if (sawFormatTag && sampleNames.isEmpty()) {
                    throw new TribbleException.InvalidHeader("The FORMAT field was provided but there is no genotype/sample data");
                }
                if (this.remappedSampleName == null) continue;
                if (sampleNames.isEmpty() || sampleNames.size() > 1) {
                    throw new TribbleException(String.format("Cannot remap sample name to %s because %s samples are specified in the VCF header, and on-the-fly sample name remapping is only supported for single-sample VCFs", this.remappedSampleName, sampleNames.isEmpty() ? "no" : "multiple"));
                }
                sampleNames.clear();
                sampleNames.add(this.remappedSampleName);
                continue;
            }
            if (str.startsWith("##INFO")) {
                VCFInfoHeaderLine info = new VCFInfoHeaderLine(str.substring(7), version);
                metaData.add(info);
                continue;
            }
            if (str.startsWith("##FILTER")) {
                VCFFilterHeaderLine filter2 = new VCFFilterHeaderLine(str.substring(9), version);
                metaData.add(filter2);
                continue;
            }
            if (str.startsWith("##FORMAT")) {
                VCFFormatHeaderLine format = new VCFFormatHeaderLine(str.substring(9), version);
                metaData.add(format);
                continue;
            }
            if (str.startsWith("##contig")) {
                VCFContigHeaderLine contig = new VCFContigHeaderLine(str.substring(9), version, "##contig".substring(2), contigCounter++);
                metaData.add(contig);
                continue;
            }
            if (str.startsWith("##ALT")) {
                metaData.add(this.getAltHeaderLine(str.substring(VCFConstants.ALT_HEADER_OFFSET), version));
                continue;
            }
            if (str.startsWith("##PEDIGREE") && version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_3)) {
                metaData.add(this.getPedigreeHeaderLine(str.substring(VCFConstants.PEDIGREE_HEADER_OFFSET), version));
                continue;
            }
            if (str.startsWith("##META")) {
                metaData.add(this.getMetaHeaderLine(str.substring(VCFConstants.META_HEADER_OFFSET), version));
                continue;
            }
            if (str.startsWith("##SAMPLE")) {
                metaData.add(this.getSampleHeaderLine(str.substring(VCFConstants.SAMPLE_HEADER_OFFSET), version));
                continue;
            }
            int equals = str.indexOf(61);
            if (equals == -1) continue;
            metaData.add(new VCFHeaderLine(str.substring(2, equals), str.substring(equals + 1)));
        }
        this.setVCFHeader(new VCFHeader(version, metaData, sampleNames), version);
        return this.header;
    }

    public VCFHeader getHeader() {
        return this.header;
    }

    public VCFHeaderVersion getVersion() {
        return this.version;
    }

    public VCFHeader setVCFHeader(VCFHeader newHeader, VCFHeaderVersion newVersion) {
        this.validateHeaderVersionTransition(newHeader, newVersion);
        if (this.doOnTheFlyModifications) {
            VCFHeader repairedHeader = VCFStandardHeaderLines.repairStandardHeaderLines(newHeader);
            this.validateHeaderVersionTransition(repairedHeader, newVersion);
            this.header = repairedHeader;
        } else {
            this.header = newHeader;
        }
        this.version = newVersion;
        this.vcfTextTransformer = this.getTextTransformerForVCFVersion(newVersion);
        return this.header;
    }

    public VCFAltHeaderLine getAltHeaderLine(String headerLineString, VCFHeaderVersion sourceVersion) {
        return new VCFAltHeaderLine(headerLineString, sourceVersion);
    }

    public VCFPedigreeHeaderLine getPedigreeHeaderLine(String headerLineString, VCFHeaderVersion sourceVersion) {
        return new VCFPedigreeHeaderLine(headerLineString, sourceVersion);
    }

    public VCFMetaHeaderLine getMetaHeaderLine(String headerLineString, VCFHeaderVersion sourceVersion) {
        return new VCFMetaHeaderLine(headerLineString, sourceVersion);
    }

    public VCFSampleHeaderLine getSampleHeaderLine(String headerLineString, VCFHeaderVersion sourceVersion) {
        return new VCFSampleHeaderLine(headerLineString, sourceVersion);
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decodeLine(line, false);
    }

    @Override
    public VariantContext decode(String line) {
        return this.decodeLine(line, true);
    }

    private void validateHeaderVersionTransition(VCFHeader newHeader, VCFHeaderVersion newVersion) {
        ValidationUtils.nonNull(newHeader);
        ValidationUtils.nonNull(newVersion);
        VCFHeader.validateVersionTransition(this.version, newVersion);
        if (this.header != null && newHeader.getVCFHeaderVersion() != null) {
            VCFHeader.validateVersionTransition(this.header.getVCFHeaderVersion(), newHeader.getVCFHeaderVersion());
        }
    }

    private VCFTextTransformer getTextTransformerForVCFVersion(VCFHeaderVersion targetVersion) {
        return targetVersion != null && targetVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_3) ? percentEncodingTextTransformer : passThruTextTransformer;
    }

    private VariantContext decodeLine(String line, boolean includeGenotypes) {
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new TribbleException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int nParts = ParsingUtils.split(line, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
            throw new TribbleException("Line " + this.lineNo + ": there aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )");
        }
        return this.parseVCFLine(this.parts, includeGenotypes);
    }

    private VariantContext parseVCFLine(String[] parts, boolean includeGenotypes) {
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.source(this.getName());
        ++this.lineNo;
        String chr = this.getCachedString(parts[0]);
        builder.chr(chr);
        int pos = -1;
        try {
            pos = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            this.generateException(parts[1] + " is not a valid start position in the VCF format");
        }
        builder.start(pos);
        if (parts[2].isEmpty()) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (parts[2].equals(".")) {
            builder.noID();
        } else {
            builder.id(parts[2]);
        }
        String ref = parts[3].toUpperCase();
        String alts = parts[4];
        builder.log10PError(AbstractVCFCodec.parseQual(parts[5]));
        List<String> filters = this.parseFilters(this.getCachedString(parts[6]));
        if (filters != null) {
            builder.filters(new HashSet<String>(filters));
        }
        Map<String, Object> attrs = this.parseInfo(parts[7]);
        builder.attributes(attrs);
        if (attrs.containsKey("END")) {
            try {
                builder.stop(Integer.parseInt(attrs.get("END").toString()));
            }
            catch (Exception e) {
                this.generateException("the END value in the INFO field is not valid");
            }
        } else {
            builder.stop(pos + ref.length() - 1);
        }
        List<Allele> alleles = AbstractVCFCodec.parseAlleles(ref, alts, this.lineNo);
        builder.alleles((Collection<Allele>)alleles);
        if (parts.length > 8 && includeGenotypes) {
            LazyVCFGenotypesParser lazyParser = new LazyVCFGenotypesParser(alleles, chr, pos);
            int nGenotypes = this.header.getNGenotypeSamples();
            LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, parts[8], nGenotypes);
            if (!this.header.samplesWereAlreadySorted()) {
                lazy.decode();
            }
            builder.genotypesNoValidation(lazy);
        }
        VariantContext vc = null;
        try {
            vc = builder.make();
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        return vc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected String getCachedString(String str) {
        String internedString = this.stringCache.get(str);
        if (internedString == null) {
            internedString = new String(str);
            this.stringCache.put(internedString, internedString);
        }
        return internedString;
    }

    private Map<String, Object> parseInfo(String infoField) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (infoField.isEmpty()) {
            this.generateException("The VCF specification requires a valid (non-zero length) info field");
        }
        if (!infoField.equals(".")) {
            if (infoField.indexOf(9) != -1 || infoField.indexOf(32) != -1) {
                this.generateException("The VCF specification does not allow for whitespace in the INFO field. Offending field value was \"" + infoField + "\"");
            }
            List<String> infoFields = ParsingUtils.split(infoField, ';');
            for (int i = 0; i < infoFields.size(); ++i) {
                Object value;
                String key;
                int eqI = infoFields.get(i).indexOf("=");
                if (eqI != -1) {
                    key = infoFields.get(i).substring(0, eqI);
                    String valueString = infoFields.get(i).substring(eqI + 1);
                    List<String> infoValueSplit = ParsingUtils.split(valueString, ',');
                    if (infoValueSplit.size() == 1) {
                        value = this.vcfTextTransformer.decodeText(infoValueSplit.get(0));
                        VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                        if (headerLine != null && headerLine.getType() == VCFHeaderLineType.Flag && value.equals("0")) {
                            continue;
                        }
                    } else {
                        value = this.vcfTextTransformer.decodeText(infoValueSplit);
                    }
                } else {
                    key = infoFields.get(i);
                    VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                    value = headerLine != null && headerLine.getType() != VCFHeaderLineType.Flag ? "." : Boolean.valueOf(true);
                }
                if ("".equals(value)) {
                    value = ".";
                }
                attributes.put(key, value);
            }
        }
        return attributes;
    }

    protected static Allele oneAllele(String index, List<Allele> alleles) {
        int i;
        if (index.equals(".")) {
            return Allele.NO_CALL;
        }
        try {
            i = Integer.parseInt(index);
        }
        catch (NumberFormatException e) {
            throw new TribbleException.InternalCodecException("The following invalid GT allele index was encountered in the file: " + index);
        }
        if (i >= alleles.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + index + " is not defined in the REF/ALT columns in the record");
        }
        return alleles.get(i);
    }

    protected static List<Allele> parseGenotypeAlleles(String GT, List<Allele> alleles, Map<String, List<Allele>> cache) {
        List<Allele> GTAlleles = cache.get(GT);
        if (GTAlleles == null) {
            StringTokenizer st = new StringTokenizer(GT, "/|\\");
            GTAlleles = new ArrayList<Allele>(st.countTokens());
            while (st.hasMoreTokens()) {
                String genotype = st.nextToken();
                GTAlleles.add(AbstractVCFCodec.oneAllele(genotype, alleles));
            }
            cache.put(GT, GTAlleles);
        }
        return GTAlleles;
    }

    protected static Double parseQual(String qualString) {
        if (qualString.equals(".")) {
            return 1.0;
        }
        Double val = VCFUtils.parseVcfDouble(qualString);
        if (val < 0.0 && Math.abs(val - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return 1.0;
        }
        return val / -10.0;
    }

    protected static List<Allele> parseAlleles(String ref, String alts, int lineNo) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(ref, true, lineNo);
        Allele refAllele = Allele.create(ref, true);
        alleles.add(refAllele);
        if (alts.indexOf(44) == -1) {
            AbstractVCFCodec.parseSingleAltAllele(alleles, alts, lineNo);
        } else {
            for (String alt : alts.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(alleles, alt, lineNo);
            }
        }
        return alleles;
    }

    private static void checkAllele(String allele, boolean isRef, int lineNo) {
        if (allele == null || allele.isEmpty()) {
            AbstractVCFCodec.generateException(AbstractVCFCodec.generateExceptionTextForBadAlleleBases(""), lineNo);
        }
        if (Allele.wouldBeSymbolicAllele(allele.getBytes())) {
            if (isRef) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + allele, lineNo);
            }
        } else {
            if (allele.charAt(0) == 'D' || allele.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", lineNo);
            }
            if (!Allele.acceptableAlleleBases(allele, isRef)) {
                AbstractVCFCodec.generateException(AbstractVCFCodec.generateExceptionTextForBadAlleleBases(allele), lineNo);
            }
            if (isRef && allele.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", lineNo);
            }
        }
    }

    private static String generateExceptionTextForBadAlleleBases(String allele) {
        if (allele.isEmpty()) {
            return "empty alleles are not permitted in VCF records";
        }
        if (allele.contains("[") || allele.contains("]") || allele.contains(":") || allele.contains(".")) {
            return "VCF support for complex rearrangements with breakends has not yet been implemented";
        }
        return "unparsable vcf record with allele " + allele;
    }

    private static void parseSingleAltAllele(List<Allele> alleles, String alt, int lineNo) {
        AbstractVCFCodec.checkAllele(alt, false, lineNo);
        Allele allele = Allele.create(alt, false);
        if (!allele.isNoCall()) {
            alleles.add(allele);
        }
    }

    public static boolean canDecodeFile(String potentialInput, String MAGIC_HEADER_LINE) {
        try {
            Path path = IOUtil.getPath(potentialInput);
            return AbstractVCFCodec.isVCFStream(Files.newInputStream(path, new OpenOption[0]), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new BlockCompressedInputStream(Files.newInputStream(path, new OpenOption[0])), MAGIC_HEADER_LINE);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isVCFStream(InputStream stream, String MAGIC_HEADER_LINE) {
        try {
            boolean eq2;
            byte[] buff = new byte[MAGIC_HEADER_LINE.length()];
            int nread = stream.read(buff, 0, MAGIC_HEADER_LINE.length());
            boolean bl = eq2 = Arrays.equals(buff, MAGIC_HEADER_LINE.getBytes());
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public LazyGenotypesContext.LazyData createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        int nParts;
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        if ((nParts = ParsingUtils.split(str, this.genotypeParts, '\t')) != this.genotypeParts.length) {
            AbstractVCFCodec.generateException("there are " + (nParts - 1) + " genotypes while the header requires that " + (this.genotypeParts.length - 1) + " genotypes be present for all records at " + chr + ":" + pos, this.lineNo);
        }
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(nParts);
        List<String> genotypeKeys = ParsingUtils.split(this.genotypeParts[0], ':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        boolean PlIsSet = false;
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            List<String> genotypeValues = ParsingUtils.split(this.genotypeParts[genotypeOffset], ':');
            genotypeValues = this.vcfTextTransformer.decodeText(genotypeValues);
            String sampleName = sampleNameIterator.next();
            GenotypeBuilder gb = new GenotypeBuilder(sampleName);
            if (genotypeKeys.size() < genotypeValues.size()) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (!genotypeKeys.isEmpty()) {
                gb.maxAttributes(genotypeKeys.size() - 1);
                for (int i = 0; i < genotypeKeys.size(); ++i) {
                    boolean missing;
                    String gtKey = genotypeKeys.get(i);
                    boolean bl = missing = i >= genotypeValues.size();
                    if (gtKey.equals("GT")) {
                        genotypeAlleleLocation = i;
                        continue;
                    }
                    if (missing) continue;
                    if (gtKey.equals("FT")) {
                        List<String> filters = this.parseFilters(this.getCachedString(genotypeValues.get(i)));
                        if (filters == null) continue;
                        gb.filters(filters);
                        continue;
                    }
                    if (genotypeValues.get(i).equals(".")) continue;
                    if (gtKey.equals("GQ")) {
                        if (genotypeValues.get(i).equals("-1")) {
                            gb.noGQ();
                            continue;
                        }
                        gb.GQ((int)Math.round(VCFUtils.parseVcfDouble(genotypeValues.get(i))));
                        continue;
                    }
                    if (gtKey.equals("AD")) {
                        gb.AD(AbstractVCFCodec.decodeInts(genotypeValues.get(i)));
                        continue;
                    }
                    if (gtKey.equals("PL")) {
                        gb.PL(AbstractVCFCodec.decodeInts(genotypeValues.get(i)));
                        PlIsSet = true;
                        continue;
                    }
                    if (gtKey.equals("GL")) {
                        if (PlIsSet) continue;
                        gb.PL(GenotypeLikelihoods.fromGLField(genotypeValues.get(i)).getAsPLs());
                        continue;
                    }
                    if (gtKey.equals("DP")) {
                        gb.DP(Integer.parseInt(genotypeValues.get(i)));
                        continue;
                    }
                    gb.attribute(gtKey, genotypeValues.get(i));
                }
            }
            if (!this.version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_1) && genotypeAlleleLocation == -1) {
                this.generateException("Unable to find the GT field for the record; the GT field is required before VCF4.1");
            }
            if (genotypeAlleleLocation > 0) {
                this.generateException("Saw GT field at position " + genotypeAlleleLocation + ", but it must be at the first position for genotypes when present");
            }
            ArrayList<Allele> GTalleles = genotypeAlleleLocation == -1 ? new ArrayList<Allele>(0) : AbstractVCFCodec.parseGenotypeAlleles(genotypeValues.get(genotypeAlleleLocation), alleles, this.alleleMap);
            gb.alleles(GTalleles);
            gb.phased(genotypeAlleleLocation != -1 && genotypeValues.get(genotypeAlleleLocation).indexOf("|") != -1);
            try {
                genotypes.add(gb.make());
                continue;
            }
            catch (TribbleException e) {
                throw new TribbleException.InternalCodecException(e.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return new LazyGenotypesContext.LazyData(genotypes, this.header.getSampleNamesInOrder(), this.header.getSampleNameToOffset());
    }

    private static final int[] decodeInts(String string) {
        List<String> split2 = ParsingUtils.split(string, ',');
        int[] values = new int[split2.size()];
        try {
            for (int i = 0; i < values.length; ++i) {
                values[i] = Integer.parseInt(split2.get(i));
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return values;
    }

    public final void disableOnTheFlyModifications() {
        this.doOnTheFlyModifications = false;
    }

    public void setRemappedSampleName(String remappedSampleName) {
        this.remappedSampleName = remappedSampleName;
    }

    protected void generateException(String message) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", this.lineNo, message));
    }

    protected static void generateException(String message, int lineNo) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", lineNo, message));
    }

    @Override
    public TabixFormat getTabixFormat() {
        return TabixFormat.VCF;
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> alleles, String contig, int start) {
            this.alleles = alleles;
            this.contig = contig;
            this.start = start;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            return AbstractVCFCodec.this.createGenotypeMap((String)data, this.alleles, this.contig, this.start);
        }
    }
}

