/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask0;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask1;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask2;
import org.broadinstitute.gpp.poolq3.barcode.KeyMaskN;
import org.broadinstitute.gpp.poolq3.barcode.KeyRange;
import org.broadinstitute.gpp.poolq3.barcode.KeyRange$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqView;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;

public final class KeyMask$ {
    public static final KeyMask$ MODULE$ = new KeyMask$();

    public KeyMask apply(String pattern) {
        return this.create(pattern, this.parsePatternRanges(pattern));
    }

    public KeyMask apply(int contextLength, Seq<KeyRange> keyRanges) {
        Predef$.MODULE$.require(keyRanges.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Key mask must have at least one key range");
        keyRanges.foreach((Function1<KeyRange, Object> & Serializable)r -> {
            Predef$.MODULE$.require(r.end0() < contextLength, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(59).append("contextLength (").append(contextLength$1).append(") is not large enough to contain key range: ").append(r).toString());
            return BoxedUnit.UNIT;
        });
        Seq<KeyRange> mergedRanges = this.mergeAdjacent((Seq)keyRanges.sorted(KeyRange$.MODULE$.ord()));
        String pat = this.constructPattern(contextLength, keyRanges);
        return this.create(pat, mergedRanges);
    }

    private KeyMask create(String pattern, Seq<KeyRange> mergedRanges) {
        KeyMask keyMask;
        int n = mergedRanges.length();
        switch (n) {
            case 1: {
                KeyRange r = (KeyRange)mergedRanges.head();
                if (r.start0() == 0 && r.length() == pattern.length()) {
                    keyMask = new KeyMask0(pattern);
                    break;
                }
                keyMask = new KeyMask1(pattern, r);
                break;
            }
            case 2: {
                keyMask = new KeyMask2(pattern, (KeyRange)mergedRanges.apply(false), (KeyRange)mergedRanges.apply(true));
                break;
            }
            default: {
                keyMask = new KeyMaskN(pattern, mergedRanges);
                break;
            }
        }
        return keyMask;
    }

    public KeyMask fromString(int contextLength, String str) {
        IndexedSeqView ranges = ArrayOps$.MODULE$.view$extension(Predef$.MODULE$.refArrayOps(str.split(",", -1))).map((Function1<String, KeyRange> & Serializable)s -> KeyRange$.MODULE$.apply(s.trim()));
        Predef$.MODULE$.require(ranges.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(47).append("KeyMask range string yields no valid ranges: '").append(str).append("'").toString());
        return this.apply(contextLength, ranges.toIndexedSeq());
    }

    public Seq<KeyRange> mergeAdjacent(Seq<KeyRange> bases) {
        return (Seq)((IterableOnceOps)bases.foldLeft(package$.MODULE$.List().apply((Seq)Nil$.MODULE$), (Function2<List, KeyRange, List> & Serializable)(acc, current) -> KeyMask$.merge$1(acc, current))).toIndexedSeq().reverse();
    }

    public List<KeyRange> parsePatternRanges(String pattern) {
        return this.loop$1(package$.MODULE$.Nil(), ((IterableOnceOps)Predef$.MODULE$.wrapString(pattern).zipWithIndex()).toList());
    }

    public String constructPattern(int length, Seq<KeyRange> ranges) {
        char[] chars = (char[])Array$.MODULE$.fill(length, () -> 'n', ClassTag$.MODULE$.Char());
        ranges.foreach((Function1<KeyRange, Object> & Serializable)range -> {
            KeyMask$.$anonfun$constructPattern$2(chars, range);
            return BoxedUnit.UNIT;
        });
        return new String(chars);
    }

    private static final List merge$1(List acc, KeyRange current) {
        List<KeyRange> list;
        List list2 = acc;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list2;
        if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
            KeyRange keyRange = current;
            list = package$.MODULE$.Nil().$colon$colon(keyRange);
        } else if (list2 instanceof $colon$colon) {
            List<KeyRange> list4;
            $colon$colon $colon$colon = ($colon$colon)list2;
            KeyRange head = (KeyRange)$colon$colon.head();
            List tail = $colon$colon.next$access$1();
            if (head.end0() >= current.start0() - 1) {
                KeyRange keyRange = new KeyRange(head.start0(), current.end0());
                list4 = tail.$colon$colon(keyRange);
            } else {
                KeyRange keyRange = current;
                list4 = acc.$colon$colon(keyRange);
            }
            list = list4;
        } else {
            throw new MatchError(list2);
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$parsePatternRanges$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        char p = tuple2._1$mcC$sp();
        boolean bl = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(p));
        return bl;
    }

    private final List loop$1(List acc, List ps) {
        block5: {
            List list;
            while (true) {
                boolean bl = false;
                $colon$colon $colon$colon = null;
                list = ps;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) break block5;
                if (list instanceof $colon$colon) {
                    bl = true;
                    $colon$colon = ($colon$colon)list;
                    Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                    if (tuple2 != null) {
                        char base = tuple2._1$mcC$sp();
                        int startIdx = tuple2._2$mcI$sp();
                        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(base))) {
                            Tuple2 tuple22 = ps.span((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(KeyMask$.$anonfun$parsePatternRanges$1(x0$1)));
                            if (tuple22 == null) {
                                throw new MatchError(tuple22);
                            }
                            List span = tuple22._1();
                            List rest = tuple22._2();
                            Tuple2 tuple23 = new Tuple2(span, rest);
                            Tuple2 tuple24 = tuple23;
                            List span2 = tuple24._1();
                            List rest2 = tuple24._2();
                            KeyRange keyRange = new KeyRange(startIdx, startIdx + span2.length() - 1);
                            ps = rest2;
                            acc = acc.$colon$colon(keyRange);
                            continue;
                        }
                    }
                }
                if (!bl) break;
                Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                List tl = $colon$colon.next$access$1();
                if (tuple2 == null) break;
                ps = tl;
            }
            throw new MatchError(list);
        }
        Object object = acc.reverse();
        return object;
    }

    public static final /* synthetic */ void $anonfun$constructPattern$2(char[] chars$1, KeyRange range) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(range.start0()), range.end0()).foreach$mVc$sp(i -> {
            chars$1[i] = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(chars$1[i]));
        });
    }

    private KeyMask$() {
    }
}

