/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.OverlapDetector;
import java.util.List;
import java.util.Set;

public class IntervalKeepPairFilter
implements SamRecordFilter {
    private final OverlapDetector<Interval> intervalOverlapDetector = new OverlapDetector(0, 0);

    public IntervalKeepPairFilter(List<Interval> intervals) {
        this.intervalOverlapDetector.addAll(intervals, intervals);
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        if (record.isSecondaryOrSupplementary() || !record.getReadPairedFlag()) {
            return true;
        }
        if (!record.getReadUnmappedFlag() && this.hasOverlaps(record.getReferenceName(), record.getStart(), record.getEnd())) {
            return false;
        }
        return record.getMateUnmappedFlag() || !this.hasOverlaps(record.getMateReferenceName(), record.getMateAlignmentStart(), SAMUtils.getMateAlignmentEnd(record));
    }

    private boolean hasOverlaps(String refSequence, int start, int end) {
        Interval readInterval = new Interval(refSequence, start, end);
        Set<Interval> overlapsRead = this.intervalOverlapDetector.getOverlaps(readInterval);
        return !overlapsRead.isEmpty();
    }

    @Override
    public boolean filterOut(SAMRecord first2, SAMRecord second) {
        return this.filterOut(first2) && this.filterOut(second);
    }
}

