/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.nio.file.Path;

public class Tribble {
    @Deprecated
    public static final String STANDARD_INDEX_EXTENSION = ".idx";

    private Tribble() {
    }

    public static String indexFile(String filename) {
        return Tribble.indexFile(filename, STANDARD_INDEX_EXTENSION);
    }

    public static File indexFile(File file) {
        return Tribble.indexFile(file.getAbsoluteFile(), STANDARD_INDEX_EXTENSION);
    }

    public static Path indexPath(Path path) {
        return path.getFileSystem().getPath(Tribble.indexFile(path.toAbsolutePath().toString()), new String[0]);
    }

    public static String tabixIndexFile(String filename) {
        return Tribble.indexFile(filename, ".tbi");
    }

    public static File tabixIndexFile(File file) {
        return Tribble.indexFile(file.getAbsoluteFile(), ".tbi");
    }

    public static Path tabixIndexPath(Path path) {
        return path.getFileSystem().getPath(Tribble.tabixIndexFile(path.toAbsolutePath().toString()), new String[0]);
    }

    private static String indexFile(String filename, String extension2) {
        return ParsingUtils.appendToPath(filename, extension2);
    }

    private static File indexFile(File file, String extension2) {
        return new File(file.getAbsoluteFile() + extension2);
    }
}

