/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.BarcodeFrequency;
import org.broadinstitute.gpp.poolq3.reports.BarcodeFrequency$;
import org.broadinstitute.gpp.poolq3.reports.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class QualityWriter$ {
    public static final QualityWriter$ MODULE$ = new QualityWriter$();

    public Try<BoxedUnit> write(Path file, State state, Reference rowReference, Reference colReference, boolean isPairedEnd) {
        return Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(file.toFile()), (Function1<PrintWriter, Object> & Serializable)writer -> {
            QualityWriter$.$anonfun$write$2(isPairedEnd, state, colReference, rowReference, writer);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private String decOptFmt(Option<Object> d) {
        return (String)d.map((Function1<Object, String> & Serializable)x$1 -> QualityWriter$.$anonfun$decOptFmt$1(BoxesRunTime.unboxToDouble(x$1))).getOrElse((Function0<String> & Serializable)() -> "N/A");
    }

    private <A> Seq<String> perBarcodeQualityData(State state, Reference rowReference, Reference colReference, String colBarcode) {
        String conditions = colReference.idsForBarcode(colBarcode).mkString(",");
        int matchedRowAndCol = BoxesRunTime.unboxToInt(((IterableOnceOps)rowReference.allBarcodes().map((Function1<String, Object> & Serializable)rowBarcode -> BoxesRunTime.boxToInteger(QualityWriter$.$anonfun$perBarcodeQualityData$1(state, colBarcode, rowBarcode)))).sum(Numeric$IntIsIntegral$.MODULE$));
        int matchedCol = state.knownCol().count(colBarcode);
        double pct = org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.percent(matchedRowAndCol, matchedCol);
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{colReference.referenceBarcodeForDnaBarcode(colBarcode), conditions, Integer.toString(matchedRowAndCol), Integer.toString(matchedCol), org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.Decimal00Format().format(pct), org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.Decimal000Format().format(org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.logNormalize(matchedRowAndCol, state.reads()))}));
    }

    public static final /* synthetic */ void $anonfun$write$3(State state$1, Reference rowReference$1, Reference colReference$1, PrintWriter writer$1, String colBarcode) {
        Seq<String> data = MODULE$.perBarcodeQualityData(state$1, rowReference$1, colReference$1, colBarcode);
        writer$1.println(data.mkString("\t"));
    }

    public static final /* synthetic */ void $anonfun$write$5(PrintWriter writer$1, BarcodeFrequency x0$1) {
        BarcodeFrequency barcodeFrequency = x0$1;
        if (barcodeFrequency == null) {
            throw new MatchError(barcodeFrequency);
        }
        String barcode = barcodeFrequency.bc();
        int count = barcodeFrequency.frequency();
        writer$1.println(new StringBuilder(1).append(barcode).append("\t").append(Integer.toString(count)).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$write$2(boolean isPairedEnd$1, State state$1, Reference colReference$1, Reference rowReference$1, PrintWriter writer) {
        String barcodeLocationStats = isPairedEnd$1 ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(487).append("Reads with no construct barcode: ").append(state$1.rowBarcodeNotFound() + state$1.revRowBarcodeNotFound() - state$1.neitherRowBarcodeFound()).append("\n             |\n             |Reads with no forward construct barcode: ").append(state$1.rowBarcodeNotFound()).append("\n             |Max forward construct barcode index: ").append(state$1.rowBarcodeStats().maxPosStr()).append("\n             |Min forward construct barcode index: ").append(state$1.rowBarcodeStats().minPosStr()).append("\n             |Avg forward construct barcode index: ").append(MODULE$.decOptFmt(state$1.rowBarcodeStats().avg())).append("\n             |\n             |Reads with no reverse construct barcode: ").append(state$1.revRowBarcodeNotFound()).append("\n             |Max reverse construct barcode index: ").append(state$1.revRowBarcodeStats().maxPosStr()).append("\n             |Min reverse construct barcode index: ").append(state$1.revRowBarcodeStats().minPosStr()).append("\n             |Avg reverse construct barcode index: ").append(MODULE$.decOptFmt(state$1.revRowBarcodeStats().avg())).toString())) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(165).append("Reads with no construct barcode: ").append(state$1.rowBarcodeNotFound()).append("\n             |Max construct barcode index: ").append(state$1.rowBarcodeStats().maxPosStr()).append("\n             |Min construct barcode index: ").append(state$1.rowBarcodeStats().minPosStr()).append("\n             |Avg construct barcode index: ").append(MODULE$.decOptFmt(state$1.rowBarcodeStats().avg())).toString()));
        String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(160).append("Total reads: ").append(state$1.reads()).append("\n           |Matching reads: ").append(state$1.matches()).append("\n           |1-base mismatch reads: ").append(state$1.matches() - state$1.exactMatches()).append("\n           |\n           |Overall % match: ").append(org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.Decimal00Format().format(state$1.matchPercent())).append("\n           |\n           |").append(barcodeLocationStats).append("\n           |").toString()));
        writer.println(header);
        writer.println("Read counts for sample barcodes with associated conditions:");
        writer.println("Barcode\tCondition\tMatched (Construct+Sample Barcode)\tMatched Sample Barcode\t% Match\tNormalized Match");
        colReference$1.allBarcodes().foreach((Function1<String, Object> & Serializable)colBarcode -> {
            QualityWriter$.$anonfun$write$3(state$1, rowReference$1, colReference$1, writer, colBarcode);
            return BoxedUnit.UNIT;
        });
        writer.println();
        writer.println("Read counts for most common sample barcodes without associated conditions:");
        Seq unepectedBarcodeFrequencies = ((IterableOnceOps)state$1.unknownCol().keys().map((Function1<String, BarcodeFrequency> & Serializable)barcode -> new BarcodeFrequency((String)barcode, state$1.unknownCol().count((String)barcode)))).toSeq();
        package$.MODULE$.topN(unepectedBarcodeFrequencies, 100, BarcodeFrequency$.MODULE$.ord()).foreach((Function1<BarcodeFrequency, Object> & Serializable)x0$1 -> {
            QualityWriter$.$anonfun$write$5(writer, x0$1);
            return BoxedUnit.UNIT;
        });
        writer.println();
    }

    public static final /* synthetic */ String $anonfun$decOptFmt$1(double x$1) {
        return org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.Decimal00Format().format(x$1);
    }

    public static final /* synthetic */ int $anonfun$perBarcodeQualityData$1(State state$2, String colBarcode$1, String rowBarcode) {
        return state$2.known().count(new Tuple2<String, String>(rowBarcode, colBarcode$1));
    }

    private QualityWriter$() {
    }
}

