/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.ArrayListWrapper;
import org.apache.commons.jexl2.internal.Introspector;
import org.apache.commons.jexl2.internal.introspection.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodExecutor
extends AbstractExecutor.Method {
    private final boolean isVarArgs;

    public MethodExecutor(Introspector is, Object obj, String name, Object[] args) {
        super(obj.getClass(), MethodExecutor.discover(is, obj, name, args));
        this.isVarArgs = this.method != null && MethodExecutor.isVarArgMethod(this.method);
    }

    @Override
    public Object execute(Object o, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (this.isVarArgs) {
            Class<?>[] formal = this.method.getParameterTypes();
            int index = formal.length - 1;
            Class<?> type = formal[index].getComponentType();
            if (args.length >= index) {
                args = this.handleVarArg(type, index, args);
            }
        }
        if (this.method.getDeclaringClass() == ArrayListWrapper.class && o.getClass().isArray()) {
            return this.method.invoke((Object)new ArrayListWrapper(o), args);
        }
        return this.method.invoke(o, args);
    }

    @Override
    public Object tryExecute(String name, Object obj, Object[] args) {
        MethodKey tkey = new MethodKey(name, args);
        if (this.objectClass.equals(obj.getClass()) && tkey.equals(this.key)) {
            try {
                return this.execute(obj, args);
            }
            catch (InvocationTargetException xinvoke) {
                return TRY_FAILED;
            }
            catch (IllegalAccessException xill) {
                return TRY_FAILED;
            }
        }
        return TRY_FAILED;
    }

    private static AbstractExecutor.Method.Parameter discover(Introspector is, Object obj, String method, Object[] args) {
        MethodKey key;
        Class<?> clazz = obj.getClass();
        Method m = is.getMethod(clazz, key = new MethodKey(method, args));
        if (m == null && clazz.isArray()) {
            m = is.getMethod(ArrayListWrapper.class, key);
        }
        if (m == null && obj instanceof Class) {
            m = is.getMethod((Class)obj, key);
        }
        return new AbstractExecutor.Method.Parameter(m, key);
    }

    protected Object[] handleVarArg(Class<?> type, int index, Object[] actual) {
        int size = actual.length - index;
        if (size == 1) {
            Class<?> aclazz;
            if (!(actual[index] == null || (aclazz = actual[index].getClass()).isArray() && aclazz.getComponentType().equals(type))) {
                Object lastActual = Array.newInstance(type, 1);
                Array.set(lastActual, 0, actual[index]);
                actual[index] = lastActual;
            }
        } else {
            Object lastActual = Array.newInstance(type, size);
            for (int i = 0; i < size; ++i) {
                Array.set(lastActual, i, actual[index + i]);
            }
            Object[] newActual = new Object[index + 1];
            System.arraycopy(actual, 0, newActual, 0, index);
            newActual[index] = lastActual;
            actual = newActual;
        }
        return actual;
    }

    private static boolean isVarArgMethod(Method m) {
        Class<?>[] formal = m.getParameterTypes();
        if (formal == null || formal.length == 0) {
            return false;
        }
        Class<?> last2 = formal[formal.length - 1];
        return last2.isArray();
    }
}

