/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3;

import cats.Invariant$;
import cats.Semigroupal$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.BuildInfo$;
import org.broadinstitute.gpp.poolq3.PoolQConfig;
import org.broadinstitute.gpp.poolq3.PoolQConfig$;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.package$;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet$;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.NoOpConsumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import org.broadinstitute.gpp.poolq3.process.ScoringConsumer;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.reference.ExactReference;
import org.broadinstitute.gpp.poolq3.reference.ExactReference$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.BarcodeCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter$;
import org.broadinstitute.gpp.poolq3.reports.CountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.LogNormalizedCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.QualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.RunInfoWriter$;
import org.broadinstitute.gpp.poolq3.reports.UmiQualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter$;
import org.broadinstitute.gpp.poolq3.types.BarcodeCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.CountsFileType$;
import org.broadinstitute.gpp.poolq3.types.LogNormalizedCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.OutputFileType;
import org.broadinstitute.gpp.poolq3.types.PoolQRunSummary;
import org.broadinstitute.gpp.poolq3.types.PoolQSummary;
import org.broadinstitute.gpp.poolq3.types.QualityFileType$;
import org.broadinstitute.gpp.poolq3.types.RunInfoFileType$;
import org.broadinstitute.gpp.poolq3.types.UnexpectedSequencesFileType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class PoolQ$ {
    public static final PoolQ$ MODULE$ = new PoolQ$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.PoolQ");
    private static final Set<OutputFileType> AlwaysWrittenFiles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OutputFileType[]{CountsFileType$.MODULE$, QualityFileType$.MODULE$, LogNormalizedCountsFileType$.MODULE$, BarcodeCountsFileType$.MODULE$, RunInfoFileType$.MODULE$}));

    public final void main(String[] args) {
        Option<PoolQConfig> option = PoolQConfig$.MODULE$.parse(args);
        if (None$.MODULE$.equals(option)) {
            System.exit(-1);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            PoolQConfig config = (PoolQConfig)some.value();
            Try<PoolQSummary> try_ = this.run(config);
            if (try_ instanceof Success) {
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                log.error("PoolQ failed", t);
                System.exit(-1);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        throw new MatchError(option);
    }

    public final Try<PoolQSummary> run(PoolQConfig config) {
        LazyRef unexpectedSequenceCacheDir$lzy = new LazyRef();
        if (log.isInfoEnabled()) {
            log.info(new StringBuilder(15).append("PoolQ version: ").append(BuildInfo$.MODULE$.version()).toString());
        }
        this.logCli(config);
        log.info("Reading row reference data");
        ReferenceData rowReferenceData = ReferenceData$.MODULE$.apply(config.input().rowReference(), ReferenceData$.MODULE$.apply$default$2());
        log.info("Reading column reference data");
        ReferenceData colReferenceData = ReferenceData$.MODULE$.apply(config.input().colReference(), ReferenceData$.MODULE$.apply$default$2()).forColumnBarcodes(config.reportsDialect());
        Option<Path> option = config.input().globalReference();
        log.info("Reading global reference data");
        Option globalReferenceDataOpt = option.map((Function1<Path, ReferenceData> & Serializable)x$1 -> ReferenceData$.MODULE$.apply((Path)x$1, ReferenceData$.MODULE$.apply$default$2()));
        Tuple3<BarcodePolicy, Option<BarcodePolicy>, Object> tuple3 = this.makeRowBarcodePolicy(rowReferenceData, config.rowBarcodePolicyStr(), config.reverseRowBarcodePolicyStr(), config.input().reverseRowReads(), config.skipShortReads());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        BarcodePolicy rowBarcodePolicy = tuple3._1();
        Option<BarcodePolicy> revRowBarcodePolicyOpt = tuple3._2();
        int rowBarcodeLength = BoxesRunTime.unboxToInt(tuple3._3());
        Tuple3<BarcodePolicy, Option<BarcodePolicy>, Integer> tuple32 = new Tuple3<BarcodePolicy, Option<BarcodePolicy>, Integer>(rowBarcodePolicy, revRowBarcodePolicyOpt, BoxesRunTime.boxToInteger(rowBarcodeLength));
        BarcodePolicy rowBarcodePolicy2 = tuple32._1();
        Option<BarcodePolicy> revRowBarcodePolicyOpt2 = tuple32._2();
        int rowBarcodeLength2 = BoxesRunTime.unboxToInt(tuple32._3());
        BarcodePolicy colBarcodePolicy = BarcodePolicy$.MODULE$.apply(config.colBarcodePolicyStr(), colReferenceData.barcodeLength(), config.skipShortReads());
        Option umiInfo = package$all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2<Option<Path>, Option<String>>(config.input().umiReference(), config.umiBarcodePolicyStr())).mapN((Function2<Path, String, Tuple2> & Serializable)(r, p) -> {
            log.info("Reading UMI reference data");
            BarcodeSet ref = BarcodeSet$.MODULE$.apply((Path)r);
            BarcodePolicy pol = BarcodePolicy$.MODULE$.apply((String)p, ref.barcodeLength(), false);
            return new Tuple2<BarcodeSet, BarcodePolicy>(ref, pol);
        }, Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
        log.info("Building row reference");
        Reference rowReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.rowMatchFn(), ReferenceData$.MODULE$.truncator(rowBarcodeLength2), config.countAmbiguous(), rowReferenceData.mappings());
        log.info("Building column reference");
        Reference colReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.colMatchFn(), ReferenceData$.MODULE$.truncator(colBarcodePolicy.length()), config.countAmbiguous(), colReferenceData.mappings());
        Option globalReference = globalReferenceDataOpt.map((Function1<ReferenceData, ExactReference> & Serializable)referenceData -> {
            log.info("Building global reference");
            return ExactReference$.MODULE$.apply(referenceData.mappings(), (Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x), false);
        });
        CloseableIterable<Barcodes> barcodes = package$.MODULE$.barcodeSource(config.input(), rowBarcodePolicy2, revRowBarcodePolicyOpt2, colBarcodePolicy, umiInfo.map((Function1<Tuple2, BarcodePolicy> & Serializable)x$3 -> (BarcodePolicy)x$3._2()));
        Consumer consumer = config.noopConsumer() ? new NoOpConsumer() : new ScoringConsumer(rowReference, colReference, config.countAmbiguous(), config.alwaysCountColumnBarcodes(), umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)x$5 -> (BarcodeSet)x$5._1()), PoolQ$.unexpectedSequenceCacheDir$1(unexpectedSequenceCacheDir$lzy, config), config.isPairedEnd());
        return this.runProcess(barcodes, consumer).flatMap((Function1<PoolQRunSummary, Try> & Serializable)runSummary -> {
            State state = runSummary.state();
            ShardedHistogram<String, Tuple2<String, String>> counts = state.known();
            return Try$.MODULE$.apply(() -> {
                if (log.isInfoEnabled()) {
                    log.info(new StringBuilder(20).append("Writing counts file ").append(config.output().countsFile()).toString());
                    return;
                }
            }).flatMap((Function1<BoxedUnit, Try> & Serializable)x$27 -> {
                BoxedUnit boxedUnit = x$27;
                return CountsWriter$.MODULE$.write(config.output().countsFile(), config.output().umiCountsFilesDir(), counts, rowReference, colReference, umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)x$6 -> (BarcodeSet)x$6._1()), config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$9 -> {
                    BoxedUnit boxedUnit;
                    if (log.isInfoEnabled()) {
                        log.info(new StringBuilder(21).append("Writing quality file ").append(config.output().qualityFile()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return QualityWriter$.MODULE$.write(config.output().qualityFile(), state, rowReference, colReference, config.isPairedEnd()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$25 -> {
                        BoxedUnit boxedUnit = x$25;
                        return ((Try)umiInfo.fold((Function0<Try> & Serializable)() -> (Try)ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(BoxedUnit.UNIT), Invariant$.MODULE$.catsInstancesForTry()), (Function1<Tuple2, Try> & Serializable)x$7 -> UmiQualityWriter$.MODULE$.write(config.output().umiQualityFile(), state))).flatMap((Function1<BoxedUnit, Try> & Serializable)x$11 -> {
                            BoxedUnit boxedUnit;
                            if (log.isInfoEnabled()) {
                                log.info(new StringBuilder(35).append("Writing log-normalized counts file ").append(config.output().normalizedCountsFile()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            Map<String, Map<String, Object>> normalizedCounts = LogNormalizedCountsWriter$.MODULE$.logNormalizedCounts(counts, rowReference, colReference);
                            return LogNormalizedCountsWriter$.MODULE$.write(config.output().normalizedCountsFile(), normalizedCounts, rowReference, colReference, config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$13 -> {
                                BoxedUnit boxedUnit;
                                if (log.isInfoEnabled()) {
                                    log.info(new StringBuilder(28).append("Writing barcode counts file ").append(config.output().barcodeCountsFile()).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return BarcodeCountsWriter$.MODULE$.write(config.output().barcodeCountsFile(), config.output().umiBarcodeCountsFilesDir(), counts, rowReference, colReference, umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)x$8 -> (BarcodeSet)x$8._1()), config.reportsDialect()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$15 -> {
                                    BoxedUnit boxedUnit;
                                    if (log.isInfoEnabled()) {
                                        log.info(new StringBuilder(25).append("Writing correlation file ").append(config.output().correlationFile()).toString());
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit2 = boxedUnit;
                                    return CorrelationFileWriter$.MODULE$.write(config.output().correlationFile(), normalizedCounts, rowReference, colReference).flatMap((Function1<Option, Try> & Serializable)cfto -> ((Try)PoolQ$.unexpectedSequenceCacheDir$1(unexpectedSequenceCacheDir$lzy, config).fold((Function0<Try> & Serializable)() -> Try$.MODULE$.apply((Function0<Option> & Serializable)() -> Option$.MODULE$.empty()), (Function1<Path, Try> & Serializable)dir -> {
                                        Try<BoxedUnit> ret;
                                        block2: {
                                            if (log.isInfoEnabled()) {
                                                log.info(new StringBuilder(35).append("Writing unexpected sequence report ").append(config.output().unexpectedSequencesFile()).toString());
                                            }
                                            ret = package$all$.MODULE$.toFunctorOps(UnexpectedSequenceWriter$.MODULE$.write(config.output().unexpectedSequencesFile(), (Path)dir, config.unexpectedSequencesToReport(), colReference, globalReference), Invariant$.MODULE$.catsInstancesForTry()).as(OptionIdOps$.MODULE$.some$extension(package$all$.MODULE$.catsSyntaxOptionId(UnexpectedSequencesFileType$.MODULE$)));
                                            if (!config.removeUnexpectedSequenceCache()) break block2;
                                            if (log.isInfoEnabled()) {
                                                log.info(new StringBuilder(35).append("Removing unexpected sequence cache ").append(config.unexpectedSequenceCacheDir()).toString());
                                            }
                                            UnexpectedSequenceWriter$.MODULE$.removeCache((Path)dir);
                                        }
                                        return ret;
                                    })).flatMap((Function1<Option, Try> & Serializable)usfto -> {
                                        BoxedUnit boxedUnit;
                                        if (log.isInfoEnabled()) {
                                            log.info(new StringBuilder(17).append("Writing run info ").append(config.output().unexpectedSequencesFile()).toString());
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return RunInfoWriter$.MODULE$.write(config.output().runInfoFile(), config).map((Function1<BoxedUnit, PoolQSummary> & Serializable)x$18 -> {
                                            log.info("PoolQ complete");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return new PoolQSummary((PoolQRunSummary)runSummary, (Set)AlwaysWrittenFiles.$plus$plus((IterableOnce)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{cfto, usfto}))).flatten(Predef$.MODULE$.$conforms())));
                                        });
                                    }));
                                });
                            });
                        });
                    });
                });
            });
        });
    }

    public Try<PoolQRunSummary> runProcess(CloseableIterable<Barcodes> barcodes, Consumer consumer) {
        return Using$.MODULE$.apply((Function0<CloseableIterator> & Serializable)() -> barcodes.iterator(), (Function1<CloseableIterator, PoolQRunSummary> & Serializable)iterator -> {
            PoolQProcess process = new PoolQProcess((Iterator<Barcodes>)iterator, consumer, PoolQProcess$.MODULE$.$lessinit$greater$default$3(), PoolQProcess$.MODULE$.$lessinit$greater$default$4());
            return process.run();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public Tuple3<BarcodePolicy, Option<BarcodePolicy>, Object> makeRowBarcodePolicy(ReferenceData rowReferenceData, String rowBarcodePolicyStr, Option<String> reverseRowBarcodePolicyStr, Option<Path> reverseRowReads, boolean skipShortReads) {
        return (Tuple3)package$all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2<Option<String>, Option<Path>>(reverseRowBarcodePolicyStr, reverseRowReads)).mapN((Function2<String, Path, Tuple3> & Serializable)(revPolicy, x$29) -> {
            Tuple2<Object, Object> tuple2 = rowReferenceData.barcodeLengths();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int forwardRowBcLength = tuple2._1$mcI$sp();
            int revRowBcLength = tuple2._2$mcI$sp();
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(forwardRowBcLength, revRowBcLength);
            int forwardRowBcLength2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
            int revRowBcLength2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
            BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(rowBarcodePolicyStr, forwardRowBcLength2, skipShortReads);
            BarcodePolicy revRowBarcodePolicy = BarcodePolicy$.MODULE$.apply((String)revPolicy, revRowBcLength2, skipShortReads);
            return new Tuple3<BarcodePolicy, Some<BarcodePolicy>, Integer>(rowBarcodePolicy, new Some<BarcodePolicy>(revRowBarcodePolicy), BoxesRunTime.boxToInteger(rowBarcodePolicy.length() + revRowBarcodePolicy.length()));
        }, Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption()).getOrElse((Function0<Tuple3> & Serializable)() -> {
            BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(rowBarcodePolicyStr, rowReferenceData.barcodeLength(), skipShortReads);
            return new Tuple3<BarcodePolicy, None$, Integer>(rowBarcodePolicy, None$.MODULE$, BoxesRunTime.boxToInteger(rowBarcodePolicy.length()));
        });
    }

    private void logCli(PoolQConfig config) {
        String logStr = ((AbstractIterable)PoolQConfig$.MODULE$.synthesizeArgs(config).map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String param2 = (String)tuple2._1();
                String string = (String)tuple2._2();
                if ("".equals(string)) {
                    return new StringBuilder(2).append("--").append(param2).toString();
                }
            }
            if (tuple2 != null) {
                String param3 = (String)tuple2._1();
                String arg = (String)tuple2._2();
                return new StringBuilder(3).append("--").append(param3).append(" ").append(arg).toString();
            }
            throw new MatchError(tuple2);
        })).mkString(" \\\n");
        if (log.isInfoEnabled()) {
            log.info(new StringBuilder(29).append("PoolQ command-line settings:\n").append(logStr).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$run$8(Path path) {
        if (log.isInfoEnabled()) {
            log.info(new StringBuilder(43).append("Writing unexpected sequence cache files to ").append(path).toString());
            return;
        }
    }

    private static final /* synthetic */ Option unexpectedSequenceCacheDir$lzycompute$1(LazyRef unexpectedSequenceCacheDir$lzy$1, PoolQConfig config$1) {
        Option option;
        LazyRef lazyRef = unexpectedSequenceCacheDir$lzy$1;
        synchronized (lazyRef) {
            Option option2;
            if (unexpectedSequenceCacheDir$lzy$1.initialized()) {
                option2 = (Option)unexpectedSequenceCacheDir$lzy$1.value();
            } else {
                Option option3;
                if (config$1.skipUnexpectedSequenceReport()) {
                    option3 = None$.MODULE$;
                } else {
                    Option ret = config$1.unexpectedSequenceCacheDir().map((Function1<Path, Path> & Serializable)x$4 -> Files.createDirectories(x$4, new FileAttribute[0])).orElse((Function0<Some> & Serializable)() -> {
                        Path ret = Files.createTempDirectory("unexpected-sequence-cache", new FileAttribute[0]);
                        return new Some<Path>(ret);
                    });
                    ret.foreach((Function1<Path, Object> & Serializable)path -> {
                        PoolQ$.$anonfun$run$8(path);
                        return BoxedUnit.UNIT;
                    });
                    option3 = ret;
                }
                option2 = unexpectedSequenceCacheDir$lzy$1.initialize(option3);
            }
            option = option2;
        }
        return option;
    }

    private static final Option unexpectedSequenceCacheDir$1(LazyRef unexpectedSequenceCacheDir$lzy$1, PoolQConfig config$1) {
        if (unexpectedSequenceCacheDir$lzy$1.initialized()) {
            return (Option)unexpectedSequenceCacheDir$lzy$1.value();
        }
        return PoolQ$.unexpectedSequenceCacheDir$lzycompute$1(unexpectedSequenceCacheDir$lzy$1, config$1);
    }

    private PoolQ$() {
    }
}

