/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.barcode.GeneralTemplatePolicy;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask$;
import org.broadinstitute.gpp.poolq3.barcode.SplitBarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.TemplatePolicy;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class TemplatePolicy$
implements Serializable {
    public static final TemplatePolicy$ MODULE$ = new TemplatePolicy$();
    private static final Regex Regex1 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^:([ACGTRYSWKMBDHVNacgtryswkmbdhvn]+)(?:@(\\d+)?(-\\d+)?)?$"));
    private static final Regex Regex2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([acgt]+)(N+)(n+)([acgt]+)(N+)[acgt]*$"));

    public Regex Regex1() {
        return Regex1;
    }

    public Regex Regex2() {
        return Regex2;
    }

    public TemplatePolicy apply(String s, int refBarcodeLength) {
        Option<List<String>> option;
        String string = s;
        if (string != null && !(option = this.Regex1().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(3) == 0) {
            Option<List<String>> option2;
            String ctx = (String)((LinearSeqOps)option.get()).apply(0);
            String minStr = (String)((LinearSeqOps)option.get()).apply(1);
            String maxStr = (String)((LinearSeqOps)option.get()).apply(2);
            String string2 = ctx;
            if (string2 != null && !(option2 = this.Regex2().unapplySeq(string2)).isEmpty() && option2.get() != null && option2.get().lengthCompare(5) == 0) {
                String p1 = (String)((LinearSeqOps)option2.get()).apply(0);
                String b1 = (String)((LinearSeqOps)option2.get()).apply(1);
                String gap = (String)((LinearSeqOps)option2.get()).apply(2);
                String p2 = (String)((LinearSeqOps)option2.get()).apply(3);
                String b2 = (String)((LinearSeqOps)option2.get()).apply(4);
                if (b1.length() + b2.length() != refBarcodeLength) {
                    throw new IllegalArgumentException(new StringBuilder(51).append(s).append(" is not compatible with the provided reference file").toString());
                }
                Option<Object> min = Option$.MODULE$.apply(minStr).map((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
                Option<Object> max = Option$.MODULE$.apply(maxStr).map((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(x$5))))));
                return new SplitBarcodePolicy(p1.toUpperCase(), b1.length(), gap.length(), p2.toUpperCase(), b2.length(), min, max);
            }
            KeyMask km = KeyMask$.MODULE$.apply(ctx);
            if (km.keyLengthInBases() != refBarcodeLength) {
                throw new IllegalArgumentException(new StringBuilder(51).append(s).append(" is not compatible with the provided reference file").toString());
            }
            Option<Object> min = Option$.MODULE$.apply(minStr).map((Function1<String, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$6))));
            Option<Object> max = Option$.MODULE$.apply(maxStr).map((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(x$7))))));
            return new GeneralTemplatePolicy(km, min, max);
        }
        throw new IllegalArgumentException(new StringBuilder(42).append("Incomprehensible template barcode policy: ").append(s).toString());
    }

    public final boolean compatible(char p, char b) {
        char c = p;
        switch (c) {
            case 'N': {
                return true;
            }
            case 'A': {
                return b == 'A';
            }
            case 'C': {
                return b == 'C';
            }
            case 'G': {
                return b == 'G';
            }
            case 'T': {
                return b == 'T';
            }
            case 'R': {
                return b == 'A' || b == 'G';
            }
            case 'Y': {
                return b == 'C' || b == 'T';
            }
            case 'S': {
                return b == 'G' || b == 'C';
            }
            case 'W': {
                return b == 'A' || b == 'T';
            }
            case 'K': {
                return b == 'G' || b == 'T';
            }
            case 'M': {
                return b == 'A' || b == 'C';
            }
            case 'B': {
                return b == 'C' || b == 'G' || b == 'T';
            }
            case 'D': {
                return b == 'A' || b == 'G' || b == 'T';
            }
            case 'H': {
                return b == 'A' || b == 'C' || b == 'T';
            }
            case 'V': {
                return b == 'A' || b == 'C' || b == 'G';
            }
        }
        return false;
    }

    public final boolean satisfies(char[] template, String seq, int seqOffset) {
        for (int i = 0; i < template.length; ++i) {
            if (this.compatible(template[i], StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(seq), seqOffset + i))) continue;
            return false;
        }
        return true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TemplatePolicy$.class);
    }

    private TemplatePolicy$() {
    }
}

