/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam.bamV1_0;

import htsjdk.beta.codecs.reads.ReadsCodecUtils;
import htsjdk.beta.codecs.reads.bam.BAMDecoder;
import htsjdk.beta.codecs.reads.bam.bamV1_0.BAMCodecV1_0;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsIntervalUtils;
import htsjdk.beta.plugin.interval.HtsQueryRule;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class BAMDecoderV1_0
extends BAMDecoder {
    private final SamReader samReader;
    private final SAMFileHeader samFileHeader;

    public BAMDecoderV1_0(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        super(inputBundle, readsDecoderOptions);
        this.samReader = ReadsCodecUtils.getSamReader(inputBundle, readsDecoderOptions, SamReaderFactory.makeDefault());
        this.samFileHeader = this.samReader.getFileHeader();
    }

    @Override
    public HtsVersion getVersion() {
        return BAMCodecV1_0.VERSION_1;
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.samFileHeader;
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return this.samReader.iterator();
    }

    @Override
    public boolean isQueryable() {
        return ReadsCodecUtils.bundleContainsIndex(this.getInputBundle()) && this.samReader.isQueryable();
    }

    @Override
    public boolean hasIndex() {
        return ReadsCodecUtils.bundleContainsIndex(this.getInputBundle()) && this.samReader.hasIndex();
    }

    @Override
    public CloseableIterator<SAMRecord> query(List<HtsInterval> intervals, HtsQueryRule queryRule) {
        ValidationUtils.nonNull(intervals, "intervals");
        ValidationUtils.nonNull(queryRule, "queryRule");
        ReadsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        QueryInterval[] queryIntervals = HtsIntervalUtils.toQueryIntervalArray(intervals, this.samFileHeader.getSequenceDictionary());
        return this.samReader.query(queryIntervals, queryRule == HtsQueryRule.CONTAINED);
    }

    @Override
    public CloseableIterator<SAMRecord> queryStart(String queryName, long start) {
        ValidationUtils.nonNull(queryName, "queryName");
        ReadsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return this.samReader.queryAlignmentStart(queryName, HtsIntervalUtils.toIntegerSafe(start));
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        ReadsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return this.samReader.queryUnmapped();
    }

    @Override
    public Optional<SAMRecord> queryMate(SAMRecord samRecord) {
        ValidationUtils.nonNull(samRecord, "samRecord");
        ReadsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return Optional.ofNullable(this.samReader.queryMate(samRecord));
    }

    @Override
    public void close() {
        try {
            this.samReader.close();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception closing reader for %s", this.getInputBundle()), e);
        }
    }
}

