/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class IOUtils {
    public static IOPath createTempPath(String prefix, String suffix) {
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
            return new HtsPath(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(e);
        }
    }

    public static HtsPath toHtsPath(Path toConvert) {
        return null == toConvert ? null : new HtsPath(toConvert.toUri().toString());
    }

    public static String getStringFromPath(IOPath ioPath) {
        try {
            StringWriter stringWriter = new StringWriter();
            Files.lines(ioPath.toPath(), StandardCharsets.UTF_8).forEach(line -> {
                stringWriter.write((String)line);
                stringWriter.append("\n");
            });
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failed to load reads bundle json from: %s", ioPath.getRawInputString()), e);
        }
    }

    public static void writeStringToPath(IOPath ioPath, String contents, boolean gzipOutput) {
        block41: {
            if (gzipOutput) {
                try (BufferedOutputStream bos = new BufferedOutputStream(ioPath.getOutputStream());
                     BlockCompressedOutputStream bcos = new BlockCompressedOutputStream((OutputStream)bos, ioPath.toPath());){
                    bcos.write(contents.getBytes());
                    break block41;
                }
                catch (IOException e) {
                    throw new HtsjdkIOException(String.format("Failed to load reads bundle json from: %s", ioPath.getRawInputString()), e);
                }
            }
            try (BufferedOutputStream bos = new BufferedOutputStream(ioPath.getOutputStream());){
                bos.write(contents.getBytes());
            }
            catch (IOException e) {
                throw new HtsjdkIOException(String.format("Failed to load reads bundle json from: %s", ioPath.getRawInputString()), e);
            }
        }
    }
}

