/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;

class CompressedIndexFileBuffer
implements IndexFileBuffer {
    private final BlockCompressedInputStream mCompressedStream;
    private final BinaryCodec binaryCodec;

    CompressedIndexFileBuffer(File file) {
        try {
            this.mCompressedStream = new BlockCompressedInputStream(file);
            this.binaryCodec = new BinaryCodec(this.mCompressedStream);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Construction error of CSI compressed stream: " + ioe);
        }
    }

    CompressedIndexFileBuffer(SeekableStream seekableStream) {
        this.mCompressedStream = new BlockCompressedInputStream(seekableStream);
        this.binaryCodec = new BinaryCodec(this.mCompressedStream);
    }

    @Override
    public void readBytes(byte[] bytes) {
        this.binaryCodec.readBytes(bytes);
    }

    @Override
    public int readInteger() {
        return this.binaryCodec.readInt();
    }

    @Override
    public long readLong() {
        return this.binaryCodec.readLong();
    }

    @Override
    public void skipBytes(int count) {
        if (this.mCompressedStream == null) {
            throw new SAMException("Null input stream.");
        }
        try {
            this.mCompressedStream.skip(count);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Skip error in CSI compressed stream: " + ioe);
        }
    }

    @Override
    public void seek(long position) {
        if (this.mCompressedStream == null) {
            throw new SAMException("Null input stream.");
        }
        try {
            this.mCompressedStream.seek(position);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Seek error in CSI compressed stream: " + ioe);
        }
    }

    @Override
    public long position() {
        if (this.mCompressedStream == null) {
            throw new SAMException("Null input stream.");
        }
        return this.mCompressedStream.getPosition();
    }

    @Override
    public void close() {
        if (this.mCompressedStream == null) {
            throw new SAMException("Null input stream.");
        }
        try {
            this.mCompressedStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Close error in CSI compressed stream: " + ioe);
        }
    }
}

