/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.SimpleAllele;
import htsjdk.variant.variantcontext.StructuralVariantType;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public interface Allele
extends Comparable<Allele>,
Serializable {
    public static final String NO_CALL_STRING = ".";
    public static final String SPAN_DEL_STRING = "*";
    public static final char SINGLE_BREAKEND_INDICATOR = '.';
    public static final char BREAKEND_EXTENDING_RIGHT = '[';
    public static final char BREAKEND_EXTENDING_LEFT = ']';
    public static final char SYMBOLIC_ALLELE_START = '<';
    public static final char SYMBOLIC_ALLELE_END = '>';
    public static final String NON_REF_STRING = "<NON_REF>";
    public static final String UNSPECIFIED_ALTERNATE_ALLELE_STRING = "<*>";
    public static final Allele REF_A = new SimpleAllele("A", true);
    public static final Allele ALT_A = new SimpleAllele("A", false);
    public static final Allele REF_C = new SimpleAllele("C", true);
    public static final Allele ALT_C = new SimpleAllele("C", false);
    public static final Allele REF_G = new SimpleAllele("G", true);
    public static final Allele ALT_G = new SimpleAllele("G", false);
    public static final Allele REF_T = new SimpleAllele("T", true);
    public static final Allele ALT_T = new SimpleAllele("T", false);
    public static final Allele REF_N = new SimpleAllele("N", true);
    public static final Allele ALT_N = new SimpleAllele("N", false);
    public static final Allele SPAN_DEL = new SimpleAllele("*", false);
    public static final Allele NO_CALL = new SimpleAllele(".", false);
    public static final Allele NON_REF_ALLELE = new SimpleAllele("<NON_REF>", false);
    public static final Allele UNSPECIFIED_ALTERNATE_ALLELE = new SimpleAllele("<*>", false);
    public static final Allele SV_SIMPLE_DEL = StructuralVariantType.DEL.toSymbolicAltAllele();
    public static final Allele SV_SIMPLE_INS = StructuralVariantType.INS.toSymbolicAltAllele();
    public static final Allele SV_SIMPLE_INV = StructuralVariantType.INV.toSymbolicAltAllele();
    public static final Allele SV_SIMPLE_CNV = StructuralVariantType.CNV.toSymbolicAltAllele();
    public static final Allele SV_SIMPLE_DUP = StructuralVariantType.DUP.toSymbolicAltAllele();

    public static Allele create(byte[] bases, boolean isRef) {
        if (bases == null) {
            throw new IllegalArgumentException("create: the Allele base string cannot be null; use new Allele() or new Allele(\"\") to create a Null allele");
        }
        if (bases.length == 1) {
            switch (bases[0]) {
                case 46: {
                    if (isRef) {
                        throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
                    }
                    return NO_CALL;
                }
                case 42: {
                    if (isRef) {
                        throw new IllegalArgumentException("Cannot tag a spanning deletions allele as the reference allele");
                    }
                    return SPAN_DEL;
                }
                case 65: 
                case 97: {
                    return isRef ? REF_A : ALT_A;
                }
                case 67: 
                case 99: {
                    return isRef ? REF_C : ALT_C;
                }
                case 71: 
                case 103: {
                    return isRef ? REF_G : ALT_G;
                }
                case 84: 
                case 116: {
                    return isRef ? REF_T : ALT_T;
                }
                case 78: 
                case 110: {
                    return isRef ? REF_N : ALT_N;
                }
            }
            throw new IllegalArgumentException("Illegal base [" + (char)bases[0] + "] seen in the allele");
        }
        return new SimpleAllele((byte[])bases.clone(), isRef);
    }

    public static Allele create(byte base, boolean isRef) {
        return Allele.create(new byte[]{base}, isRef);
    }

    public static Allele create(byte base) {
        return Allele.create(base, false);
    }

    public static Allele extend(Allele left, byte[] right) {
        if (left.isSymbolic()) {
            throw new IllegalArgumentException("Cannot extend a symbolic allele");
        }
        byte[] bases = new byte[left.length() + right.length];
        System.arraycopy(left.getBases(), 0, bases, 0, left.length());
        System.arraycopy(right, 0, bases, left.length(), right.length);
        return Allele.create(bases, left.isReference());
    }

    @Deprecated
    public static boolean wouldBeNullAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 45 || bases.length == 0;
    }

    @Deprecated
    public static boolean wouldBeStarAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 42;
    }

    @Deprecated
    public static boolean wouldBeNoCallAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 46;
    }

    @Deprecated
    public static boolean wouldBeSymbolicAllele(byte[] bases) {
        if (bases.length <= 1) {
            return false;
        }
        return bases[0] == 60 || bases[bases.length - 1] == 62 || Allele.wouldBeBreakpoint(bases) || Allele.wouldBeSingleBreakend(bases);
    }

    @Deprecated
    public static boolean wouldBeBreakpoint(byte[] bases) {
        if (bases.length <= 1) {
            return false;
        }
        for (byte base : bases) {
            if (base != 93 && base != 91) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean wouldBeSingleBreakend(byte[] bases) {
        if (bases.length <= 1) {
            return false;
        }
        return bases[0] == 46 || bases[bases.length - 1] == 46;
    }

    public static boolean acceptableAlleleBases(String bases) {
        return Allele.acceptableAlleleBases(bases.getBytes(), true);
    }

    public static boolean acceptableAlleleBases(String bases, boolean isReferenceAllele) {
        return Allele.acceptableAlleleBases(bases.getBytes(StandardCharsets.UTF_8), isReferenceAllele);
    }

    public static boolean acceptableAlleleBases(byte[] bases) {
        return Allele.acceptableAlleleBases(bases, true);
    }

    public static boolean acceptableAlleleBases(byte[] bases, boolean isReferenceAllele) {
        if (Allele.wouldBeNullAllele(bases)) {
            return false;
        }
        if (Allele.wouldBeNoCallAllele(bases) || Allele.wouldBeSymbolicAllele(bases)) {
            return true;
        }
        if (Allele.wouldBeStarAllele(bases)) {
            return !isReferenceAllele;
        }
        block3: for (byte base : bases) {
            switch (base) {
                case 65: 
                case 67: 
                case 71: 
                case 78: 
                case 84: 
                case 97: 
                case 99: 
                case 103: 
                case 110: 
                case 116: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Allele create(String bases, boolean isRef) {
        return Allele.create(bases.getBytes(), isRef);
    }

    public static Allele create(String bases) {
        return Allele.create(bases, false);
    }

    public static Allele create(byte[] bases) {
        return Allele.create(bases, false);
    }

    public static Allele create(Allele allele, boolean ignoreRefState) {
        return new SimpleAllele(allele.getBases(), allele.isReference() && !ignoreRefState);
    }

    public static boolean oneIsPrefixOfOther(Allele a1, Allele a2) {
        if (a2.length() >= a1.length()) {
            return a1.isPrefixOf(a2);
        }
        return a2.isPrefixOf(a1);
    }

    public boolean isPrefixOf(Allele var1);

    public boolean isNoCall();

    public boolean isCalled();

    public boolean isReference();

    public boolean isNonReference();

    public boolean isSymbolic();

    public boolean isBreakpoint();

    public boolean isSingleBreakend();

    public String toString();

    public byte[] getBases();

    public String getBaseString();

    public String getDisplayString();

    public byte[] getDisplayBases();

    public boolean equals(Object var1);

    public int hashCode();

    public boolean equals(Allele var1, boolean var2);

    public boolean basesMatch(byte[] var1);

    public boolean basesMatch(String var1);

    public boolean basesMatch(Allele var1);

    public int length();

    public boolean isNonRefAllele();
}

