/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reference;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua!B\b\u0011\u0003\u0003Y\u0002\u0002\u0003\u0014\u0001\u0005\u000b\u0007IQA\u0014\t\u0011q\u0002!\u0011!Q\u0001\u000e!B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\")a\u000b\u0001C\u0001/\")A\f\u0001C\u0003;\")!\u000e\u0001C\u0003W\")\u0001\u000f\u0001C\u0003c\")1\u000f\u0001C\u0003i\"Aq\u000f\u0001EC\u0002\u0013\u0015\u0001\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003\u000f\u0001\u0001R1A\u0005\u0006\u001dB\u0011\"!\u0003\u0001\u0005\u0004%)!a\u0003\t\u0011\u0005M\u0001\u0001)A\u0007\u0003\u001b\u0011QBQ1tKJ+g-\u001a:f]\u000e,'BA\t\u0013\u0003%\u0011XMZ3sK:\u001cWM\u0003\u0002\u0014)\u00051\u0001o\\8mcNR!!\u0006\f\u0002\u0007\u001d\u0004\bO\u0003\u0002\u00181\u0005q!M]8bI&t7\u000f^5ukR,'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011\u0001E\u0005\u0003KA\u0011\u0011BU3gKJ,gnY3\u0002\u0017\u0005dGNQ1sG>$Wm]\u000b\u0002QA\u0019\u0011&\r\u001b\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u00021=\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u0005\r\u0019V-\u001d\u0006\u0003ay\u0001\"!N\u001d\u000f\u0005Y:\u0004CA\u0016\u001f\u0013\tAd$\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u001f\u00031\tG\u000e\u001c\"be\u000e|G-Z:!\u0003U\u0011\u0017M]2pI\u0016$v.\u00138qkR\u0014\u0015M]2pI\u0016\u0004Ba\u0010&5i5\t\u0001I\u0003\u0002B\u0005\u00069qN\u00196fGR\u001c(BA\"E\u0003!1\u0017m\u001d;vi&d'BA#G\u0003\r!7/\u001b\u0006\u0003\u000f\"\u000bQ!\u001e8j[&T\u0011!S\u0001\u0003SRL!a\u0013!\u0003!=\u0013'.Z2ue=\u0013'.Z2u\u001b\u0006\u0004\u0018A\u00042be\u000e|G-Z#oiJLWm\u001d\t\u0005\u007f)#d\nE\u0002P)Rj\u0011\u0001\u0015\u0006\u0003#J\u000bq!\\;uC\ndWM\u0003\u0002T=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0003&!\u0004'j].,G\rS1tQN+G/\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002$\u0001!)a%\u0002a\u0001Q!)Q(\u0002a\u0001}!)A*\u0002a\u0001\u001b\u0006!a-\u001b8e)\tq&\rE\u0002*c}\u0003\"a\t1\n\u0005\u0005\u0004\"AD'bi\u000eDW\r\u001a\"be\u000e|G-\u001a\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\bE\u0006\u00148m\u001c3f!\riRmZ\u0005\u0003Mz\u0011Q!\u0011:sCf\u0004\"!\b5\n\u0005%t\"\u0001B\"iCJ\f\u0011\"[:EK\u001aLg.\u001a3\u0015\u00051|\u0007CA\u000fn\u0013\tqgDA\u0004C_>dW-\u00198\t\u000b\r<\u0001\u0019\u0001\u001b\u0002\u001b%$7OR8s\u0005\u0006\u00148m\u001c3f)\tA#\u000fC\u0003d\u0011\u0001\u0007A'A\u0007cCJ\u001cw\u000eZ3t\r>\u0014\u0018\n\u001a\u000b\u0003QUDQA^\u0005A\u0002Q\n!!\u001b3\u0002!\t\f'oY8eKN4uN]%e\u001b\u0006\u0004X#A=\u0011\tURH\u0007`\u0005\u0003wn\u00121!T1q!\rIS\u0010N\u0005\u0003}N\u0012A\u0001T5ti\u0006i\"/\u001a4fe\u0016t7-\u001a\"be\u000e|G-\u001a$pe\u0012s\u0017MQ1sG>$W\rF\u00025\u0003\u0007Aa!!\u0002\f\u0001\u0004!\u0014aD7bi\u000eD\u0017N\\4CCJ\u001cw\u000eZ3\u0002\r\u0005dG.\u00133t\u00035\u0011\u0017M]2pI\u0016dUM\\4uQV\u0011\u0011Q\u0002\t\u0004;\u0005=\u0011bAA\t=\t\u0019\u0011J\u001c;\u0002\u001d\t\f'oY8eK2+gn\u001a;iA\u0001")
public abstract class BaseReference
implements Reference {
    private Map<String, List<String>> barcodesForIdMap;
    private Seq<String> allIds;
    private final Seq<String> allBarcodes;
    private final Object2ObjectMap<String, String> barcodeToInputBarcode;
    private final Object2ObjectMap<String, LinkedHashSet<String>> barcodeEntries;
    private final int barcodeLength;
    private volatile byte bitmap$0;

    @Override
    public final Seq<String> allBarcodes() {
        return this.allBarcodes;
    }

    @Override
    public final Seq<MatchedBarcode> find(char[] barcode) {
        return this.find(new String(barcode));
    }

    @Override
    public final boolean isDefined(String barcode) {
        return this.find(barcode).nonEmpty();
    }

    @Override
    public final Seq<String> idsForBarcode(String barcode) {
        LinkedHashSet ids = (LinkedHashSet)this.barcodeEntries.get(barcode);
        if (ids == null) {
            return package$.MODULE$.Vector().empty();
        }
        return ids.toVector();
    }

    @Override
    public final Seq<String> barcodesForId(String id) {
        return (Seq)this.barcodesForIdMap().getOrElse(id, (Function0<Nil$> & Serializable)() -> Nil$.MODULE$);
    }

    private Map<String, List<String>> barcodesForIdMap$lzycompute() {
        BaseReference baseReference = this;
        synchronized (baseReference) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                HashMap m = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.barcodeEntries.forEach((barcode, ids) -> ids.foreach((Function1<String, Option> & Serializable)id -> {
                    String string = barcode;
                    return m.put(id, ((List)m.getOrElse(id, (Function0<Nil$> & Serializable)() -> Nil$.MODULE$)).$colon$colon(string));
                }));
                this.barcodesForIdMap = m.toMap($less$colon$less$.MODULE$.refl());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.barcodesForIdMap;
    }

    public final Map<String, List<String>> barcodesForIdMap() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.barcodesForIdMap$lzycompute();
        }
        return this.barcodesForIdMap;
    }

    @Override
    public String referenceBarcodeForDnaBarcode(String matchingBarcode) {
        String inputBarcode = (String)this.barcodeToInputBarcode.get(matchingBarcode);
        if (inputBarcode == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown matching barcode ").append(matchingBarcode).toString());
        }
        return inputBarcode;
    }

    private Seq<String> allIds$lzycompute() {
        BaseReference baseReference = this;
        synchronized (baseReference) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                LinkedHashSet ids = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.allBarcodes().foreach((Function1<String, LinkedHashSet> & Serializable)barcode -> (LinkedHashSet)ids.$plus$plus$eq((IterableOnce)$this.barcodeEntries.get(barcode)));
                this.allIds = ids.toVector();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.allIds;
    }

    @Override
    public final Seq<String> allIds() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.allIds$lzycompute();
        }
        return this.allIds;
    }

    @Override
    public final int barcodeLength() {
        return this.barcodeLength;
    }

    public BaseReference(Seq<String> allBarcodes, Object2ObjectMap<String, String> barcodeToInputBarcode, Object2ObjectMap<String, LinkedHashSet<String>> barcodeEntries) {
        this.allBarcodes = allBarcodes;
        this.barcodeToInputBarcode = barcodeToInputBarcode;
        this.barcodeEntries = barcodeEntries;
        Predef$.MODULE$.require(allBarcodes.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Reference may not be empty");
        this.barcodeLength = ((String)allBarcodes.head()).length();
    }
}

