/*
 * Decompiled with CFR 0.152.
 */
package cats.syntax;

import cats.Alternative;
import cats.Applicative;
import cats.ApplicativeError;
import cats.Eval;
import cats.Now;
import cats.Show;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.EitherT$FromEitherPartiallyApplied$;
import cats.data.Ior;
import cats.data.Ior$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.kernel.Semigroup;
import cats.syntax.EitherOps;
import cats.syntax.EitherUtil$;
import java.io.Serializable;
import scala.$less$colon$less;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class EitherOps$ {
    public static final EitherOps$ MODULE$ = new EitherOps$();

    public final <A, B> void foreach$extension(Either<A, B> $this, Function1<B, BoxedUnit> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            f.apply(b);
            return;
        }
        throw new MatchError(either);
    }

    public final <BB, A, B> BB getOrElse$extension(Either<A, B> $this, Function0<BB> function0) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return function0.apply();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return (BB)b;
        }
        throw new MatchError(either);
    }

    public final <C, BB, A, B> Either<C, BB> orElse$extension(Either<A, B> $this, Function0<Either<C, BB>> fallback) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return fallback.apply();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            return EitherUtil$.MODULE$.leftCast(right);
        }
        throw new MatchError(either);
    }

    public final <BB, A, B> Either<A, BB> recover$extension(Either<A, B> $this, PartialFunction<A, BB> pf) {
        Left left;
        Object a;
        Either<A, B> either = $this;
        if (either instanceof Left && pf.isDefinedAt(a = (left = (Left)either).value())) {
            return package$.MODULE$.Right().apply(pf.apply(a));
        }
        return $this;
    }

    public final <AA, BB, A, B> Either<AA, BB> recoverWith$extension(Either<A, B> $this, PartialFunction<A, Either<AA, BB>> pf) {
        Left left;
        Object a;
        Either<A, B> either = $this;
        if (either instanceof Left && pf.isDefinedAt(a = (left = (Left)either).value())) {
            return (Either)pf.apply(a);
        }
        return $this;
    }

    public final <BB, A, B> BB valueOr$extension(Either<A, B> $this, Function1<A, BB> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return f.apply(a);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return (BB)b;
        }
        throw new MatchError(either);
    }

    public final <A, B> boolean forall$extension(Either<A, B> $this, Function1<B, Object> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return true;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return BoxesRunTime.unboxToBoolean(f.apply(b));
        }
        throw new MatchError(either);
    }

    public final <A, B> boolean exists$extension(Either<A, B> $this, Function1<B, Object> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return false;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return BoxesRunTime.unboxToBoolean(f.apply(b));
        }
        throw new MatchError(either);
    }

    public final <AA, A, B> Either<AA, B> ensure$extension(Either<A, B> $this, Function0<AA> onFailure, Function1<B, Object> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return $this;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            if (BoxesRunTime.unboxToBoolean(f.apply(b))) {
                return $this;
            }
            return package$.MODULE$.Left().apply(onFailure.apply());
        }
        throw new MatchError(either);
    }

    public final <AA, A, B> Either<AA, B> ensureOr$extension(Either<A, B> $this, Function1<B, AA> onFailure, Function1<B, Object> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return $this;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            if (BoxesRunTime.unboxToBoolean(f.apply(b))) {
                return $this;
            }
            return package$.MODULE$.Left().apply(onFailure.apply(b));
        }
        throw new MatchError(either);
    }

    public final <A, B> Ior<A, B> toIor$extension(Either<A, B> $this) {
        return Ior$.MODULE$.fromEither($this);
    }

    public final <A, B> Option<B> toOption$extension(Either<A, B> $this) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return new Some(b);
        }
        throw new MatchError(either);
    }

    public final <A, B> List<B> toList$extension(Either<A, B> $this) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return Nil$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{b}));
        }
        throw new MatchError(either);
    }

    public final <A, B> Try<B> toTry$extension(Either<A, B> $this, $less$colon$less<A, Throwable> ev) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return new Failure(ev.apply((A)a));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return new Success(b);
        }
        throw new MatchError(either);
    }

    public final <A, B> Validated<A, B> toValidated$extension(Either<A, B> $this) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return Validated$.MODULE$.invalid(a);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return Validated$.MODULE$.valid(b);
        }
        throw new MatchError(either);
    }

    public final <AA, A, B> Validated<NonEmptyList<AA>, B> toValidatedNel$extension(Either<A, B> $this) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return Validated$.MODULE$.invalidNel(a);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return Validated$.MODULE$.valid(b);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> Either<AA, BB> withValidated$extension(Either<A, B> $this, Function1<Validated<A, B>, Validated<AA, BB>> f) {
        return f.apply(this.toValidated$extension($this)).toEither();
    }

    public final <F, A, B> F to$extension(Either<A, B> $this, Alternative<F> F) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return F.empty();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return F.pure(b);
        }
        throw new MatchError(either);
    }

    public final <C, D, A, B> Either<C, D> bimap$extension(Either<A, B> $this, Function1<A, C> fa, Function1<B, D> fb) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return package$.MODULE$.Left().apply(fa.apply(a));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return package$.MODULE$.Right().apply(fb.apply(b));
        }
        throw new MatchError(either);
    }

    public final <C, A, B> Either<A, C> map$extension(Either<A, B> $this, Function1<B, C> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            return EitherUtil$.MODULE$.rightCast(left);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return package$.MODULE$.Right().apply(f.apply(b));
        }
        throw new MatchError(either);
    }

    public final <AA, C, Z, A, B> Eval<Either<AA, Z>> map2Eval$extension(Either<A, B> $this, Eval<Either<AA, C>> fc, Function2<B, C, Z> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            return new Now<Either<AA, Z>>(EitherUtil$.MODULE$.rightCast(left));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return fc.map((Function1<Either, Either> & Serializable)x$1 -> x$1.map((Function1<Object, Object> & Serializable)x$2 -> f.apply(b, x$2)));
        }
        throw new MatchError(either);
    }

    public final <C, A, B> Either<C, B> leftMap$extension(Either<A, B> $this, Function1<A, C> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return package$.MODULE$.Left().apply(f.apply(a));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            return EitherUtil$.MODULE$.leftCast(right);
        }
        throw new MatchError(either);
    }

    public final <AA, D, A, B> Either<AA, D> flatMap$extension(Either<A, B> $this, Function1<B, Either<AA, D>> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            return EitherUtil$.MODULE$.rightCast(left);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return f.apply(b);
        }
        throw new MatchError(either);
    }

    public final <C, BB, A, B> Either<C, BB> leftFlatMap$extension(Either<A, B> $this, Function1<A, Either<C, BB>> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return f.apply(a);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            return EitherUtil$.MODULE$.leftCast(right);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> int compare$extension(Either<A, B> $this, Either<AA, BB> that, Order<AA> AA, Order<BB> BB) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                return AA.compare(a1, a2);
            }
            if (either2 instanceof Right) {
                return -1;
            }
            throw new MatchError(either2);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                return 1;
            }
            if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                return BB.compare(b1, b2);
            }
            throw new MatchError(either3);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> double partialCompare$extension(Either<A, B> $this, Either<AA, BB> that, PartialOrder<AA> AA, PartialOrder<BB> BB) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                return AA.partialCompare(a1, a2);
            }
            if (either2 instanceof Right) {
                return -1.0;
            }
            throw new MatchError(either2);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                return 1.0;
            }
            if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                return BB.partialCompare(b1, b2);
            }
            throw new MatchError(either3);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> boolean $eq$eq$eq$extension(Either<A, B> $this, Either<AA, BB> that, Eq<AA> AA, Eq<BB> BB) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                return AA.eqv(a1, a2);
            }
            if (either2 instanceof Right) {
                return false;
            }
            throw new MatchError(either2);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                return false;
            }
            if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                return BB.eqv(b1, b2);
            }
            throw new MatchError(either3);
        }
        throw new MatchError(either);
    }

    public final <F, AA, D, A, B> F traverse$extension(Either<A, B> $this, Function1<B, F> f, Applicative<F> F) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            return F.pure(EitherUtil$.MODULE$.rightCast(left));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return F.map(f.apply(b), (Function1<Object, Right> & Serializable)x$3 -> package$.MODULE$.Right().apply(x$3));
        }
        throw new MatchError(either);
    }

    public final <C, A, B> C foldLeft$extension(Either<A, B> $this, C c, Function2<C, B, C> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return c;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return f.apply(c, b);
        }
        throw new MatchError(either);
    }

    public final <C, A, B> Eval<C> foldRight$extension(Either<A, B> $this, Eval<C> lc, Function2<B, Eval<C>, Eval<C>> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            return lc;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return f.apply(b, lc);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> Either<AA, BB> combine$extension(Either<A, B> $this, Either<AA, BB> that, Semigroup<BB> BB) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            return left;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                return left;
            }
            if (either2 instanceof Right) {
                Right right2 = (Right)either2;
                Object b2 = right2.value();
                return package$.MODULE$.Right().apply(BB.combine(b1, b2));
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    public final <AA, BB, A, B> String show$extension(Either<A, B> $this, Show<AA> AA, Show<BB> BB) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            return new StringBuilder(6).append("Left(").append(AA.show(a)).append(")").toString();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            return new StringBuilder(7).append("Right(").append(BB.show(b)).append(")").toString();
        }
        throw new MatchError(either);
    }

    public final <AA, BB, C, A, B> Either<AA, C> ap$extension(Either<A, B> $this, Either<AA, Function1<BB, C>> that) {
        return that.flatMap((Function1<Function1, Either> & Serializable)f -> $this.map(f));
    }

    public final <F, A, B> EitherT<F, A, B> toEitherT$extension(Either<A, B> $this, Applicative<F> evidence$1) {
        return EitherT$FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), $this, evidence$1);
    }

    public final <AA, A, B> Either<Object, B> toEitherNec$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1<Object, Object> & Serializable)a -> cats.data.package$.MODULE$.NonEmptyChain().one(a));
    }

    public final <AA, A, B> Either<Object, B> toEitherNes$extension(Either<A, B> $this, Order<AA> O2) {
        return this.leftMap$extension($this, (Function1<Object, Object> & Serializable)x$4 -> cats.data.package$.MODULE$.NonEmptySet().one(x$4, O2));
    }

    public final <AA, A, B> Either<NonEmptyList<AA>, B> toEitherNel$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1<Object, NonEmptyList> & Serializable)head -> NonEmptyList$.MODULE$.one(head));
    }

    public final <F, A, B> F raiseOrPure$extension(Either<A, B> $this, ApplicativeError<F, A> ev) {
        return ev.fromEither($this);
    }

    public final <F, A, B> F liftTo$extension(Either<A, B> $this, ApplicativeError<F, ? super A> F) {
        return F.fromEither($this);
    }

    public final <A, B> int hashCode$extension(Either<A, B> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A, B> boolean equals$extension(Either<A, B> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof EitherOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        Either either = x$1 == null ? null : ((EitherOps)x$1).cats$syntax$EitherOps$$eab();
        Either<A, B> either2 = $this;
        Either either3 = either;
        if (either2 != null) {
            if (!either2.equals(either3)) return false;
            return true;
        }
        if (either3 == null) return true;
        return false;
    }

    private EitherOps$() {
    }
}

