/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleSQLOutput
implements SQLOutput {
    private StructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private OracleConnection conn;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:39:33_PST_2008";

    public OracleSQLOutput(StructDescriptor structDescriptor, OracleConnection oracleConnection) throws SQLException {
        this.descriptor = structDescriptor;
        this.attributes = new Object[structDescriptor.getLength()];
        this.conn = oracleConnection;
        this.index = 0;
    }

    public STRUCT getSTRUCT() throws SQLException {
        return new STRUCT(this.descriptor, (Connection)this.conn, this.attributes);
    }

    public void writeString(String string) throws SQLException {
        this.attributes[this.index++] = string;
    }

    public void writeBoolean(boolean bl) throws SQLException {
        this.attributes[this.index++] = new Boolean(bl);
    }

    public void writeByte(byte by) throws SQLException {
        this.attributes[this.index++] = new Integer(by);
    }

    public void writeShort(short s) throws SQLException {
        this.attributes[this.index++] = new Integer(s);
    }

    public void writeInt(int n) throws SQLException {
        this.attributes[this.index++] = new Integer(n);
    }

    public void writeLong(long l) throws SQLException {
        this.attributes[this.index++] = new Long(l);
    }

    public void writeFloat(float f) throws SQLException {
        this.attributes[this.index++] = new Float(f);
    }

    public void writeDouble(double d) throws SQLException {
        this.attributes[this.index++] = new Double(d);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attributes[this.index++] = bigDecimal;
    }

    public void writeBytes(byte[] byArray) throws SQLException {
        this.attributes[this.index++] = byArray;
    }

    public void writeDate(Date date) throws SQLException {
        this.attributes[this.index++] = date;
    }

    public void writeTime(Time time) throws SQLException {
        this.attributes[this.index++] = time;
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attributes[this.index++] = timestamp;
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[100];
        int n = 0;
        try {
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        String string = stringBuffer.substring(0, stringBuffer.length());
        this.attributes[this.index++] = string;
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[100];
        char[] cArray = new char[100];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = (char)byArray[i];
                }
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        String string = stringBuffer.substring(0, stringBuffer.length());
        this.attributes[this.index++] = string;
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        this.writeAsciiStream(inputStream);
    }

    public void writeObject(SQLData sQLData) throws SQLException {
        STRUCT sTRUCT = null;
        if (sQLData != null) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)this.conn);
            SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
            sQLData.writeSQL(sQLOutput);
            sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
        }
        this.writeStruct(sTRUCT);
    }

    public void writeObject(Object object) throws SQLException {
        if (object != null && object instanceof SQLData) {
            this.writeObject((SQLData)object);
        } else {
            this.attributes[this.index++] = object;
        }
    }

    public void writeRef(Ref ref) throws SQLException {
        this.attributes[this.index++] = ref;
    }

    public void writeBlob(Blob blob) throws SQLException {
        this.attributes[this.index++] = blob;
    }

    public void writeClob(Clob clob) throws SQLException {
        this.attributes[this.index++] = clob;
    }

    public void writeStruct(Struct struct2) throws SQLException {
        this.attributes[this.index++] = struct2;
    }

    public void writeArray(Array array) throws SQLException {
        this.attributes[this.index++] = array;
    }

    public void writeOracleObject(Datum datum) throws SQLException {
        this.attributes[this.index++] = datum;
    }

    public void writeRef(REF rEF) throws SQLException {
        this.attributes[this.index++] = rEF;
    }

    public void writeBlob(BLOB bLOB) throws SQLException {
        this.attributes[this.index++] = bLOB;
    }

    public void writeBfile(BFILE bFILE) throws SQLException {
        this.attributes[this.index++] = bFILE;
    }

    public void writeClob(CLOB cLOB) throws SQLException {
        this.attributes[this.index++] = cLOB;
    }

    public void writeStruct(STRUCT sTRUCT) throws SQLException {
        this.attributes[this.index++] = sTRUCT;
    }

    public void writeArray(ARRAY aRRAY) throws SQLException {
        this.attributes[this.index++] = aRRAY;
    }

    public void writeNUMBER(NUMBER nUMBER) throws SQLException {
        this.attributes[this.index++] = nUMBER;
    }

    public void writeCHAR(CHAR cHAR) throws SQLException {
        this.attributes[this.index++] = cHAR;
    }

    public void writeDATE(DATE dATE) throws SQLException {
        this.attributes[this.index++] = dATE;
    }

    public void writeRAW(RAW rAW) throws SQLException {
        this.attributes[this.index++] = rAW;
    }

    public void writeROWID(ROWID rOWID) throws SQLException {
        this.attributes[this.index++] = rOWID;
    }

    public void writeURL(URL uRL) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }
}

