from javawrap import Color, GridBagConstraints, Font
import MainHandle
import MajorObjects
import PlateSet
import datetime
import java.awt.Dimension as Dimension
import java.awt.GridBagLayout as GridBagLayout
import java.awt.Insets as Insets
import java.text.NumberFormat as NumberFormat
import javax.swing as swing
import javax.swing.BorderFactory as BorderFactory
import javax.swing.Box as Box
import javax.swing.BoxLayout as BoxLayout
import javax.swing.JFormattedTextField as JFormattedTextField
import javax.swing.JLabel as JLabel
import javax.swing.JPanel as JPanel
import javax.swing.JTextField as JTextField
import javax.swing.border.LineBorder as LineBorder
import stats.stats as stats

masterObject = MainHandle.masterObject

# standard borders for components:
emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1)
etchedBorder = BorderFactory.createEtchedBorder(swing.border.EtchedBorder.LOWERED)
loweredEtched = BorderFactory.createCompoundBorder(emptyBorder, etchedBorder)
RADIO_BOX_BG = Color.newColor(250, 250, 250)

# creat the top-level Plate Scoring tab in the main window
def createNormalizationPanel(debug=0):
	# set the default directory:
	masterObject.setField('fileDirectory', None)

	# build the file filter. Only display files of the type .tab and .txt
	fileFilter = MajorObjects.OutputFileFilter()
	fileFilter.addExtension('.tab')
	fileFilter.addExtension('.txt')
	masterObject.setField('fileFilter', fileFilter)

	# build the gct/chip file filter. Only display files of the type .gct and .chip
	gctFilter = MajorObjects.OutputFileFilter()
	gctFilter.addExtension('.gct')
	gctFilter.addExtension('.chip')
	masterObject.setField('gctFilter', gctFilter)

	# create main frame:
	NPanel = MajorObjects.NewPanel()
	NPanel.setLayout(GridBagLayout())
	masterObject.setField('NormalizationPanel', NPanel)

	### TOP ROW: Plate subset selection and Plate list:
	plateSetPanel = JPanel(GridBagLayout())
	plateSetPanel.setBorder(loweredEtched)

	# Subset selection box:
	(subsetBox, compList) = makeSubsetBox()
	MainHandle.addToMasterObject(compList)
	
	# plate set panel constraints
	psConstraints = MajorObjects.DefaultGridbagConstraints()
	psConstraints.gridx = 0
	psConstraints.gridy = 0
	psConstraints.anchor = GridBagConstraints.WEST
	psConstraints.weightx = 0.05
	psConstraints.fillx = GridBagConstraints.NONE
	unitConstraints = MajorObjects.DefaultGridbagConstraints()
	unitConstraints.gridx = 0
	unitConstraints.gridy = 0
	unitConstraints.fill = GridBagConstraints.HORIZONTAL
	subBox = JPanel(GridBagLayout())
	subBox.add(subsetBox, unitConstraints)
	plateSetPanel.add(subBox, psConstraints)

	# JTable for multiple parameters:
	(parameterTable, compList) = makeFeatureTable()
	MainHandle.addToMasterObject(compList)
	ptConstraints = MajorObjects.DefaultGridbagConstraints()
	ptConstraints.gridx = 0
	ptConstraints.gridy = 1
	ptConstraints.anchor = GridBagConstraints.WEST
	ptConstraints.weightx = 0.05
	ptConstraints.fillx = GridBagConstraints.HORIZONTAL
	plateSetPanel.add(parameterTable, ptConstraints)

	# Plate list Jtable:
	(plateListTable, compList) = makePlateListTable()
	MainHandle.addToMasterObject(compList)
	plConstraints = MajorObjects.DefaultGridbagConstraints()
	plConstraints.anchor = GridBagConstraints.EAST
	plConstraints.gridx = GridBagConstraints.RELATIVE
	plConstraints.gridy = 0
	plConstraints.gridheight = 2
	plConstraints.weightx = 0.95
	plConstraints.fillx = GridBagConstraints.BOTH
	plateSetPanel.add(plateListTable, plConstraints)

	masterObject.setField('plateListTable', plateListTable)

	### MIDDLE ROW: Plate visualization and scoring method selection:
	(plateVisPanel, compList) = makePlateVisPanel()    # plate visualization panel
	plateVisPanel.setBorder(loweredEtched)
	MainHandle.addToMasterObject(compList)

	### BOTTOM ROW: save analysis results panels:
	(saveResultsPane, compList) = makeSaveResultsPane()
	saveResultsPane.setBackground(Color.newColor(200, 255, 200))
	MainHandle.addToMasterObject(compList)

	# set up GridBagConstraints for adding components to the main panel:
	topConstraints = MajorObjects.DefaultGridbagConstraints()
	midConstraints = MajorObjects.DefaultGridbagConstraints()
	botConstraints = MajorObjects.DefaultGridbagConstraints()

	topConstraints.fill = GridBagConstraints.BOTH
	topConstraints.gridx = 0
	topConstraints.gridheight = 2
	topConstraints.weightx = 1.0
	topConstraints.weighty = 4.0
	topConstraints.anchor = GridBagConstraints.SOUTH

	# add the plateSet panel to the top of the main panel:
	NPanel.add(plateSetPanel, topConstraints)				   # TOP ROW
	masterObject.setField('plateSetPanel', plateSetPanel)

	midConstraints.gridx = 0
	midConstraints.gridy = GridBagConstraints.RELATIVE
	midConstraints.weightx = 1.0
	midConstraints.weighty = 1.0
	midConstraints.fill = GridBagConstraints.HORIZONTAL
	midConstraints.anchor = GridBagConstraints.EAST

	# add the plate visualization panel to the middle of the main panel:
	NPanel.add(plateVisPanel, midConstraints)				   # MIDDLE ROW
	masterObject.setField('plateVisPanel', plateVisPanel)

	botConstraints.gridx = 0
	botConstraints.gridy = GridBagConstraints.RELATIVE
	botConstraints.weightx = 1.0
	botConstraints.weighty = 1.0
	botConstraints.anchor = GridBagConstraints.CENTER
	botConstraints.fill = GridBagConstraints.BOTH

	# add the saveResultsPanel to the bottom row:
	NPanel.add(saveResultsPane, botConstraints)				 # BOTTOM ROW
	masterObject.setField('saveResultsPane', saveResultsPane)

	# adjust the top row preferred size to be anything not used by the other two rows:
	fullPrefSize = NPanel.getPreferredSize()
	fHeight = fullPrefSize.getHeight()
	midPrefSize = plateVisPanel.getPreferredSize()
	mHeight = midPrefSize.getHeight()
	bottomPrefSize = saveResultsPane.getPreferredSize()
	bHeight = bottomPrefSize.getHeight()

	# use the middle row width for the preferred width
	prefWidth = midPrefSize.getWidth()
	prefHeight = fHeight - (mHeight + bHeight)

	plateSetPanel.setPreferredSize(Dimension(int(prefWidth), int(prefHeight)))

	g = NPanel.getGraphics()
	NPanel.paint(g)
	return NPanel

#### SAVE ANALYSIS RESULTS Panel
def makeSaveResultsPane():
	# top-level pane:
	saveResultsPanel = JPanel(GridBagLayout())
	topBorder = BorderFactory.createTitledBorder('Save Analysis Results')
	saveResultsPanel.setBorder(topBorder)

	# Well-level output panel
	wellLevelPanel = makeWellLevelPanel()
	wConstraint = GridBagConstraints.newGridBagConstraints()
	wConstraint.fill = GridBagConstraints.BOTH
	wConstraint.anchor = GridBagConstraints.NORTH
	wConstraint.gridx = 0
	wConstraint.gridy = 0
	wConstraint.weightx = 1.0
	saveResultsPanel.add(wellLevelPanel, wConstraint)

	# Grouping selection panel
	groupingPanel = makeGroupingPanel()
	gConstraint = GridBagConstraints.newGridBagConstraints()
	gConstraint.fill = GridBagConstraints.BOTH
	gConstraint.anchor = GridBagConstraints.NORTH
	gConstraint.gridy = 0
	gConstraint.weightx = 1.0
	gConstraint.gridx = GridBagConstraints.RELATIVE
	saveResultsPanel.add(groupingPanel, gConstraint)

	# Hairpin-level output panel
	hairpinLevelPanel = makeHairpinLevelPanel()
	hConstraint = GridBagConstraints.newGridBagConstraints()
	hConstraint.fill = GridBagConstraints.BOTH
	hConstraint.anchor = GridBagConstraints.NORTH
	hConstraint.gridy = 0
	hConstraint.weightx = 1.0
	hConstraint.gridx = GridBagConstraints.RELATIVE
	saveResultsPanel.add(hairpinLevelPanel, hConstraint)

	return (saveResultsPanel, [['saveResultsPanel', saveResultsPanel]])

# construct the "Well-level output" panel
def makeWellLevelPanel():
	# make well-level panel:
	wellSavePanel = JPanel(GridBagLayout())
	wsBorder = BorderFactory.createTitledBorder('Well-level output')
	wellSavePanel.setBorder(wsBorder)
	wellSavePanel.setBackground(Color.newColor(190, 255, 160))

	# make the save well-level analysis button:
	(saveWellButtonPane, compList) = makeSaveWellButton()
	MainHandle.addToMasterObject(compList)
	wConstraint = GridBagConstraints.newGridBagConstraints()
	wConstraint.fill = GridBagConstraints.NONE
	wConstraint.anchor = GridBagConstraints.NORTH
	wConstraint.gridx = 0
	wConstraint.gridy = 0
	wConstraint.weighty = 1.0
	wConstraint.insets = Insets(5, 0, 0, 0)

	wellSavePanel.add(saveWellButtonPane, wConstraint)
	return wellSavePanel

# construct the "Grouping selection" panel
def makeGroupingPanel():
	groupingPanel = JPanel(GridBagLayout())
	gpBorder = BorderFactory.createTitledBorder('Grouping selection')
	groupingPanel.setBorder(gpBorder)
	groupingPanel.setBackground(Color.newColor(150, 255, 210))

	# make selection grouping button group:
	(hpSelGroupingBox, compList) = makeHpSelectionGroupingBox()
	MainHandle.addToMasterObject(compList)
	hConstraint = GridBagConstraints.newGridBagConstraints()
	hConstraint.fill = GridBagConstraints.HORIZONTAL
	hConstraint.gridx = 0
	hConstraint.gridy = 2
	hConstraint.weightx = 1.0
	hConstraint.insets = Insets(10, 10, 5, 10)
	groupingPanel.add(hpSelGroupingBox, hConstraint)

	(hpBatchGroupingBox, compList) = makeHpBatchGroupingBox()
	MainHandle.addToMasterObject(compList)
	hConstraint.fill = GridBagConstraints.HORIZONTAL
	hConstraint.gridx = 0
	hConstraint.gridy = 3
	hConstraint.weightx = 1.0
	hConstraint.insets = Insets(10, 10, 5, 10)
	groupingPanel.add(hpBatchGroupingBox, hConstraint)

	return groupingPanel

# construct the "Hairpin-level output" panel
def makeHairpinLevelPanel():
	# make hairpin-level panel:
	hpSavePanel = JPanel(GridBagLayout())
	hpBorder = BorderFactory.createTitledBorder('Hairpin-level output')
	hpSavePanel.setBorder(hpBorder)
	hpSavePanel.setBackground(Color.newColor(150, 255, 210))

	# make the save hairpin-level analysis button:
	(saveHpButtonPane, compList) = makeSaveHpButton()
	MainHandle.addToMasterObject(compList)
	hConstraint = GridBagConstraints.newGridBagConstraints()
	hConstraint.anchor = GridBagConstraints.NORTH

	hConstraint.gridx = 0
	hConstraint.gridy = 0
	hConstraint.weighty = 1.0
	hConstraint.insets = Insets(5, 0, 0, 0)
	hpSavePanel.add(saveHpButtonPane, hConstraint)

	# make the save RIGER input file button:
	(saveRigerButtonPane, compList) = makeSaveRigerButton()
	MainHandle.addToMasterObject(compList)
	hConstraint = GridBagConstraints.newGridBagConstraints()
	hConstraint.anchor = GridBagConstraints.NORTH
	hConstraint.gridx = 0
	hConstraint.gridy = 1
	hConstraint.weighty = 1.0
	hConstraint.insets = Insets(5, 0, 0, 0)
	hpSavePanel.add(saveRigerButtonPane, hConstraint)

	return hpSavePanel

# Note: This functionality has been moved to the Data Analysis tab
def makeGeneLevelPanel():
	# make gene-level panel:
	geneSavePanel = JPanel(GridBagLayout())
	geneBorder = BorderFactory.createTitledBorder('Gene-level')
	geneSavePanel.setBorder(geneBorder)

	# make the save gene-level analysis button:
	buttonHolder = JPanel()
	(computeGeneButtonPane, compList) = makeComputeGeneButton()
	MainHandle.addToMasterObject(compList)
	buttonHolder.add(computeGeneButtonPane)

	(saveGeneButtonPane, compList) = makeSaveGeneButton()
	MainHandle.addToMasterObject(compList)
	buttonHolder.add(saveGeneButtonPane)

	gConstraint = GridBagConstraints.newGridBagConstraints()
	# 	bConstraint.fill= GridBagConstraints.BOTH
	# 	gConstraint.anchor=GridBagConstraints.EAST
	gConstraint.gridy = 0
	gConstraint.gridx = 0
	# 	geneSavePanel.add(computeGeneButtonPane, gConstraint)
	# 	gConstraint.anchor=GridBagConstraints.WEST
	# 	gConstraint.gridx=1
	# 	geneSavePanel.add(saveGeneButtonPane, gConstraint)
	geneSavePanel.add(buttonHolder, gConstraint)

	# make batch grouping button group:
	#(geneBatchGroupingBox, compList) = makeGeneBatchGroupingBox()
	#MainHandle.addToMasterObject(compList)
	#gConstraint.fill= GridBagConstraints.HORIZONTAL
	#gConstraint.gridx=0
	#gConstraint.gridy=1
	#gConstraint.weightx=1.0
	#gConstraint.weighty=1.0
	#gConstraint.insets = Insets(5,30,0,30)
	#geneSavePanel.add(geneBatchGroupingBox, gConstraint)

	# make intensity/confidence box:
	(geneScoreParamBox, compList) = makeGeneScoreParamBox()
	MainHandle.addToMasterObject(compList)
	gConstraint.fill = GridBagConstraints.HORIZONTAL
	gConstraint.gridx = 0
	gConstraint.gridy = 2
	gConstraint.insets = Insets(0, 30, 0, 30)
	geneSavePanel.add(geneScoreParamBox, gConstraint)

	return geneSavePanel

# Note: This functionality has been moved to the Data Analysis tab
def makeGeneScoreParamBox():
	scoreParamPanel = JPanel(GridBagLayout())
	scoreParamBorder = BorderFactory.createTitledBorder('Gene score params')
	scoreParamPanel.setBorder(scoreParamBorder)

	#C1_WIDTH = 50
	nDigitCol = 6
	limitColor = Color.newColor(250, 250, 250)

	#font = Font('Ariel', Font.PLAIN, 12)
	ifont = Font.Ariel12PlainItalic
	bfont = Font.Ariel12Bold
	ibfont = Font.Ariel12BoldItalic

	# component constraints:
	sConstraint = GridBagConstraints.newGridBagConstraints()
	sConstraint.fill = GridBagConstraints.HORIZONTAL
	#sConstraint.weightx=0.3

	# formats:
	rangeNumberFormat = NumberFormat.getNumberInstance()
	rangeNumberFormat.setMaximumFractionDigits(2)
	rangeNumberFormat.setMaximumIntegerDigits(6)
	inputNumberFormat = NumberFormat.getNumberInstance()
	inputNumberFormat.setMaximumFractionDigits(4)
	inputNumberFormat.setMaximumIntegerDigits(6)

	# fill the containers:

	# column headers:
	sConstraint.gridy = 0
	sConstraint.gridx = 1
	minHeader = JLabel('min', JLabel.CENTER)
	minHeader.setFont(ibfont)
	scoreParamPanel.add(minHeader, sConstraint)

	sConstraint.gridx = 2
	maxHeader = JLabel('max', JLabel.CENTER)
	maxHeader.setFont(ibfont)
	scoreParamPanel.add(maxHeader, sConstraint)

	# Intensity range row:
	sConstraint.gridy = 1
	sConstraint.gridx = 1
	intensityMin = JFormattedTextField(rangeNumberFormat)
	intensityMin.setHorizontalAlignment(JTextField.CENTER)
	intensityMin.setColumns(nDigitCol)
	intensityMin.setFont(ifont)
	intensityMin.setBackground(limitColor)
	intensityMin.setBorder(LineBorder(limitColor, 1))
	intensityMin.setEnabled(0)
	intensityMin.setDisabledTextColor(Color.BLACK)
	scoreParamPanel.add(intensityMin, sConstraint)

	sConstraint.gridx = 2
	intensityMax = JFormattedTextField(rangeNumberFormat)
	intensityMax.setHorizontalAlignment(JTextField.CENTER)
	intensityMax.setColumns(nDigitCol)
	intensityMax.setFont(ifont)
	intensityMax.setBackground(limitColor)
	intensityMax.setBorder(LineBorder(limitColor, 1))
	intensityMax.setEnabled(0)
	intensityMax.setDisabledTextColor(Color.BLACK)
	scoreParamPanel.add(intensityMax, sConstraint)

	# Intensity threshold row:
	sConstraint.gridy = 2
	sConstraint.gridx = 0
	intensityThr = JLabel('Score thresholds: ', JLabel.RIGHT)
	intensityThr.setFont(ibfont)
	scoreParamPanel.add(intensityThr, sConstraint)

	sConstraint.gridx = 1
	intensityThrMin = JFormattedTextField(inputNumberFormat)
	intensityThrMin.setHorizontalAlignment(JTextField.CENTER)
	intensityThrMin.setFont(bfont)
	scoreParamPanel.add(intensityThrMin, sConstraint)

	sConstraint.gridx = 2
	intensityThrMax = JFormattedTextField(inputNumberFormat)
	intensityThrMax.setHorizontalAlignment(JTextField.CENTER)
	intensityThrMax.setFont(bfont)
	scoreParamPanel.add(intensityThrMax, sConstraint)

	# spacer row:
	sConstraint.gridy = 3
	spacer = Box.createRigidArea(Dimension(0, 4))
	scoreParamPanel.add(spacer, sConstraint)

	# Confidence range row:
	sConstraint.gridy = 4
	sConstraint.gridx = 1
	confidenceMin = JFormattedTextField(rangeNumberFormat)
	confidenceMin.setHorizontalAlignment(JTextField.CENTER)
	confidenceMin.setFont(ifont)
	confidenceMin.setBackground(limitColor)
	confidenceMin.setBorder(LineBorder(limitColor, 1))
	confidenceMin.setEnabled(0)
	confidenceMin.setDisabledTextColor(Color.BLACK)
	scoreParamPanel.add(confidenceMin, sConstraint)

	sConstraint.gridx = 2
	confidenceMax = JFormattedTextField(rangeNumberFormat)
	confidenceMax.setHorizontalAlignment(JTextField.CENTER)
	confidenceMax.setFont(ifont)
	confidenceMax.setBackground(limitColor)
	confidenceMax.setBorder(LineBorder(limitColor, 1))
	confidenceMax.setEnabled(0)
	confidenceMax.setDisabledTextColor(Color.BLACK)
	scoreParamPanel.add(confidenceMax, sConstraint)

	# Confidence threshold row:
	sConstraint.gridy = 5
	sConstraint.gridx = 0
	confidenceThr = JLabel('Std dev threshold: ', JLabel.RIGHT)
	confidenceThr.setFont(ibfont)
	scoreParamPanel.add(confidenceThr, sConstraint)

	sConstraint.gridx = 1
	sConstraint.gridwidth = 2
	confidenceThrMin = JFormattedTextField(inputNumberFormat)
	confidenceThrMin.setHorizontalAlignment(JTextField.CENTER)
	confidenceThrMin.setFont(bfont)
	scoreParamPanel.add(confidenceThrMin, sConstraint)

	return (scoreParamPanel, [['scoreParamPanel', scoreParamPanel],
							  ['intensityMin', intensityMin],
							  ['intensityMax', intensityMax],
							  ['intensityThrMin', intensityThrMin],
							  ['intensityThrMax', intensityThrMax],
							  ['confidenceMin', confidenceMin],
							  ['confidenceMax', confidenceMax],
							  ['confidenceThr', confidenceThrMin]])

# Selection (puro) grouping sub-panel
def makeHpSelectionGroupingBox():
	buttonList = ['combine puro+/puro-', 'separate puro+/puro-']
	hpSelGroupingBox = MajorObjects.RadioButtonUtils()
	hpSelGroupingBox.createRadioButtonGrouping(buttonList, 'Selection (puro) grouping',
										MajorObjects.CustomActionListener(hpSelectionGroupingActionListener),
										defaultSelect=1)
	hpSelGroupingBox.setButtonBgColor(RADIO_BOX_BG)

	masterObject.setField('hpSelectionGrouping', 'separate puro+/puro-')

	return (hpSelGroupingBox.panel, [['hpSelGroupingBox', hpSelGroupingBox],
							  ['hpSelGroupingPanel', hpSelGroupingBox.panel]])

# Batch grouping sub-panel
def makeHpBatchGroupingBox():
	buttonList = ['combine batches', 'keep separate']
	hpBatchGroupingBox = MajorObjects.RadioButtonUtils()
	hpBatchGroupingBox.createRadioButtonGrouping(buttonList, 'Batch grouping',
										MajorObjects.CustomActionListener(hpBatchGroupingActionListener),
										defaultSelect=1)
	hpBatchGroupingBox.setButtonBgColor(RADIO_BOX_BG)

	masterObject.setField('hpBatchGrouping', 'keep separate')

	return (hpBatchGroupingBox.panel, [['hpBatchGroupingBox', hpBatchGroupingBox],
							  ['hpBatchGroupingPanel', hpBatchGroupingBox.panel]])

# construct the Assay Features table
def makeFeatureTable():
	pPane = MajorObjects.NormTablePane(0)
	pPane.setColumnNames(['Assay Features'])
	pPane.addListSelectionListener(MajorObjects.TableListSelectionListener(pPane.table, featureSelectUpdate))
	pPane.setBorder(loweredEtched)
	pPane.setColumnHorizontalAlignment(JLabel.LEFT)
	pPane.setHeaderFont(Font.Helvetica12Bold)

	return (pPane, [['parameterPane', pPane]])

# Assay feature selection action listener
def featureSelectUpdate(evt, table):
	# if the value is still being adjusted, ignore the event
	if evt != None and evt.getValueIsAdjusting():
		return

	# otherwise, get the selected row in the table
	rowIdx = table.getSelectedRow()
	pPane = masterObject.getField('parameterPane')
	feature = pPane.getRowKey(rowIdx)  # get the selected feature name
	analysisSet = masterObject.getField('analysisPlateset')
	plateIdList = analysisSet.getPlateIdList() # get th eplate ID list
	# for each plate in the plate list, set the 'selected feature' to hte feature that
	# was selected, if there is a feature by that name in the features for that plate.
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		readIdList = plate.get_readIdList()
		for readId in readIdList:
			plate.setSelectedFeature(readId, feature)

	# reprocess the plates:
	pPane.setTableSelectionBackground(Color.RED)
	processAnalysisPlateset()
	pPane.setTableSelectionBackground()

# AD: this doesn't appear to be used
def featureSelectUpdateByKey(evt, table):
	pString = evt.paramString()
	pFields = pString.split(',')

# Construct the Plate subset selection sub-panel
def makeSubsetBox():
	#font = Font('Ariel', Font.BOLD, 12)
	#ifont = Font('Ariel', Font.BOLD+Font.ITALIC, 12)

	buttonList = ['only selection +', 'only selection -', 'all plates']
	subsetBox = MajorObjects.RadioButtonUtils()
	subsetBox.createRadioButtonGrouping(buttonList, 'Plate subset selection',
										MajorObjects.CustomActionListener(subsetActionListener),
										defaultSelect=2)

	masterObject.setField('plateSubset', None)

	return (subsetBox.panel, [['subsetBox', subsetBox],
							  ['subsetPanel', subsetBox.panel]])

# construct the Normalization method sub-panel (three button groups)
def makeMethodSelectBox():
	# panel for three button groups:
	scorePanel = JPanel()
	scorePanel.setLayout(BoxLayout(scorePanel, BoxLayout.Y_AXIS))

	# scoring method:
	buttonList = ['Infection efficiency', 'b-score', 'z-score', 'robust z-score', 'PoC', 'raw score']
	scoreSelectBox = MajorObjects.RadioButtonUtils()
	scoreSelectBox.createRadioButtonGrouping(buttonList, 'Normalization method',
											MajorObjects.CustomActionListener(scoreMethodActionListener),
											defaultSelect=2)

	scoreSelectBox.setButtonBgColor(RADIO_BOX_BG)
	masterObject.setField('scoreMethod', 'z-score')

	# scoring granularity:
	buttonList = ['plate', 'quadrant']
	quadSelectBox = MajorObjects.RadioButtonUtils()
	quadSelectBox.createRadioButtonGrouping(buttonList, 'Granularity',
											MajorObjects.CustomActionListener(granularityActionListener),
											defaultSelect=0, nCol=2)

	quadSelectBox.setButtonBgColor(RADIO_BOX_BG)
	masterObject.setField('quad', 'plate')

	# control wells:
	buttonList = ['treat as hairpins', 'use only for normalization', 'remove from analysis']
	controlSelectBox = MajorObjects.RadioButtonUtils()
	controlSelectBox.createRadioButtonGrouping(buttonList, 'Use of Control wells',
											MajorObjects.CustomActionListener(controlWellActionListener),
											defaultSelect=0)

	controlSelectBox.setButtonBgColor(RADIO_BOX_BG)
	masterObject.setField('controlWells', 'treat as hairpins')
	masterObject.setField('controlSelectBox', controlSelectBox)

	# add the two buttongroups to the panel:
	scorePanel.add(scoreSelectBox.panel)
	scorePanel.add(quadSelectBox.panel)
	scorePanel.add(controlSelectBox.panel)

	return (scorePanel, [['scoreSelectPanel', scoreSelectBox.panel],
						 ['scoreSelectBox', scoreSelectBox],
						 ['quadSelectPanel', quadSelectBox.panel],
						 ['quadSelectBox', quadSelectBox],
						 ['scorePanel', scorePanel]])

# action listener for Selection grouping button changes
def hpSelectionGroupingActionListener(evt):
	masterObject.setField('hpSelectionGrouping', evt.getActionCommand())
	# indicate that the data needs to be re-normalized
	masterObject.setField('Compute hairpin scores', 1)

	# click the button on the Data Analysis tab:
	evtStr = evt.getActionCommand()
	hpsBox = masterObject.getField('daHpSelGroupingBox')
	hpsBox.setSelectedButton(evtStr)

# action listener for Batch grouping button changes
def hpBatchGroupingActionListener(evt):
	masterObject.setField('hpBatchGrouping', evt.getActionCommand())
	masterObject.setField('Compute hairpin scores', 1)

	# click the button on the Data Analysis tab:
	evtStr = evt.getActionCommand()
	bgBox = masterObject.getField('daHpBatchGroupingBox')
	bgBox.setSelectedButton(evtStr)

# action listener for Use of Control wells button changes
def controlWellActionListener(evt):
	masterObject.setField('controlWells', evt.getActionCommand())
	invalidatePlateAnalysis()
	processAnalysisPlateset()

# action listener for Normalization method button changes
def scoreMethodActionListener(evt):
	oldScore = masterObject.getField('scoreMethod')
	evtStr = evt.getActionCommand()
	# return if no change occurred:
	if oldScore == evtStr:
		return

	# record the new button setting:
	masterObject.setField('scoreMethod', evtStr)
	invalidatePlateAnalysis()

	if evtStr != 'Infection efficiency':
		daScoreSelectBox = masterObject.getField('daScoringMethodBox')
		daScoreSelectBox.setSelectedButton(evtStr)

	# reprocess the plates:
	processAnalysisPlateset()

# action listener for Granularity button changes
def granularityActionListener(evt):
	oldQuad = masterObject.getField('quad')
	evtStr = evt.getActionCommand()
	# return if no change occurred:
	if oldQuad == evtStr:
		return

	# get the analysis plateSet:
	analysisSet = masterObject.getField('analysisPlateset')
	invalidatePlateAnalysis()

	# record the new button setting:
	masterObject.setField('quad', evtStr)
	if evtStr == 'plate':
		analysisSet.setQuad(0)
	else:
		analysisSet.setQuad(1)

	# reprocess the analysis plates set:
	processAnalysisPlateset()

# construct the panel that displays the plate-map visualization 
def makePlateVisPanel():
	# main (returned) panel:
	vPanel = JPanel(GridBagLayout())
	# subpanel, containing the plate heatmaps and colorbars:
	pvPanel = JPanel(GridBagLayout())

	# raw data heat panel and colorbar:
	hpRaw = MajorObjects.HeatPanel(16, 24, 'Raw Data')
	cBarRaw = makeColorBar()
	cBarRaw.addChangeListener(hpRaw)

	# normalized score data heat panel and colorbar:
	hpNorm = MajorObjects.HeatPanel(16, 24, 'Normalized Data')
	cBarNorm = makeColorBar()
	cBarNorm.addChangeListener(hpNorm)

	# GridBagConstraints:
	vConstraint = GridBagConstraints.newGridBagConstraints()
	vConstraint.anchor = GridBagConstraints.SOUTH
	vConstraint.gridx = GridBagConstraints.RELATIVE
	vConstraint.fill = GridBagConstraints.HORIZONTAL

	# fill in the subpanel:
	pvPanel.add(hpRaw, vConstraint)
	pvPanel.add(cBarRaw, vConstraint)
	pvPanel.add(hpNorm, vConstraint)
	pvPanel.add(cBarNorm, vConstraint)

	# add the subpanel to the main panel:
	vConstraint.anchor = GridBagConstraints.CENTER
	vPanel.add(pvPanel, vConstraint)

	# make the scoring method selection box:
	vConstraint.fill = GridBagConstraints.BOTH
	(scoreSelBox, compList) = makeMethodSelectBox()
	MainHandle.addToMasterObject(compList)

	# and add it to the main panel:
	vPanel.add(scoreSelBox, vConstraint)

	# the preferred size of the colorbar should be the height of the JPanel
	# containing the wells, plus the top and bottom insets of its border:

	hpPrefSize = hpRaw.getPreferredSize()
	tBorder = hpRaw.getBorder()
	obInset = tBorder.getBorderInsets(hpRaw)
	#ibInset = hpRaw.lineBorder.getBorderInsets(hpRaw)
	pHeight = hpPrefSize.height - (int(obInset.top)) + 5
	#pHeight = hpPrefSize.height-(obInset.bottom+obInset.top+ibInset.top+ibInset.bottom)
	#pHeight = hpPrefSize.height
	cBarRaw.setPreferredSize(Dimension(80, pHeight))
	cBarNorm.setPreferredSize(Dimension(80, pHeight))
	#printPanelSizes()

	return (vPanel, [['vPanel', vPanel],
					 ['rawPlate', hpRaw],
					 ['normPlate', hpNorm],
					 ['hpRaw', hpRaw],
					 ['cBarRaw', cBarRaw],
					 ['hpNorm', hpNorm],
					 ['cBarNorm', cBarNorm],
					 ['scoreSelBox', scoreSelBox]])

# AD: for debugging
def printPanelSizes():
	# print component sizes:
	hpRawSize = masterObject.getField('hpRaw').getSize()
	cbRawSize = masterObject.getField('cBarRaw').getSize()
	hpNrmSize = masterObject.getField('hpNorm').getSize()
	cbNrmSize = masterObject.getField('cBarNorm').getSize()
	sboxSize = masterObject.getField('scoreSelBox').getSize()

	print ' hbRaw: %s' % hpRawSize
	print ' cbRaw: %s' % cbRawSize
	print 'hbNorm: %s' % hpNrmSize
	print 'cbNorm: %s' % cbNrmSize
	print 'selBox: %s' % sboxSize

# action listener for Plate subset selection button changes
def subsetActionListener(evt):
	oldSubset = masterObject.getField('plateSubset')
	evtStr = evt.getActionCommand()
	# return if no change occurred:
	if oldSubset == evtStr:
		return

	masterObject.setField('plateSubset', evtStr)

	# click the button on the Data Analysis tab:
	bgBox = masterObject.getField('daSubsetBox')
	bgBox.clickButton(evtStr)

	# remove the selection listeners while updating the table:
	platePane = masterObject.getField('plateListPane')
	tableSelModel = platePane.table.getSelectionModel()
	tableModel = platePane.table.getModel()
	listeners = tableSelModel.getListSelectionListeners()
	for listener in listeners:
		tableSelModel.removeListSelectionListener(listener)

	# get the virus plate ID to virus plate name map
	vpId2vpName = masterObject.getField('vplateId2VPlateName')
	# record the new button setting:
	masterObject.setField('plateSubset', evtStr)

	# re-initialize the analysis plateset:
	analysisSet = PlateSet.PlateSet('AnalysisPlateset')

	# build the new analysis plateset:
	plateSet = masterObject.getField('plateSet')
	plateIdList = plateSet.keys()
	for plateId in plateIdList:
		plate = plateSet[plateId]

		# add the appropriate plates to the analysisPlateset:
		if evtStr == 'all plates':
			analysisSet.addPlate(plate)
		elif evtStr == 'only selection +' and plate.isSelected():
			analysisSet.addPlate(plate)
		elif evtStr == 'only selection -' and not plate.isSelected():
			analysisSet.addPlate(plate)
		else:
			'Plate selection error!!!'

	# empty the displayed plate list:
	platePane.clearList()

	# get the new set of plates, and add the rows to the table:
	plateIdList = analysisSet.getPlateIdList()
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		selStat = '%s : %s' % (plate.selection, plate.selectionStatus)
		for readId in plate.get_readIdList():
			rowTag = '%s:%s' % (plateId, readId)
			condition = plate.getAssay(readId).get_condition()
			plateRow = [plate.screenName, plate.batchName, plate.plateName, vpId2vpName[plate.get_virusPlateId()],
						selStat.upper(), condition]
			rowIdx = platePane.addRow(plateRow, rowTag)
			if not plate.use:
				tableModel.addFlaggedKey(rowTag, rowIdx, Color.newColor(255, 200, 200))

	# set the quad flag for the analysis set:
	quad = masterObject.getField('quad')
	if quad == 'plate':
		analysisSet.setQuad(0)
	else:
		analysisSet.setQuad(1)

	# reattach the listeners after the table is updated:
	for listener in listeners:
		tableSelModel.addListSelectionListener(listener)

	masterObject.setField('analysisPlateset', analysisSet)
	processAnalysisPlateset()

	# update the plate display:
	platePane = masterObject.getField('plateListPane')
	platePane.table.getSelectionModel().setSelectionInterval(0, 0)
	plateIdx = platePane.getRowKey(0)
	updatePlateMapDisplay(plateIdx, platePane)

	# reset the selectedColIdx to -1 to indicate that the rows should be sorted
	#   on the next column selection event
	masterObject.setField('columnSortIdx', -1)

# construct the color scale/slider
def makeColorBar():
	cBar = MajorObjects.ColorScalePanel()
	return cBar

# construct the plate list table
def makePlateListTable():
	# virus plate listBox container:
	colNames = ['Screen', 'Batch', 'Plate Name', 'Virus Plate', 'Selection : Status', 'Conditions']
	# display the table in a scrollable pane:
	plateListPane = MajorObjects.NormTablePane(0)
	plateListPane.setColumnNames(colNames)
	plateListPane.addListSelectionListener(MajorObjects.TableListSelectionListener(plateListPane.table, plateVisUpdate))
	plateListPane.addTableKeyboardListener(MajorObjects.TableKeyboardListener(plateListPane.table, plateListKeyHandler))
	plateListPane.addHeaderListener(MajorObjects.HeaderMouseListener(plateListPane.table, columnSelect))
	plateListPane.setBorder(loweredEtched)
	plateListPane.setColumnHorizontalAlignment(JLabel.CENTER)
	plateListPane.setHeaderFont(Font.Helvetica12Bold)
	#plateListPane.setPreferredSize(Dimension(900,200))

	return (plateListPane, [['plateListPane', plateListPane],
							['columnSortIdx', colNames.index('Screen')]])    # changed from 'Virus Plate' to cause the rows to be
	# sorted the first time the Virus Plate column header is clicked.

# Save Well-level Results button
def makeSaveWellButton():
	saveWellButtonPane = MajorObjects.BorderedButton('Save Well-level Results', saveWellAnalysisResults)

	return (saveWellButtonPane, [['saveWellButtonPane', saveWellButtonPane],
							 ['saveWellButton', saveWellButtonPane.button]])

# Save Hairpin-level Results button
def makeSaveHpButton():
	saveHpButtonPane = MajorObjects.BorderedButton('Save Hairpin-level Results', saveHpAnalysisResults)

	return (saveHpButtonPane, [['saveHpButtonPane', saveHpButtonPane],
							 ['saveHpButton', saveHpButtonPane.button]])

# Save GENE-E button
def makeSaveRigerButton():
	saveRigerButtonPane = MajorObjects.BorderedButton('Save GENE-E data', rigerOutput)

	return (saveRigerButtonPane, [['saveRigerButtonPane', saveRigerButtonPane],
							 ['saveRigerButton', saveRigerButtonPane.button]])

# Save gene-level results button (AD: not used)
def makeSaveGeneButton():
	saveGeneButtonPane = MajorObjects.BorderedButton('Save Gene-level Results', saveGeneAnalysisResults)
	saveGeneButtonPane.button.setEnabled(0)

	return (saveGeneButtonPane, [['saveGeneButtonPane', saveGeneButtonPane],
							 ['saveGeneButton', saveGeneButtonPane.button]])

# Compute gene scores button (AD: not used)
def makeComputeGeneButton():
	computeGeneButtonPane = MajorObjects.BorderedButton('Update Parameters', gatherGeneData)
	return (computeGeneButtonPane, [['computeGeneButtonPane', computeGeneButtonPane],
							 ['computeGeneButton', computeGeneButtonPane.button]])

# write out the well-level results (action listener for "Save Well-level Results" button
def saveWellAnalysisResults(event):
	# reprocess the analysis plateset, if necessary:
	if masterObject.getField('Update analysis'):
		processAnalysisPlateset()

	# choose the output file name, if fout returns as None, return without saving:
	fout = MajorObjects.chooseFile()
	if fout == None:
		return

	# get the present analysis set:
	analysisSet = masterObject.getField('analysisPlateset')
	plateIdList = analysisSet.getPlateIdList()
	plateIdList.sort()
        readIds = analysisSet.getReadIds()

	# Write out the top-of-file comments
	fout.write('# NOTE: plate-level info is at the bottom of this file\n\n')
	fout.write('# WELL-level analysis results\n')
	fout.write('# File generated by: %s\n' % masterObject.getField('uName'))
	fout.write('# Created on: %s\n' % datetime.datetime.now().strftime('%d-%b-%Y %H:%M:%S'))
	fout.write('# Software version: %s\n\n' % masterObject.getField('Software version'))
	fout.write('\n')
	fout.write('# Plate subset selection:\t%s\n' % masterObject.getField('plateSubset'))
	fout.write('# Scoring method:\t%s\n' % masterObject.getField('scoreMethod'))
	fout.write('# Scoring granularity:\t%s\n' % masterObject.getField('quad'))
	fout.write('# Use of control wells:\t%s\n' % masterObject.getField('controlWells'))

	# write condition : selectedFeature header
	conditionSelectedFeature = writeConditionFeatureSelectionHeader(fout, analysisSet)

	# create the column headers
	header1 = 'screen name\tbatch name\tplate name\tplate ID\tpuro status\trow\tcol\tInfEff'
	header2 = 'virus plate name\tcloneID\tsource plate name\tsource row\tsource col\tquad\thairpin name\ttrans target\tsymbol\tpreferred name\tgene ID\ttaxon ID'
	header3 = 'hairpin seq.\tcontig ID\tstart\tend\tstrand\ttype'

	# write well data out for each plate, and gather the results by hairpin
	oldHeader = ''
	headerLines = {}
	firstPlate = 1
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		# if the 'use' flag is 0, skip this plate
		if not plate.use:
			continue

		# create header string for this plate. If the header string has not changed, don't print
		# a new one. If it has changed, write new column headers:
		rawHeader = None
		for readId in readIds:
                        assay = analysisSet.getAssayForReadId(readId)
                        rHeader = assay.getAssayHeader(conditionSelectedFeature)
			if rawHeader == None:
				rawHeader = rHeader
			else:
				rawHeader = '%s\t%s' % (rawHeader, rHeader)
			rawHeader = '%s\t%s' % (rawHeader, plate.scoreStr)

		fullHeader = '%s\t%s\t%s\t%s' % (header1, rawHeader, header2, header3)
		if fullHeader != oldHeader:
			fout.write('%s\n' % fullHeader)
			oldHeader = fullHeader

		vPlate = plate.virusPlate
		pI = plate.getPlateInfo(analysisSet)
		for param in pI['paramList']:
			# build the header label line
			if firstPlate:
				headerLines.setdefault('header', '#')
				headerLines['header'] += '\t%s' % param
			headerLines.setdefault(plateId, '#')
			headerLines[plateId] += '\t%s' % pI[param]
		# for skipping the rest of the plates:
		firstPlate = 0

		# get the list of rows and columns and sort them...
		assay = {}
		normData = {}
		valid = {}

		# get the assay data for each assay for this plate
		for readId in readIds:
			assayData = plate.getAssay(readId)
                        if assayData == None:
                                (assay[readId], valid[readId]) = (None, None)
                        else:
                                (assay[readId], valid[readId]) = assayData.getAssayData()

			normData[readId] = plate.getNorm(readId)
			if assayData != None and normData[readId] == None:
				print 'No normalized data for plate %s (%s), readId %s' % (plate.plateName, plateId, readId)

		# get the infection efficiency
		ieData = plate.getIE()
		if ieData == None:
			print 'No infection efficiency data for plate %s (%s)' % (plate.plateName, plateId)

		# get the virus plate info for this plate
		vpName = plate.virusPlate.plateName
		rowList = vPlate.well.keys()
		rowList.sort()
		for row in rowList:
			colList = vPlate.well[row].keys()
			colList.sort()
			# construct the string for this row of the file
			for col in colList:
				wData = '%s\t%s\t%s\t%s\t%s\t%s\t%s' % (pI['screenName'], pI['batchName'],
                                                                        pI['plateName'], pI['plateId'],
                                                                        pI['Selection status'], row, col)
				vWell = vPlate.well[row][col]
				if ieData == None:
					ie = 'N/A'
				else:
					try:
						ie = '%5.3f' % ieData[row][col]
					except:
						print '__float__ error: ', ieData[row][col]
						ie = 'N/A'

				# add IE:
				wData = '%s\t%s' % (wData, ie)

				# add raw data and score:
				for readId in readIds:
                                        assayReadId = assay[readId]
                                        if assayReadId != None:
                                                assayReadIdRowCol = assayReadId[row][col]
                                                normDataReadIdRowCol = normData[readId][row][col]
                                        else:
                                                numNas = len(analysisSet.getAssayForReadId(readId).getFeatureList())
                                                assayReadIdRowCol = "\t" * (numNas - 1)
                                                normDataReadIdRowCol = None
					wData = '%s\t%s' % (wData, assayReadIdRowCol)
                                        if normDataReadIdRowCol != None:
                                                wData = '%s\t%6.3f' % (wData, normDataReadIdRowCol)
                                        else:
                                                wData = '%s\t' % (wData)

				tStr = '%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s' % \
					   (vpName, vWell.cloneId,
                                            vWell.sourcePlateName, vWell.sourcePlateRow, vWell.sourcePlateCol, vWell.quad,
                                            vWell.cloneName, vWell.targetSeq, vWell.symbol, vWell.prefName, vWell.geneId, vWell.taxon, vWell.targetSeq,
                                            vWell.sourceContig, vWell.sourceStart, vWell.sourceEnd, vWell.sourceStrand, vWell.type)

				fout.write('%s\t%s\n' % (wData, tStr))

	# write out the plate-level info for the plate set
	fout.write('\n%s\n' % headerLines['header'])
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		if not plate.use:
			continue
		fout.write('%s\n' % headerLines[plateId])
	fout.close()

def writeConditionFeatureSelectionHeader(fout, analysisSet):
	# list the selected features for each plate condition:
	conditionSelectedFeature = {}
        for readId in analysisSet.getReadIds():
                thisAssay = analysisSet.getAssayForReadId(readId)
                thisCondition = thisAssay.get_condition()
                thisFeature = thisAssay.getSelectedFeature()
                conditionSelectedFeature.setdefault(thisCondition, [])
                if conditionSelectedFeature[thisCondition].count(thisFeature) == 0:
                        conditionSelectedFeature[thisCondition].append(thisFeature)

	for condition in conditionSelectedFeature.keys():
		fout.write('# condition: %s\tselected feature: %s\n' % (condition, conditionSelectedFeature[condition][0]))
	fout.write('\n')
	return conditionSelectedFeature

# write out the hairpin-level results (action listener for "Save Hairpin-level Results" button)
def saveHpAnalysisResults(event):
	# reprocess the analysis plateset, if necessary:
	if masterObject.getField('Update analysis'):
		processAnalysisPlateset()

	# choose the output file name, if fout returns as None, return without saving:
	fout = MajorObjects.chooseFile()
	if fout == None:
		return

	# get the present analysis set:
	analysisSet = masterObject.getField('analysisPlateset')
	plateIdList = analysisSet.getPlateIdList()

	vPlateSet = masterObject.getField('vPlateSet')  ## <<<<<<< get from vPlateSet map

	# make column headers:
	fout.write('# NOTE: plate-level info is at the bottom of this file\n\n')
	fout.write('# HAIRPIN-level analysis results\n')
	fout.write('# File generated by:\t%s\n' % masterObject.getField('uName'))
	fout.write('# Created on:\t%s\n' % datetime.datetime.now().strftime('%d-%b-%Y %H:%M:%S'))
	fout.write('# Software version:\t%s\n\n' % masterObject.getField('Software version'))
	fout.write('# Plate subset selection:\t%s\n' % masterObject.getField('plateSubset'))
	fout.write('# Scoring method:\t%s\n' % masterObject.getField('scoreMethod'))
	fout.write('# Scoring granularity:\t%s\n' % masterObject.getField('quad'))
	fout.write('# Use of control wells:\t%s\n' % masterObject.getField('controlWells'))

	# write condition : selectedFeature header
	conditionSelectedFeature = writeConditionFeatureSelectionHeader(fout, analysisSet)

	fout.write('\n')

	headerLines = {}
	firstPlate = 1

	# get the file header lines from the first (or any) plate:
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		if not plate.use:
			continue
		pI = plate.getPlateInfo(analysisSet)

		for param in pI['paramList']:
			# build the header label line
			if firstPlate:
				headerLines.setdefault('header', '#')
				headerLines['header'] += '\t%s' % param
			headerLines.setdefault(plateId, '#')
			headerLines[plateId] += '\t%s' % pI[param]
		firstPlate = 0

	# compute the hairpin scores:
	if masterObject.getField('Compute hairpin scores'):
		computeHairpinScores()

	hpData = masterObject.getField('hpData')
	hpList = hpData.keys()

	hpList.sort()
	firstHp = 1
	scoreMethod = masterObject.getField('scoreMethod')

	for hpName in hpList:
		if firstHp:
			# write the header before the first data line
			fout.write("Screen\tBatch\tcondition\tselection\thairpin ID\tcount\traw mean\traw StDev\t%s mean\t%s StDev\tIE mean\tIE StDev\tclone ID\tsymbol\tpref name\tgene ID\ttaxon\ttarget sequence\tcontig ID\tstart\tstop\tstrand\ttype\n" % (scoreMethod, scoreMethod))
			firstHp = 0

		# get the hairpin data line
		outstr = getHpLine(hpData, hpName)
		fout.write(outstr)    # write the line to the output file

	# write the plate-level info at the bottom of the file
	fout.write('\n%s\n' % headerLines['header'])
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		if not plate.use:
			continue
		fout.write('%s\n' % headerLines[plateId])
	fout.close()

# construction of the line of the hairpin-level output file: 
def getHpLine(hpData, hpKey):
	hpName = hpKey.split(':')[0]   # hairpin name
	cloneId = hpKey.split(':')[1]  # clone ID
	oStr = ''
	# construct a separate line for the hairpin for each screen, batch, condition, and selection status
	for screen in hpData[hpKey].keys():
		for batch in hpData[hpKey][screen].keys():
			for pCond in hpData[hpKey][screen][batch].keys():
				for selStat in hpData[hpKey][screen][batch][pCond].keys():
					hpPtr = hpData[hpKey][screen][batch][pCond][selStat]
					if pCond == 'None' or pCond == None:
						cond = ''
					else:
						cond = pCond
					if hpPtr['ieMean'] == None:
						hpIe = '-'
						hpStd = '-'
					else:
						hpIe = '%6.3f' % hpPtr['ieMean']
						hpStd = '%6.3f' % hpPtr['ieStd']

					thisStr = '%s\t%s\t%s\t%s\t%s\t%d\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%s\t%s\t%s\t%s' % \
					   (screen, batch, cond, selStat, hpName, len(hpPtr['raw']),
					    hpPtr['rMean'], hpPtr['rStd'], hpPtr['nMean'], hpPtr['nStd'],
					    hpIe, hpStd, cloneId, hpPtr['info'])
						#hpPtr['ieMean'],hpPtr['ieStd'],cloneId,hpPtr['info'])
					oStr = '%s%s\n' % (oStr, thisStr)

	# return the output line string
	return oStr

# write out the hairpin-level results in a form that is readable by RIGER/GENE-E
# (action listener for "Save GENE-E Data" button)
def rigerOutput(event):
	# reprocess the analysis plateset, if necessary:
	if masterObject.getField('Update analysis'):
		processAnalysisPlateset()

	# choose the output file name, if fGct returns as None, return without saving:
	(fGct, fChip) = MajorObjects.chooseGCTFile()
	if fGct == None:
		return

	# get the present analysis set:
	analysisSet = masterObject.getField('analysisPlateset')

	# compute the hairpin scores:
	if masterObject.getField('Compute hairpin scores'):
		computeHairpinScores()

	# get the hairpin data
	hpData = masterObject.getField('hpData')
	# extract the list of hairpin IDs
	hpList = hpData.keys()
	# .. and sort the list
	hpList.sort()

	# scan the hairpin to collect all conditions tested for all hairpins:
	columnNames = []
	columnTree = {}
	colMax = 0
	for hpName in hpList:
		# get the data for this hairpin
		(columnNames, columnTree, colMax) = getRigerColumns(hpData[hpName], columnNames, columnTree, colMax)

	# write .gct file headers
	fGct.write('#1.2\n')       # mandatory first line in .gct file
	fGct.write('%d\t%d\n' % (len(hpList), len(columnNames)))   # number of data rows, number of data columns
	fGct.write('hairpinID\thairpinName')
	# write .chip file headers:
	fChip.write('Probe Set ID\tGene Symbol\tGene Title\n')

	# all columns must be present in every line 
	emptyCols = []
	for colName in columnNames:
		fGct.write('\t%s' % colName)
		emptyCols.append('')
	fGct.write('\n')

	cloneIdList = []
	firstHp = 1
	for hpKey in hpData.keys():
		newHp = 1
		colData = emptyCols[:]    # copy the empty columns list
		for screen in hpData[hpKey].keys():
			for batch in hpData[hpKey][screen].keys():
				for pCond in hpData[hpKey][screen][batch].keys():
					for selStat in hpData[hpKey][screen][batch][pCond].keys():
						# get the hairpin data object for this screen, batch, condition and selection status
						hpPtr = hpData[hpKey][screen][batch][pCond][selStat]

						# CHIP file output:
						if cloneIdList.count(hpPtr['cloneID']) == 0:
							cloneIdList.append(hpPtr['cloneID'])
							hpFields = hpPtr['info'].split('\t')
							if hpFields[0] == 'None':
								# missing symbol:
								symb = 'GeneID:%s' % hpFields[2]  # use geneID
							else:
								symb = hpFields[0]
							fChip.write('%s\t%s\t%s\n' % (hpPtr['cloneID'], symb, hpFields[1]))

						# extract gene info from virus well info for hairpin:
						if newHp:
							fGct.write('%s\t%s' % (hpPtr['cloneID'], hpPtr['cloneName']))
							newHp = 0
						colId = columnTree[screen][batch][pCond][selStat]
						# fill in each column with available data:
						colData[colId] = hpPtr['nMean']

		for x in colData:
			if x == None or x == "":
				x = "NA"
			fGct.write('\t%s' % x)
		fGct.write('\n')

	fGct.close()   # close the .gct file
	fChip.close()  # close the .chip file

# get all available data for this hairpin for all screens, batches, conditions and selection status
def getRigerColumns(hpPtr, columnNames, columnTree, colMax):
	for screen in hpPtr.keys():
		columnTree.setdefault(screen, {})
		for batch in hpPtr[screen].keys():
			columnTree[screen].setdefault(batch, {})
			for pCond in hpPtr[screen][batch].keys():
				columnTree[screen][batch].setdefault(pCond, {})
				for selStat in hpPtr[screen][batch][pCond].keys():
					columnTree[screen][batch][pCond].setdefault(selStat, colMax)
					hp = hpPtr[screen][batch][pCond][selStat]
					colHeader = '%s;%s;%s' % (batch, pCond, selStat)
					colHeader = colHeader.replace(' : ', ':')
					if columnNames.count(colHeader) == 0:
						columnNames.append(colHeader)
						colMax += 1

	return (columnNames, columnTree, colMax)

# AD: not used (part of deprecated Save Gene-level results)
def saveGeneAnalysisResults(event):
	# choose the output file name, if fout returns as None, return without saving:
	fout = MajorObjects.chooseFile()
	if fout == None:
		return

	# make column headers:
	fout.write('# NOTE: plate-level info is at the bottom of this file\n\n')
	fout.write('# GENE-level analysis results\n')
	fout.write('# File generated by:\t%s\n' % masterObject.getField('uName'))
	fout.write('# Created on:\t%s\n' % datetime.datetime.now().strftime('%d-%b-%Y %H:%M:%S'))
	fout.write('# Software version:\t%s\n\n' % masterObject.getField('Software version'))

	bgcolor = Color.newColor(255, 128, 128)

	try:
		iThreshMin = float(masterObject.getField('intensityThrMin').getText())
		iThrMinStr = '%5.2f' % iThreshMin
		masterObject.getField('intensityThrMin').setBackground(Color.WHITE)
	except:
		iThreshMin = None
		iThrMinStr = '<not specified>'
		masterObject.getField('intensityThrMin').setBackground(bgcolor)

	try:
		iThreshMax = float(masterObject.getField('intensityThrMax').getText())
		iThrMaxStr = '%5.2f' % iThreshMax
		masterObject.getField('intensityThrMax').setBackground(Color.WHITE)
	except:
		iThreshMax = None
		iThrMaxStr = '<not specified>'
		masterObject.getField('intensityThrMax').setBackground(bgcolor)

	try:
		cThresh = float(masterObject.getField('confidenceThr').getText())
		cThrStr = '%6.2f' % cThresh
		masterObject.getField('confidenceThr').setBackground(Color.WHITE)
	except:
		cThresh = None
		cThrStr = '<not specified>'
		masterObject.getField('cThresh').setBackground(bgcolor)

	fout.write('# Plate subset selection:\t%s\n' % masterObject.getField('plateSubset'))
	fout.write('# Scoring method:\t%s\n' % masterObject.getField('scoreMethod'))
	fout.write('# Scoring granularity:\t%s\n' % masterObject.getField('quad'))
	fout.write('# Use of control wells:\t%s\n' % masterObject.getField('controlWells'))
	fout.write('# Hairpin selection grouping:\t%s\n' % masterObject.getField('hpSelectionGrouping'))
	fout.write('# Gene-level batch grouping:\t%s\n' % masterObject.getField('hpBatchGrouping'))
	fout.write('#  Gene score High threshold:\t%s\n' % iThrMaxStr)
	fout.write('#  Gene score Low threshold:\t%s\n' % iThrMinStr)
	fout.write('#  Gene confidence threshold:\t%s\n\n' % cThrStr)

	# write condition : selectedFeature header
	analysisSet = masterObject.getField('analysisPlateset')
	plateIdList = analysisSet.getPlateIdList()
	conditionSelectedFeature = writeConditionFeatureSelectionHeader(fout, analysisSet)

	# get gene-level info
	geneData = masterObject.getField('geneData')
	(hpHits, condList, batchList) = getHpHits(geneData, iThreshMin, iThreshMax, cThresh)

	# write header:
	fout.write("condition\tbatch\tsymbol\tpreferred name\tgene ID\ttaxon ID\tselection\t(-)gene score\t(-)gene conf\t(+)gene score\t(+)gene conf\tconflict\t#hp tested\t#'confident' hp\n")
	for cond in condList:
		for batch in batchList:
			condBatch = '%s\t%s' % (cond, batch)
			for gene in geneData.keys():
				geneName = '%s\t%s\t%s\t%s' % (geneData[gene].symbol,
											   geneData[gene].prefName,
											   geneData[gene].geneId,
											   geneData[gene].taxonId)
				# skip to next gene if this one was not tested in this condition:
				try:
					selStatList = hpHits[cond][gene].keys()
				except:
					fout.write('%s\t%s\t<not tested>\n' % (condBatch, geneName))
					continue

				for selStat in selStatList:
					try:
						fout.write('%s\t%s\t%s\t%s\n' % (condBatch, geneName, selStat,
														 geneScore_2(hpHits[cond][gene][selStat][batch],
																	 iThreshMin, iThreshMax, cThresh)))
					except:
						fout.write('%s\t%s\t%s\t<not tested>\n' % (condBatch, geneName, selStat))


	# Collect and write the plate-level info for the analysis set:
	analysisSet = masterObject.getField('analysisPlateset')
	#plateIdList = analysisSet.getPlateIdList()
	plateIdList = analysisSet.getSortedPlateIdList()
	headerLines = {}
	firstPlate = 1
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		if not plate.use:
			continue
		pI = plate.getPlateInfo()

		for param in pI['paramList']:
			# build the header label line
			if firstPlate:
				headerLines.setdefault('header', '#')
				headerLines['header'] += '\t%s' % param
			headerLines.setdefault(plateId, '#')
			headerLines[plateId] += '\t%s' % pI[param]
		firstPlate = 0

	fout.write('\n%s\n' % headerLines['header'])
	for plateId in plateIdList:
		if analysisSet.getPlate(plateId).use:
			fout.write('%s\n' % headerLines[plateId])

	fout.close()

# AD: not used (old gene-level scoring)
def geneScore_1(hpScoreList, iLowThresh, iHighThresh, cThresh):
	if len(hpScoreList) == 0:
		# 0 - hits, 0 confidence, 0 + hits, 0 confidence, 0 conflict
		return '0\t0\t0\t0\t0'

	# negative (knock-down) hits:
	minScore = None
	nKdHits = 0
	kDconf = 0
	for hpScore in hpScoreList:
		if hpScore[1] <= iLowThresh:
			nKdHits += 1
			if hpScore[2] <= cThresh:
				kDconf += 1

		if minScore == None or hpScore[1] < minScore:
			minScore = hpScore[1]

	if minScore == None:
		kDstring = '<none>\t0'
	else:
		kDstring = '%6.3f\t%d' % (minScore, min(kDconf, 3))
		#kDstring = '%6.3f\t%d' % (minScore, kDconf)

	# positive (knock-up) hits:
	maxScore = None
	nKuHits = 0
	kUconf = 0
	for hpScore in hpScoreList:
		if hpScore[1] >= iHighThresh:
			nKuHits += 1
			if hpScore[2] <= cThresh:
				kUconf += 1

		if maxScore == None or hpScore[1] > maxScore:
			maxScore = hpScore[1]

	if maxScore == None:
		kUstring = '<none>\t0'
	else:
		kUstring = '%6.3f\t%d' % (maxScore, min(kUconf, 3))
		#kUstring = '%6.3f\t%d' % (maxScore, kUconf)

	if nKdHits > 0 and nKuHits > 0:
		conflict = 1
	else:
		conflict = 0

	return '%s\t%s\t%d' % (kDstring, kUstring, conflict)

# AD: not used (old gene-level scoring)
def geneScore_2(hpScoreList, iLowThresh, iHighThresh, cThresh):
	if len(hpScoreList) == 0:
		# 0 - hits, 0 confidence, 0 + hits, 0 confidence, 0 conflict
		return '0\t0\t0\t0\t0'

	# number passing confidence (Std dev) threshold):
	nConf = 0

	# negative (knock-down) hits:
	minScore = None
	nKdHits = 0
	for hpScore in hpScoreList:
		if hpScore[2] <= cThresh:
			nConf += 1
			if hpScore[1] <= iLowThresh:
				nKdHits += 1

			if minScore == None or (hpScore[1] < minScore and hpScore[2] <= cThresh):
				minScore = hpScore[1]

	if minScore == None:
		kDstring = '<none>\t0'
	else:
		#kDstring = '%6.3f\t%d' % (minScore, min(kDconf,3))
		kDstring = '%6.3f\t%d' % (minScore, min(nKdHits, 3))
		#kDstring = '%6.3f\t%d' % (minScore, kDconf)

	# positive (knock-up) hits:
	maxScore = None
	nKuHits = 0
	for hpScore in hpScoreList:
		if hpScore[2] <= cThresh:
			if hpScore[1] >= iHighThresh:
				nKuHits += 1

			if maxScore == None or (hpScore[1] > maxScore and hpScore[2] <= cThresh):
				maxScore = hpScore[1]

	if maxScore == None:
		kUstring = '<none>\t0'
	else:
		#kUstring = '%6.3f\t%d' % (maxScore, min(kUconf,3))
		kUstring = '%6.3f\t%d' % (maxScore, min(nKuHits, 3))
		#kUstring = '%6.3f\t%d' % (maxScore, kUconf)

	if nKdHits > 0 and nKuHits > 0:
		conflict = 1
	else:
		conflict = 0

	return '%s\t%s\t%d\t%d\t%d' % (kDstring, kUstring, conflict, len(hpScoreList), nConf)

# AD: not used (old gene-level scoring)
# get the list of hairpins, with their intensity and confidence scores  for all genes
def getHpHits(geneData, iLowThresh, iHighThresh, cThresh):
	# recompute hairpin scores if necessary:
	if masterObject.getField('Compute hairpin scores'):
		computeHairpinScores()

	hpData = masterObject.getField('hpData')
	geneData = {}
	geneInfo = {}
	for hpKey in hpData.keys():
		for screen in hpData[hpKey].keys():
			for batch in hpData[hpKey][screen].keys():
				for pCond in hpData[hpKey][screen][batch].keys():
					for selStat in hpData[hpKey][screen][batch][pCond].keys():
						hpPtr = hpData[hpKey][screen][batch][pCond][selStat]
						# extract gene info from virus well info for hairpin:
						info = hpPtr['info'].split('\t')
						symbol = info[0]
						pName = info[1]
						geneId = info[2]
						taxon = info[3]
						gContig = info[5]
						gStart = info[6]
						gEnd = info[7]
						gStrand = info[8]
						gType = info[9]
						geneInfo.setdefault(geneId, [symbol, pName, taxon, gContig, gStart, gEnd, gStrand, gType])
						geneData.setdefault(geneId, {})
						geneData[geneId].setdefault(screen, {})
						geneData[geneId][screen].setdefault(batch, {})
						geneData[geneId][screen][batch].setdefault(pCond, {})
						geneData[geneId][screen][batch][pCond].setdefault(selStat, {})
						gPtr = geneData[geneId][screen][batch][pCond][selStat]
						gPtr.setdefault('hpList', [])
						# make a list of all hairpins associated with this gene under these conditions:
						gPtr['hpList'].append(hpPtr)

	for geneId in geneData.keys():
		for screen in geneData[geneId].keys():
			for batch in geneData[geneId][screen].keys():
				for pCond in geneData[geneId][screen][batch].keys():
					for selStat in geneData[geneId][screen][batch][pCond].keys():
						gPtr = geneData[geneId][screen][batch][pCond][selStat]
						for hpPtr in gPtr['hpList']:
							pass  # <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

# compute hairpin-level scores:
def computeHairpinScores():
	# get the present analysis set:
	analysisSet = masterObject.getField('analysisPlateset')
	plateIdList = analysisSet.getPlateIdList()

	# combined or separate puro+ and puro- ?:
	selCombine = masterObject.getField('hpSelectionGrouping')
	if selCombine == 'combine puro+/puro-':
		sCombine = 1
	else:
		sCombine = 0

	# combined batches or separate?:
	batchCombine = masterObject.getField('hpBatchGrouping')
	if batchCombine == 'keep separate':
		bCombine = 0
	else:
		bCombine = 1

	# initialize to a blank dictionary:
	hpData = {}

	# gather all data from all plates
	for plateId in plateIdList:
		plate = analysisSet.getPlate(plateId)
		if not plate.use:
			# skip plates that are marked use==0
			continue

		screen = plate.screenName     # get the screen
		ieMask = plate.ieMask         # get the IE mask (wells that should be ignored are marked "0")

		# get the data for each assay for this plate
		for readId in plate.get_readIdList():
			pCond = plate.get_condition(readId)  # get the condition
			norm = plate.getNorm(readId)         # get the normalized data
			(raw, rValid) = plate.getAssayData(readId)   # get the raw data
			ie = plate.getIE()                   # get the infection efficiencies for each well
			rowList = norm.keys()                # get the rows
			for row in rowList:
				colList = norm[row].keys()      # get the columns
				for col in colList:
					vWell = plate.virusPlate.well[row][col]    # get the virus plate well info
					hpName = vWell.cloneName                   # the hairpin name
					hpId = vWell.cloneId                       # the nairpin ID

					if bCombine:
						# if combining all batches
						batch = '%s:all' % plate.screenName
					else:
						# if keeping the batches separate
						batch = '%s:%s' % (plate.screenName, plate.batchName)

					if sCombine:
						# check if plate subset selection button only selects puro+ or puro- plates
						plateSubset = masterObject.getField('plateSubset')
						if plateSubset == 'only selection +':
							# if only puro+ plates are selected
							selStat = '%s:PLUS' % plate.selection
						elif plateSubset == 'only selection -':
							# if only puro- plates are selected
							selStat = '%s:MINUS' % plate.selection
						else:
							# combine the puro+ and puro- results
							selStat = '%s:+/-' % plate.selection
					else:
						# if keeping the puro+ and puro- separate
						selStat = '%s:%s' % (plate.selection, plate.selectionStatus)


					if vWell.type < 0 or ieMask[row][col] == 1:
						# gather info for all control and normal (gene-targeting) hairpins - not EMPTY or pgw
						# for all screens, batches, conditions, and selection status 
						hpKey = '%s:%s' % (hpName, hpId)
						hpData.setdefault(hpKey, {})
						hpData[hpKey].setdefault(screen, {})
						hpData[hpKey][screen].setdefault(batch, {})
						hpData[hpKey][screen][batch].setdefault(pCond, {})
						hpData[hpKey][screen][batch][pCond].setdefault(selStat, {})
						hpData[hpKey][screen][batch][pCond][selStat].setdefault('ie', [])

						if ie != None:
                                                        ieScore = ie[row][col]
                                                        if ieScore != None:
                                                                hpData[hpKey][screen][batch][pCond][selStat]['ie'].append(ieScore)

						hpData[hpKey][screen][batch][pCond][selStat].setdefault('raw', [])
						hpData[hpKey][screen][batch][pCond][selStat]['raw'].append(raw[row][col])
						hpData[hpKey][screen][batch][pCond][selStat].setdefault('norm', [])
						hpData[hpKey][screen][batch][pCond][selStat]['norm'].append(norm[row][col])
						# make vWell Info string>>>>>>>>>>>>>>:
						vWellInfo = '%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%d' % (vWell.symbol, vWell.prefName,
										  vWell.geneId, vWell.taxon, vWell.targetSeq, vWell.sourceContig,
										  vWell.sourceStart, vWell.sourceEnd, vWell.sourceStrand, vWell.type)
						hpData[hpKey][screen][batch][pCond][selStat]['info'] = vWellInfo
						hpData[hpKey][screen][batch][pCond][selStat]['cloneID'] = vWell.cloneId
						hpData[hpKey][screen][batch][pCond][selStat]['cloneName'] = vWell.cloneName

	# compute mean and StDev of the raw and normalized data for each hairpin for each screen, batch, etc...
	for hpKey in hpData.keys():
		for screen in hpData[hpKey].keys():
			for batch in hpData[hpKey][screen].keys():
				for pCond in hpData[hpKey][screen][batch].keys():
					for selStat in hpData[hpKey][screen][batch][pCond].keys():
						hpPtr = hpData[hpKey][screen][batch][pCond][selStat]

						# raw/normalized score mean/std
						rScoreList = hpPtr['raw']
						nScoreList = hpPtr['norm']
						if len(rScoreList) == 0:
							# no scores for this screen, batch, etc...
							hpPtr['rMean'] = None
							hpPtr['rStd'] = None
							hpPtr['nMean'] = None
							hpPtr['nStd'] = None
							hpPtr['ieMean'] = None
							hpPtr['ieStd'] = None
							print "scoreList len = 0 for hp: %s (this shouldn't be able to happen)" % hpKey
						elif len(rScoreList) == 1:
							# only 1 score for this screen, batch, etc...
							hpPtr['rMean'] = hpPtr['raw'][0]     # mean = the one data value
							hpPtr['rStd'] = 0.0                  # std dev is 0, by defnition
							hpPtr['nMean'] = hpPtr['norm'][0]    # mean = the one data value
							hpPtr['nStd'] = 0.0                  # std dev is 0, by defnition

							try:
								hpPtr['ieMean'] = hpPtr['ie'][0]    # mean = one IE value (if there is one)
								hpPtr['ieStd'] = 0.0
							except:
								# case where no IE data is available:
								hpPtr['ieMean'] = None
								hpPtr['ieStd'] = None

						else:
							# more than one data value
							hpPtr['rMean'] = stats.lmean(hpPtr['raw'])           # mean of raw data
							hpPtr['rStd'] = stats.lsamplestdev(hpPtr['raw'])     # std dev of raw data
							hpPtr['nMean'] = stats.lmean(hpPtr['norm'])          # mean of normalized data
							hpPtr['nStd'] = stats.lsamplestdev(hpPtr['norm'])    # std dev of normalized data
							if len(hpPtr['ie']) > 0:
								# more than one IE value for this hairpin
								try:
									hpPtr['ieMean'] = stats.lmean(hpPtr['ie'])
                                                                        hpPtr['ieStd'] = stats.lsamplestdev(hpPtr['ie'])
								except:
									print "len(hpPtr['ie']): %d" % len(hpPtr['ie'])
									print 'screen: %s, batch: %s, hairpin: %s, selection: %s' % (screen, batch, hpKey, selStat)
									print "  ", hpPtr['ie']
							else:
								# no IE data for this hairpin
								hpPtr['ieMean'] = None
								hpPtr['ieStd'] = None

	masterObject.setField('hpData', hpData)            # save the results into the masterObject, rather than returning it
	masterObject.setField('Compute hairpin scores', 0) # flag that the hairpins scores are valid

# AD: not used (part of the deprecated gene-level analysis for this tab)
def gatherGeneData(evt):
	# reprocess the analysis plateset, if necessary:
	if masterObject.getField('Update analysis'):
		processAnalysisPlateset()

	if masterObject.getField('Compute hairpin scores'):
		computeHairpinScores()

	confList = []
	scoreList = []
	loScoreList = []
	hiScoreList = []
	minScore = None
	maxScore = None
	minConf = None
	maxConf = None
	hpData = masterObject.getField('hpData')
	if masterObject.getField('hpBatchGrouping') == 'combine batches':
		bCombine = 1
	else:
		bCombine = 0

	geneData = {}
	for hairpin in hpData.keys():
		geneId = hpData[hairpin].geneId
		geneData.setdefault(geneId, PlateSet.Gene(hpData[hairpin]))
		geneData[geneId].addHairpin(hpData[hairpin])

	print '%d genes represented.' % len(geneData.keys())
	masterObject.setField('geneData', geneData)

	for geneId in geneData.keys():
		(gInMin, gInMax, gConfMin, gConfMax) = geneData[geneId].getGeneScoreRange()

		if gConfMin != -10000.0 and gConfMax != -10000.0 and gConfMin != None and gConfMax != None:
			confList.append(gConfMin)
			confList.append(gConfMax)

		if gInMin != None:
			loScoreList.append(gInMin)
		if gInMax != None:
			hiScoreList.append(gInMax)

		if minScore == None or (gInMin != None and gInMin < minScore):
			minScore = gInMin
		if maxScore == None or (gInMax != None and gInMax > maxScore):
			maxScore = gInMax
		if (minConf == None or (gConfMin != None and gConfMin < minConf)) and gConfMin != -10000.0:
			minConf = gConfMin
		if (maxConf == None or (gConfMax != None and gConfMax > maxConf)) and gConfMax != -10000.0:
			maxConf = gConfMax

	intensityMin = masterObject.getField('intensityMin')
	try:
		intensityMin.setText('%4.2f' % minScore)
	except:
		intensityMin.setText('---')

	intensityMax = masterObject.getField('intensityMax')
	try:
		intensityMax.setText('%4.2f' % maxScore)
	except:
		intensityMax.setText('---')

	confidenceMin = masterObject.getField('confidenceMin')
	try:
		confidenceMin.setText('%4.2f' % minConf)
	except:
		confidenceMin.setText('---')

	confidenceMax = masterObject.getField('confidenceMax')
	try:
		confidenceMax.setText('%4.2f' % maxConf)
	except:
		confidenceMax.setText('---')

	# compute default thresholds:
	iRange1pctlo = len(loScoreList) / 100.0
	iRange1pcthi = len(hiScoreList) / 100.0
	loScoreList.sort()
	hiScoreList.sort()

	# default lower thresh: 5th percentile of low hairpin scores across batches
	iMinThreshIdx = int(5.0 * iRange1pctlo)
	intensityThrMin = masterObject.getField('intensityThrMin')
	#intensityThrMin.setText('%4.2f' % minScoreThresh)
	intensityThrMin.setText('%4.2f' % loScoreList[iMinThreshIdx])

	# default upper thresh: 95th percentile of high hairpin scores across batches 
	iMaxThreshIdx = int(95.0 * iRange1pcthi)
	intensityThrMax = masterObject.getField('intensityThrMax')
	intensityThrMax.setText('%4.2f' % hiScoreList[iMaxThreshIdx])

	cRange1pct = len(confList) / 100.0
	confList.sort()							   # sort the list of confidences
	confidenceThr = masterObject.getField('confidenceThr')
	confThreshIdx = int(50.0 * cRange1pct)		  # 50th percentile confidence
	if confThreshIdx:
		confThresh = confList[confThreshIdx]
	else:
		confThresh = 0.0

	confidenceThr.setText('%4.2f' % confThresh)

	# This is the only way the 'Save Gene-level Results' button can get re-activated
	activateGeneSaveButton()

# initialize this panel for the first time it is displayed
def initializeNPanel(progressBar=None):
	# get the selected plates and virus plates:
	platePane = masterObject.getField('plateListPane')
	vpId2vpName = masterObject.getField('vplateId2VPlateName')

	# remove the selection listeners while updating the table:
	tableModel = platePane.table.getSelectionModel()
	listeners = tableModel.getListSelectionListeners()
	for listener in listeners:
		tableModel.removeListSelectionListener(listener)

	# empty the plate list:
	nRows = platePane.getRowCount()
	if nRows > 0:
		platePane.clearList()

	# reset the selected row:
	masterObject.setField('lastSelectedPlate', None)

	# get the top-level window
	topWindow = masterObject.getField('topWindow')

	# create a PlateSet for storage of all plates
	analysisSet = PlateSet.PlateSet('AnalysisPlateset')

	# get the full plate set
	plateSet = masterObject.getField('plateSet')
	# create a sorted list of all plate IDs
	plateIdList = plateSet.keys()
	plateIdList.sort()

	nAssay = 0
	# initialize the analysis set to contain all plates
	for plateId in plateIdList:
		plate = plateSet[plateId]             # get a plate
		analysisSet.addPlate(plate)           # add it to the analysis set
		nAssay += len(plate.get_readIdList()) # count the total number assays

	plateInc = 1.0 / nAssay    # the per-plate increment for the progress bar
	platePct = 0               # initialize the progress bar
	if progressBar != None:
		progressBar.setProgress(platePct) # set the initial progress to 0

	for plateId in analysisSet.getPlateIdList():
		# construct the plate list table, one row per assay
		plate = analysisSet.getPlate(plateId)
		selStat = '%s : %s' % (plate.selection, plate.selectionStatus)    # selection status string

		for readId in plate.get_readIdList():
			# construct a unique tag for each row of the table
			rowTag = '%s:%s' % (plateId, readId)
			condition = plate.getAssay(readId).get_condition()
			# construct the row
			plateRow = [plate.screenName, plate.batchName, plate.plateName, vpId2vpName[plate.get_virusPlateId()],
						selStat.upper(), condition]
			# add it to the table
			rowIdx = platePane.addRow(plateRow, rowTag)

			if progressBar != None:
				# increment the progress bar
				platePct += plateInc
				progressBar.setProgress(platePct)

	# set the selected row to the first row of the table
	platePane.table.getSelectionModel().setSelectionInterval(0, 0)
	# repaint the pane
	platePane.repaint()

	# reattach the listeners after the table is updated:
	for listener in listeners:
		tableModel.addListSelectionListener(listener)

	# set the analysis dataset to hte complete set of plates
	masterObject.setField('analysisPlateset', analysisSet)
	# normalize the data in the analysis set
	processAnalysisPlateset()

	# select the 'Normalization' tab:
	topWindow.selectTab('Plate Scoring')

# AD: not used (debugging)
def readPlateSetData(inFile):
	fin = open(inFile, 'r')
	plateSet = []
	while 1:
		line = fin.readline()
		if not line:
			break

		line = line.strip()

		if not len(line):
			continue

		fields = line.split('\t')
		plateSet.append(fields)

	fin.close()
	return plateSet

def normValidateAnalysis(dummy):
	# update the normalization, if necessary (ensures that the displayed data is current)
	if masterObject.getField('Update analysis'):
		processAnalysisPlateset()
		# indicate that hairpin scores need to be updated:
		masterObject.setField('Compute hairpin scores', 1)

def invalidatePlateAnalysis(dummy=None):
	# mark all data as neeing to be normalized
	analysisSet = masterObject.getField('analysisPlateset')
	if analysisSet == None:
		# if there is no data, return
		return

	# get the list of all plates in the analysis set
	aPlateList = analysisSet.getPlateIdList()
	for plateId in aPlateList:
		# loop over all plates
		plate = analysisSet.getPlate(plateId)
		readIdList = plate.get_readIdList()
		for readId in readIdList:
			# mark this assay as invalid (needing to be normalized)
			plate.invalidateNorm(readId)

def processAnalysisPlateset():
	# process/normalize all plates in the analysis plateset
	analysisSet = masterObject.getField('analysisPlateset')
	aPlateList = analysisSet.getPlateIdList()
	# !!!!!!!!! ieMin, ieMax should be able to be plate-specific
	# get the slope and absolute IE limits
	ieMin = masterObject.getField('IE min:')
	ieMax = masterObject.getField('IE max:')
	xMin = masterObject.getField('Low end cutoff:')

	# compute the IE mask for each plate
	for plateId in aPlateList:
		plate = analysisSet.getPlate(plateId)
		plate.setThresholds(ieMin, ieMax, xMin)
		plate.computeIeMask()

	# get the normalization method
	method = masterObject.getField('scoreMethod')
	# normalize all plates in the analysis plateset
	analysisSet.normalizePlates(method, ieMin, ieMax)
	# update the plate display:
	platePane = masterObject.getField('plateListPane')
	rowIdx = platePane.table.getSelectedRow()          # get the selected table row
	plateIdx = platePane.getRowKey(rowIdx)             # get the plate/assay index
	updatePlateMapDisplay(plateIdx, platePane)         # update the plate map to show the selected plate

	# indicate that analysis is up-to-date:
	masterObject.setField('Update analysis', 0)        # indicate that that the data is valid
	masterObject.setField('Compute hairpin scores', 1) # and that hairpin scores need to be computed (if necessary)

def columnSelect(evt, table):
	# get the index of the selected column:
	selectedColIdx = table.getTableHeader().columnAtPoint(evt.getPoint())
	
	# only re-sort if the selected column has changed:
	if selectedColIdx != masterObject.getField('columnSortIdx'):
		masterObject.setField('columnSortIdx', selectedColIdx)    # get the selected column

		# the table is contained within a JViewport, which is contained in the NormTablePane:
		tablePane = table.getParent().getParent()
		# if a row is selected, get the row key:
		rowKey = tablePane.getRowKey(tablePane.table.getSelectedRow())

		# sort the table on the selected columns
		tablePane.sortTableContents(selectedColIdx)

		# after the table is sorted, select the original row in its new position:
		keyRow = tablePane.getKeyRow(rowKey)
		if keyRow != -1:
			tablePane.table.setRowSelectionInterval(keyRow, keyRow)

		# and repaint the table pane
		plateVisUpdate(None, tablePane.table)		

# action listener that is fired when the Delete key is pressed if a table row is selected
def plateListKeyHandler(evt, table):
	# get the key event
	pString = evt.paramString()
	# split the event string into a list
	pFields = pString.split(',')
	keyChar = ''
	for field in pFields:
		if field.startswith('keyChar='):
			# convert any keyChar= strings to the bare key string:
			keyChar = field.replace('keyChar=', '')
			# and exit the loop with keyChar set to the selected key
			break

	# process only if the 'Delete' key was pressed and a row is selected:
	if keyChar == 'Delete' and table.getSelectedRow() != None:
		rowIdx = table.getSelectedRow()           # get the selected row
		tablePane = table.getParent().getParent() # get the table pane
		model = table.getModel()                  # ge tthe table model
		nRows = model.getRowCount()               # get the number of rows
		assayID = tablePane.getRowKey(rowIdx)     # get the row key
		plateID = assayID.split(':')[0]           # get the plate ID from the row key

		# get the analysis plateSet:
		analysisSet = masterObject.getField('analysisPlateset')
		useAssay = analysisSet.getUseAssay(assayID)   # get the 'use' flag for the assay
		# toggle plate removal:
		if useAssay == 1:
			# remove the plate from the set if it was in the set 
			analysisSet.setUseAssay(assayID, 0)
			thisPlate = tablePane.getRowKey(rowIdx)
			for row in range(nRows):
				# remove any assays for this plate
				thisPlate = tablePane.getRowKey(row)
				thisPlateID = thisPlate.split(':')[0]
				if thisPlateID == plateID:
					model.addFlaggedKey(thisPlate, row, Color.newColor(255, 200, 200)) # mark the row of the removed assay
					model.fireTableRowsUpdated(row, row)                               # repaint the table
		else:
			# add the plate back in, if it was removed from the set
			analysisSet.setUseAssay(assayID, 1)
			thisPlate = tablePane.getRowKey(rowIdx)
			for row in range(nRows):
				# restore all assays for this plate
				thisPlate = tablePane.getRowKey(row)
				thisPlateID = thisPlate.split(':')[0]
				if thisPlateID == plateID:
					model.removeFlaggedKey(thisPlate)          # unmark the row of the restored assay
					model.fireTableRowsUpdated(row, row)       # repaint the table

		# invalidate analysis and hairpin scores:
		masterObject.setField('Update analysis', 0)
		masterObject.setField('Compute hairpin scores', 1)

# update the plate display (action processor):
def plateVisUpdate(evt, table):
	if evt != None and evt.getValueIsAdjusting():
		return

	rowIdx = table.getSelectedRow()
	lastPlate = masterObject.getField('lastSelectedPlate')

	# the table is contained within a JViewport, which is contained in the NormTablePane:
	tablePane = table.getParent().getParent()
	plateID = tablePane.getRowKey(rowIdx)
	if plateID == lastPlate:
		return
	else:
		masterObject.setField('lastSelectedPlate', plateID)

	updatePlateMapDisplay(plateID, None)

# actual plate display updater:
def updatePlateMapDisplay(plateId, source):
	# if nothing is pointed to, point at element 0 (the first plate in the list):
	if plateId == -1:
		platePane = masterObject.getField('plateListPane')
		platePane.table.getSelectionModel().setSelectionInterval(0, 0)
		plateId = platePane.getRowKey(0)

	# This can only happen if the table is empty. If so, just return without doing anything
	# (This can happen if, for example, there are no puro- plates, and 'only selection -' is selected.
	# In that case, the last plate that was displayed will continue to be displayed.) 
	if plateId == -1:
		# need to display blank plates!!!!!
		return

	# the row key is plateId:readId. Extract the two fields...
	plateFields = plateId.split(':')
	plateId = plateFields[0]
	readId = plateFields[1]

	# get the plate from the analysis plateset
	plateSet = masterObject.getField('analysisPlateset')
	plate = plateSet.getPlate(plateId)

	# update the feature list:
	(featList, selectedFeatIdx) = plate.getFeatures(readId)    # get assay features
	pPane = masterObject.getField('parameterPane')             # get the list pane
	tableSelModel = pPane.table.getSelectionModel()	           # get selection model
	tableModel = pPane.table.getModel()				           # get the table model
	
	# Disable all listeners while the tab is being modified to keep the actionl listeners from firing continuously
	listeners = tableSelModel.getListSelectionListeners()	   # make a list of all listeners...
	for listener in listeners:
		tableSelModel.removeListSelectionListener(listener)    # ...and remove them temporarily

	pPane.clearList()					 # clear the list of assay features
	for feat in featList:				 # add assay features to the list
		fRow = [feat]
		pPane.addRow(fRow, feat)

	# set the highlighted feature to the selected feature
	pPane.table.getSelectionModel().setSelectionInterval(selectedFeatIdx, selectedFeatIdx)
	pPane.repaint()

	# reattach the listeners after the table is updated:
	for listener in listeners:
		tableSelModel.addListSelectionListener(listener)

	# update the plate maps:
	rawPanel = masterObject.getField('rawPlate')   # raw data platemap
	# set trim percentile for the raw platemap so outliers don't throw off the colormap (2%)
	rawPanel.setTrimPctile(2)
	cbRaw = masterObject.getField('cBarRaw')   # raw platemap colorbar
	# get the raw data for this plate and dsplay it in the plate map
	(rawData, valid) = plate.getAssayData(readId)
	(minVal, maxVal) = rawPanel.paintWells(rawData, plate, normColor=1)
	cbRaw.setRange(minVal, maxVal) # set the range for the colorbar

	normPanel = masterObject.getField('normPlate') # normalized data platemap
	# set trim percentile for the normalized platemap so outliers don't throw off the colormap (2%)
	normPanel.setTrimPctile(2)
	cbNrm = masterObject.getField('cBarNorm')  # normalized data colormap
	
	if masterObject.getField('scoreMethod') == 'Infection efficiency':
		# if displaying the IE data as the normalized data, get theIE data and display it 
		(minVal, maxVal) = normPanel.paintWells(plate.getIE(), plate, normColor=1)
	else:
		# othherwise, get the normalized data and display it
		(minVal, maxVal) = normPanel.paintWells(plate.getNorm(readId), plate, normColor=1)
	cbNrm.setRange(minVal, maxVal) # set the range for the colorbar

# AD: doesn't appear to be used
def adjustControlWellPane(nCtl, nqCtl):
	csBox = masterObject.getField('controlSelectBox')
	quad = masterObject.getField('quad')
	csButtons = csBox.buttonMap
	if (nCtl and quad == 'plate') or (nqCtl and quad == 'quadrant'):
		# at least one control well:
		masterObject.setField('controlWells', 'treat as hairpins')
		csButtons['treat as hairpins'].setEnabled(1)
		csButtons['use only for normalization'].setEnabled(1)
		csButtons['remove from analysis'].setEnabled(1)
	else:		 # no control wells for this plate
		csButtons['treat as hairpins'].setSelected(1)
		csButtons['use only for normalization'].setEnabled(0)
		csButtons['remove from analysis'].setEnabled(0)

# AD: not used (part of deprecated gene-level scoring on this tab)
def deactivateGeneSaveButton():
	masterObject.getField('saveGeneButton').setEnabled(0)
	grayed = Color.newColor(255, 32, 32)
	masterObject.getField('intensityMin').setDisabledTextColor(grayed)
	masterObject.getField('intensityMax').setDisabledTextColor(grayed)
	masterObject.getField('confidenceMin').setDisabledTextColor(grayed)
	masterObject.getField('confidenceMax').setDisabledTextColor(grayed)
	masterObject.getField('scoreParamPanel').repaint()

# AD: not used (part of deprecated gene-level scoring on this tab)
def activateGeneSaveButton():
	masterObject.getField('saveGeneButton').setEnabled(1)
	masterObject.getField('intensityMin').setDisabledTextColor(Color.BLACK)
	masterObject.getField('intensityMax').setDisabledTextColor(Color.BLACK)
	masterObject.getField('confidenceMin').setDisabledTextColor(Color.BLACK)
	masterObject.getField('confidenceMax').setDisabledTextColor(Color.BLACK)
	masterObject.getField('scoreParamPanel').repaint()

# make sure that the string is 'safe' for a .gct or .chip file
def safeCharacterString(string):
	safename = string.replace('@', '_')
	safename = safename.replace('#', '_')
	safename = safename.replace(' ', '_')
	safename = safename.replace('%', '_')
	safename = safename.replace('$', '_')
	safename = safename.replace(':', '_')
	safename = safename.replace('*', '_')
	safename = safename.replace('\\', '_')
	safename = safename.replace('/', '_')
	return safename
