SOFTWARE_VERSION='RNAeyes 3.3.1'

# The MasterObject contains unrestricted key-value pairs that can be accessed from anywhere 
# in the program. 
class MasterObject:
	def __init__(self, name):
		self.name = name
		self.fields = {}

	def setField(self, fName, fVal):
		# set a global variable value
		self.fields[fName] = fVal

	def getField(self, fName=None):
		# read the global variable value
		try:
			if fName:
				return self.fields[fName]
			else:
				return self.fields.keys()
		except:
			# if the name doesn't exist, return "None"
			return None

	def dumpKeys(self):
		# Mainly for debugging. prints a list of all of the keys contained in the object.
		print 'Keys for %s object:' % self.name
		keyList = self.fields.keys()
		for key in keyList:
			print '  %s' % key
			
# Global MasterObject:
masterObject = MasterObject("Big Kahuna")
masterObject.setField('Software version',SOFTWARE_VERSION)
masterObject.setField('Update analysis',1)
masterObject.setField('Compute hairpin scores', 1)

def addToMasterObject(kvpList):
	# function to allow a list of key-value pairs to be set in the masterObject
	for kvp in kvpList:
		masterObject.setField(kvp[0],kvp[1])
		
