/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.VLSNCache;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TinyHashSet;
import com.sleepycat.je.utilint.VLSN;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIN
extends IN
implements Loggable {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    private final TinyHashSet<CursorImpl> cursorSet = new TinyHashSet();
    private long lastDeltaVersion = -1L;
    private int numDeltasSinceLastFull;
    private boolean prohibitNextDelta;
    private VLSNCache vlsnCache = VLSNCache.EMPTY_CACHE;

    public BIN() {
        this.numDeltasSinceLastFull = 0;
        this.prohibitNextDelta = false;
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
        this.numDeltasSinceLastFull = 0;
        this.prohibitNextDelta = false;
    }

    public BIN(SizeofMarker marker) {
        super(marker);
        this.vlsnCache = null;
    }

    public long getVLSN(int idx, boolean allowFetch) {
        LN ln = (LN)this.getTarget(idx);
        if (ln != null) {
            return ln.getVLSNSequence();
        }
        long vlsn = this.vlsnCache.get(idx);
        if (!VLSN.isNull(vlsn)) {
            return vlsn;
        }
        if (!allowFetch) {
            return vlsn;
        }
        ln = (LN)this.fetchTarget(idx);
        return ln.getVLSNSequence();
    }

    public VLSNCache getVLSNCache() {
        return this.vlsnCache;
    }

    @Override
    void setTarget(int idx, Node target) {
        Node oldTarget;
        if (target == null && (oldTarget = this.getTarget(idx)) instanceof LN) {
            long val = ((LN)oldTarget).getVLSNSequence();
            this.vlsnCache = this.vlsnCache.set(idx, val, this);
        }
        super.setTarget(idx, target);
    }

    @Override
    void copyEntry(int idx, IN from2, int fromIdx) {
        super.copyEntry(idx, from2, fromIdx);
        long vlsn = ((BIN)from2).vlsnCache.get(fromIdx);
        this.vlsnCache = this.vlsnCache.set(idx, vlsn, this);
    }

    @Override
    void copyEntries(int from2, int to2, int n) {
        super.copyEntries(from2, to2, n);
        this.vlsnCache = this.vlsnCache.copy(from2, to2, n);
    }

    @Override
    void clearEntry(int idx) {
        super.clearEntry(idx);
        this.vlsnCache = this.vlsnCache.set(idx, VLSN.NULL_VLSN.getSequence(), this);
    }

    @Override
    public long computeMemorySize() {
        if (this.vlsnCache == null) {
            return super.computeMemorySize();
        }
        return super.computeMemorySize() + this.vlsnCache.getMemorySize();
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public boolean isBIN() {
        return true;
    }

    @Override
    void setLastLoggedLsn(long lsn) {
        if (this.getLastFullVersion() == -1L) {
            this.setLastFullLsn(lsn);
        } else {
            this.lastDeltaVersion = lsn;
        }
    }

    @Override
    public long getLastLoggedVersion() {
        return this.lastDeltaVersion != -1L ? this.lastDeltaVersion : this.getLastFullVersion();
    }

    @Override
    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    @Override
    public void setProhibitNextDelta() {
        this.prohibitNextDelta = true;
    }

    @Override
    protected boolean isEvictionProhibited() {
        return this.nCursors() > 0;
    }

    @Override
    boolean hasPinnedChildren() {
        DatabaseImpl db = this.getDatabase();
        if (db.getId().equals(DbTree.ID_DB_ID)) {
            return this.hasResidentChildren();
        }
        return false;
    }

    @Override
    int getChildEvictionType() {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            if (node instanceof LN) {
                LN ln = (LN)node;
                if (!ln.isEvictableInexact()) {
                    return 0;
                }
                if (!cleaner.isEvictable(this, i, false)) continue;
                return 1;
            }
            return 0;
        }
        return 2;
    }

    @Override
    boolean entryZeroKeyComparesLow() {
        return false;
    }

    @Override
    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        LN oldLN = (LN)this.getTarget(index);
        this.updateMemorySize(oldLN, null);
        if (oldLN != null) {
            oldLN.releaseMemoryBudget();
        }
        this.setMigrate(index, false);
        this.setTarget(index, null);
        this.setDirty(true);
    }

    public void setKnownDeletedClearAll(int index) {
        this.setKnownDeleted(index);
        this.setLsnElement(index, -1L);
    }

    @Override
    public void clearKnownDeleted(int index) {
        super.clearKnownDeleted(index);
        this.setDirty(true);
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.BIN_FIXED_OVERHEAD;
    }

    @Override
    public long getTreeAdminMemorySize() {
        if (this.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            long treeAdminMem = 0L;
            for (int i = 0; i < this.getMaxEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null) continue;
                MapLN mapLN = (MapLN)n;
                treeAdminMem += mapLN.getDatabase().getTreeAdminMemory();
            }
            return treeAdminMem;
        }
        return 0L;
    }

    public Set<CursorImpl> getCursorSet() {
        return this.cursorSet.copy();
    }

    public void addCursor(CursorImpl cursor) {
        assert (this.isLatchOwnerForWrite());
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        assert (this.isLatchOwnerForWrite());
        this.cursorSet.remove(cursor);
    }

    public int nCursors() {
        return this.cursorSet.size();
    }

    @Override
    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    @Override
    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        assert (newSibling.isLatchOwnerForWrite());
        assert (this.isLatchOwnerForWrite());
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator<CursorImpl> iter2 = this.cursorSet.iterator();
        while (iter2.hasNext()) {
            CursorImpl cursor = iter2.next();
            if (cursor.getBINToBeRemoved() == this) continue;
            int cIdx = cursor.getIndex();
            BIN cBin = cursor.getBIN();
            assert (cBin == this) : "nodeId=" + this.getNodeId() + " cursor=" + cursor.dumpToString(true);
            assert (newSibling instanceof BIN);
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    iter2.remove();
                    cursor.setBIN(ns);
                    ns.addCursor(cursor);
                    continue;
                }
                cursor.setIndex(cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            cursor.setIndex(cIdx - newSiblingLow);
            iter2.remove();
            cursor.setBIN(ns);
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet != null) {
            for (CursorImpl cursor : this.cursorSet) {
                if (cursor.getBINToBeRemoved() == this) continue;
                BIN cBin = cursor.getBIN();
                assert (cBin == this);
            }
        }
    }

    @Override
    void adjustCursorsForInsert(int insertIndex) {
        assert (this.isLatchOwnerForWrite());
        if (this.cursorSet != null) {
            for (CursorImpl cursor : this.cursorSet) {
                int cIdx;
                if (cursor.getBINToBeRemoved() == this || insertIndex > (cIdx = cursor.getIndex())) continue;
                cursor.setIndex(cIdx + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compress(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!this.databaseImpl.getDbEnvironment().isValid()) {
            return false;
        }
        if (this.nCursors() > 0) {
            throw EnvironmentFailureException.unexpectedState();
        }
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Object var12_11;
            BasicLocker lockingTxn;
            block17: {
                block15: {
                    if (!this.isEntryPendingDeleted(i) && !this.isEntryKnownDeleted(i)) continue;
                    lockingTxn = BasicLocker.createBasicLocker(envImpl);
                    lockingTxn.setPreemptable(false);
                    try {
                        LN ln;
                        LockResult lockRet;
                        long lsn = this.getLsn(i);
                        if (lsn != -1L && (lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, db)).getLockGrant() == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            var12_11 = null;
                            break block15;
                        }
                        if (Key.compareKeys(this.getKey(i), this.getIdentifierKey(), this.getKeyComparator()) == 0) {
                            setNewIdKey = true;
                        }
                        if (db.isDeferredWriteMode() && (ln = (LN)this.getTarget(i)) != null && ln.isDirty() && !DbLsn.isTransient(lsn)) {
                            if (db.isTemporary()) {
                                if (localTracker != null) {
                                    localTracker.countObsoleteNode(lsn, ln.getGenericLogType(), ln.getLastLoggedSize(), db);
                                } else {
                                    envImpl.getLogManager().countObsoleteNode(lsn, ln.getGenericLogType(), ln.getLastLoggedSize(), db, true);
                                }
                            } else {
                                this.logDirtyLN(i, ln, false);
                            }
                        }
                        boolean deleteSuccess = this.deleteEntry(i, true);
                        assert (deleteSuccess);
                        --i;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        lockingTxn.operationEnd();
                        throw throwable;
                    }
                }
                lockingTxn.operationEnd();
                continue;
            }
            var12_11 = null;
            lockingTxn.operationEnd();
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.setGeneration(0L);
        }
        if (anyLocksDenied) return false;
        return true;
    }

    public void queueSlotDeletion() {
        if (this.shouldLogDelta()) {
            this.setDirty(true);
            return;
        }
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        envImpl.addToCompressorQueue(this, false);
    }

    @Override
    public boolean isCompressible() {
        return true;
    }

    public long evictLNs() throws DatabaseException {
        assert (this.isLatchOwnerForWrite()) : "BIN must be latched before evicting LNs";
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = 0L;
        if (this.nCursors() == 0) {
            for (int i = 0; i < this.getNEntries(); ++i) {
                removed += this.evictInternal(i, cleaner);
            }
            this.updateMemorySize(removed, 0L);
        }
        if (removed > 0L) {
            this.compactMemory();
        }
        return removed;
    }

    public void evictLN(int index) throws DatabaseException {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = this.evictInternal(index, cleaner);
        this.updateMemorySize(removed, 0L);
        if (removed > 0L) {
            this.compactMemory();
        }
    }

    private long evictInternal(int index, Cleaner cleaner) throws DatabaseException {
        long lsn;
        LN ln;
        Node n = this.getTarget(index);
        if (n instanceof LN && (ln = (LN)n).isEvictable(lsn = this.getLsn(index)) && cleaner.isEvictable(this, index, true)) {
            this.logDirtyLN(index, ln, true);
            this.setTarget(index, null);
            ln.releaseMemoryBudget();
            return n.getMemorySizeIncludedByParent();
        }
        return 0L;
    }

    private void logDirtyLN(int index, LN ln, boolean ensureDurableLsn) throws DatabaseException {
        boolean force;
        long oldLsn = this.getLsn(index);
        boolean bl = force = ensureDurableLsn && this.getDatabase().isDeferredWriteMode() && DbLsn.isTransientOrNull(oldLsn);
        if (force || ln.isDirty()) {
            DatabaseImpl dbImpl = this.getDatabase();
            EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
            assert (dbImpl.isDeferredWriteMode());
            long newLsn = ln.log(envImpl, dbImpl, this.getKey(index), oldLsn, true, ReplicationContext.NO_REPLICATE);
            this.updateEntry(index, newLsn);
            CursorImpl.lockAfterLsnChange(dbImpl, oldLsn, newLsn, null);
        }
    }

    @Override
    boolean validateSubtreeBeforeDelete(int index) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidForDelete() throws DatabaseException {
        boolean bl;
        boolean needToLatch;
        block10: {
            block9: {
                int validIndex = 0;
                int numValidEntries = 0;
                needToLatch = !this.isLatchOwnerForWrite();
                try {
                    if (needToLatch) {
                        this.latch();
                    }
                    for (int i = 0; i < this.getNEntries(); ++i) {
                        if (this.isEntryKnownDeleted(i)) continue;
                        ++numValidEntries;
                        validIndex = i;
                    }
                    if (numValidEntries <= 0) break block9;
                    bl = false;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var6_8 = null;
                        if (!needToLatch || !this.isLatchOwnerForWrite()) break block11;
                        this.releaseLatch();
                    }
                    throw throwable;
                }
                if (needToLatch && this.isLatchOwnerForWrite()) {
                    this.releaseLatch();
                }
                return bl;
            }
            if (this.nCursors() <= 0) break block10;
            bl = false;
            Object var6_6 = null;
            if (needToLatch && this.isLatchOwnerForWrite()) {
                this.releaseLatch();
            }
            return bl;
        }
        bl = true;
        Object var6_7 = null;
        if (needToLatch && this.isLatchOwnerForWrite()) {
            this.releaseLatch();
        }
        return bl;
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public void logDirtyChildren() throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            this.logDirtyLN(i, (LN)node, true);
        }
    }

    @Override
    public void incEvictStats(Evictor.EvictionSource source) {
        this.databaseImpl.getDbEnvironment().getEvictor().incBINEvictStats(source);
    }

    @Override
    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incBINFetchStats(isMiss);
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    @Override
    public String shortClassName() {
        return "BIN";
    }

    @Override
    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) {
        BINDelta deltaInfo;
        boolean doDeltaLog;
        DatabaseImpl dbImpl = this.getDatabase();
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        envImpl.getCleaner().lazyMigrateLNs(this, context.backgroundIO);
        if (context.allowDeltas && this.shouldLogDelta()) {
            doDeltaLog = true;
            deltaInfo = new BINDelta(this);
        } else {
            doDeltaLog = false;
            deltaInfo = null;
        }
        if (context.allowCompress && !doDeltaLog) {
            envImpl.lazyCompress(this);
        }
        if (dbImpl.isDeferredWriteMode()) {
            this.logDirtyLNs();
        }
        item.isDelta = doDeltaLog;
        this.beforeLogCommon(item, context, doDeltaLog ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        item.entry = doDeltaLog ? new BINDeltaLogEntry(deltaInfo) : new INLogEntry(this);
    }

    @Override
    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) {
        this.afterLogCommon(logManager, item, context, item.isDelta ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        if (item.isDelta) {
            this.lastDeltaVersion = item.newLsn;
            ++this.numDeltasSinceLastFull;
        } else {
            this.setLastFullLsn(item.newLsn);
            this.lastDeltaVersion = -1L;
            this.numDeltasSinceLastFull = 0;
            for (int i = 0; i < this.getNEntries(); ++i) {
                if (!this.isEntryKnownDeleted(i) && !this.isEntryPendingDeleted(i)) continue;
                this.queueSlotDeletion();
                break;
            }
        }
        this.prohibitNextDelta = false;
    }

    private void logDirtyLNs() throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || !(node instanceof LN)) continue;
            this.logDirtyLN(i, (LN)node, true);
        }
    }

    public boolean shouldLogDelta() {
        DatabaseImpl dbImpl = this.getDatabase();
        if (this.prohibitNextDelta || dbImpl.isDeferredWriteMode() || this.getLastFullVersion() == -1L || this.numDeltasSinceLastFull >= dbImpl.getBinMaxDeltas()) {
            return false;
        }
        int numDeltas = BINDelta.getNumDeltas(this);
        if (numDeltas <= 0) {
            return false;
        }
        int maxDiffs = this.getNEntries() * dbImpl.getBinDeltaPercent() / 100;
        return numDeltas <= maxDiffs;
    }

    @Override
    public Node fetchTarget(int idx) throws DatabaseException {
        try {
            return super.fetchTarget(idx);
        }
        catch (RelatchRequiredException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }
}

