/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RawAccessor
implements Accessor {
    private Format parentFormat;
    private Accessor superAccessor;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private boolean isCompositeKey;

    RawAccessor(Format parentFormat, Accessor superAccessor, FieldInfo priKeyField, List<FieldInfo> secKeyFields, List<FieldInfo> nonKeyFields) {
        this.parentFormat = parentFormat;
        this.superAccessor = superAccessor;
        this.priKeyField = priKeyField;
        this.secKeyFields = secKeyFields;
        this.nonKeyFields = nonKeyFields;
    }

    RawAccessor(Format parentFormat, List<FieldInfo> nonKeyFields) {
        this.parentFormat = parentFormat;
        this.nonKeyFields = nonKeyFields;
        this.secKeyFields = Collections.emptyList();
        this.isCompositeKey = true;
    }

    @Override
    public Object newInstance() {
        RawObject superObject = this.superAccessor != null ? (RawObject)this.superAccessor.newInstance() : null;
        return new RawObject(this.parentFormat, new HashMap<String, Object>(), superObject);
    }

    @Override
    public Object newArray(int len) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object o) {
        if (this.priKeyField != null) {
            Object val = this.getValue(o, this.priKeyField);
            Format format2 = this.priKeyField.getType();
            if (format2.isPrimitive()) {
                return ((Number)val).longValue() == 0L;
            }
            return val == null;
        }
        if (this.superAccessor != null) {
            return this.superAccessor.isPriKeyFieldNullOrZero(this.getSuper(o));
        }
        throw DbCompat.unexpectedState("No primary key field");
    }

    @Override
    public void writePriKeyField(Object o, EntityOutput output) throws RefreshException {
        if (this.priKeyField != null) {
            Object val = this.getValue(o, this.priKeyField);
            Format format2 = this.priKeyField.getType();
            output.writeKeyObject(val, format2);
        } else if (this.superAccessor != null) {
            this.superAccessor.writePriKeyField(this.getSuper(o), output);
        } else {
            throw DbCompat.unexpectedState("No primary key field");
        }
    }

    @Override
    public void readPriKeyField(Object o, EntityInput input2) throws RefreshException {
        if (this.priKeyField != null) {
            Format format2 = this.priKeyField.getType();
            Object val = input2.readKeyObject(format2);
            this.setValue(o, this.priKeyField, val);
        } else if (this.superAccessor != null) {
            this.superAccessor.readPriKeyField(this.getSuper(o), input2);
        } else {
            throw DbCompat.unexpectedState("No primary key field");
        }
    }

    @Override
    public void writeSecKeyFields(Object o, EntityOutput output) throws RefreshException {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive() && this.priKeyField.getType().getId() != 18) {
            output.registerPriKeyObject(this.getValue(o, this.priKeyField));
        }
        if (this.superAccessor != null) {
            this.superAccessor.writeSecKeyFields(this.getSuper(o), output);
        }
        for (int i = 0; i < this.secKeyFields.size(); ++i) {
            this.writeField(o, this.secKeyFields.get(i), output);
        }
    }

    @Override
    public void readSecKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive() && this.priKeyField.getType().getId() != 18) {
            input2.registerPriKeyObject(this.getValue(o, this.priKeyField));
        } else if (this.priKeyField != null && this.priKeyField.getType().getId() == 18) {
            input2.registerPriStringKeyObject(this.getValue(o, this.priKeyField));
        }
        if (superLevel != 0 && this.superAccessor != null) {
            this.superAccessor.readSecKeyFields(this.getSuper(o), input2, startField, endField, superLevel - 1);
        } else if (superLevel > 0) {
            throw DbCompat.unexpectedState("Super class does not exist");
        }
        if (superLevel <= 0) {
            for (int i = startField; i <= endField && i < this.secKeyFields.size(); ++i) {
                this.readField(o, this.secKeyFields.get(i), input2);
            }
        }
    }

    @Override
    public void writeNonKeyFields(Object o, EntityOutput output) throws RefreshException {
        if (this.superAccessor != null) {
            this.superAccessor.writeNonKeyFields(this.getSuper(o), output);
        }
        for (int i = 0; i < this.nonKeyFields.size(); ++i) {
            this.writeField(o, this.nonKeyFields.get(i), output);
        }
    }

    @Override
    public void readNonKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        if (superLevel != 0 && this.superAccessor != null) {
            this.superAccessor.readNonKeyFields(this.getSuper(o), input2, startField, endField, superLevel - 1);
        } else if (superLevel > 0) {
            throw DbCompat.unexpectedState("Super class does not exist");
        }
        if (superLevel <= 0) {
            for (int i = startField; i <= endField && i < this.nonKeyFields.size(); ++i) {
                this.readField(o, this.nonKeyFields.get(i), input2);
            }
        }
    }

    @Override
    public void writeCompositeKeyFields(Object o, EntityOutput output) throws RefreshException {
        for (int i = 0; i < this.nonKeyFields.size(); ++i) {
            this.writeField(o, this.nonKeyFields.get(i), output);
        }
    }

    @Override
    public void readCompositeKeyFields(Object o, EntityInput input2) throws RefreshException {
        for (int i = 0; i < this.nonKeyFields.size(); ++i) {
            this.readField(o, this.nonKeyFields.get(i), input2);
        }
    }

    @Override
    public Object getField(Object o, int field2, int superLevel, boolean isSecField) {
        if (superLevel > 0) {
            return this.superAccessor.getField(this.getSuper(o), field2, superLevel - 1, isSecField);
        }
        FieldInfo fld = isSecField ? this.secKeyFields.get(field2) : this.nonKeyFields.get(field2);
        return this.getValue(o, fld);
    }

    @Override
    public void setField(Object o, int field2, int superLevel, boolean isSecField, Object value) {
        if (superLevel > 0) {
            this.superAccessor.setField(this.getSuper(o), field2, superLevel - 1, isSecField, value);
            return;
        }
        FieldInfo fld = isSecField ? this.secKeyFields.get(field2) : this.nonKeyFields.get(field2);
        this.setValue(o, fld, value);
    }

    @Override
    public void setPriField(Object o, Object value) {
        if (this.priKeyField != null) {
            this.setValue(o, this.priKeyField, value);
        } else if (this.superAccessor != null) {
            this.superAccessor.setPriField(this.getSuper(o), value);
        } else {
            throw DbCompat.unexpectedState("No primary key field");
        }
    }

    private RawObject getSuper(Object o) {
        return ((RawObject)o).getSuper();
    }

    private Object getValue(Object o, FieldInfo field2) {
        return ((RawObject)o).getValues().get(field2.getName());
    }

    private void setValue(Object o, FieldInfo field2, Object val) {
        ((RawObject)o).getValues().put(field2.getName(), val);
    }

    private void writeField(Object o, FieldInfo field2, EntityOutput output) throws RefreshException {
        Object val = this.getValue(o, field2);
        Format format2 = field2.getType();
        if (this.isCompositeKey || format2.isPrimitive()) {
            output.writeKeyObject(val, format2);
        } else if (format2.getId() == 18) {
            output.writeString((String)val);
        } else {
            output.writeObject(val, format2);
        }
    }

    private void readField(Object o, FieldInfo field2, EntityInput input2) throws RefreshException {
        Format format2 = field2.getType();
        Object val = this.isCompositeKey || format2.isPrimitive() ? input2.readKeyObject(format2) : (format2.getId() == 18 ? input2.readStringObject() : input2.readObject());
        this.setValue(o, field2, val);
    }

    public FieldInfo getPriKeyField() {
        return this.priKeyField;
    }
}

