/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class FastqReader
implements Iterator<FastqRecord>,
Iterable<FastqRecord>,
Closeable {
    private final File fastqFile;
    private final BufferedReader reader;
    private FastqRecord nextRecord;
    private int line = 1;

    public FastqReader(File file) {
        try {
            this.fastqFile = file;
            this.reader = IoUtil.openFileForBufferedReading(this.fastqFile);
            this.nextRecord = this.readNextRecord();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public FastqReader(BufferedReader bufferedReader) {
        this(null, bufferedReader);
    }

    public FastqReader(File file, BufferedReader bufferedReader) {
        this.fastqFile = file;
        this.reader = bufferedReader;
        this.nextRecord = this.readNextRecord();
    }

    private FastqRecord readNextRecord() {
        try {
            String string2 = this.reader.readLine();
            if (string2 == null) {
                return null;
            }
            if (StringUtil.isBlank(string2)) {
                throw new PicardException(this.error("Missing sequence header"));
            }
            if (!string2.startsWith("@")) {
                throw new PicardException(this.error("Sequence header must start with @: " + string2));
            }
            String string3 = this.reader.readLine();
            this.checkLine(string3, "sequence line");
            String string4 = this.reader.readLine();
            this.checkLine(string4, "quality header");
            if (!string4.startsWith("+")) {
                throw new PicardException(this.error("Quality header must start with +: " + string4));
            }
            String string5 = this.reader.readLine();
            this.checkLine(string5, "quality line");
            if (string3.length() != string5.length()) {
                throw new PicardException(this.error("Sequence and quality line must be the same length"));
            }
            FastqRecord fastqRecord = new FastqRecord(string2.substring(1, string2.length()), string3, string4.substring(1, string4.length()), string5);
            this.line += 4;
            return fastqRecord;
        }
        catch (IOException iOException) {
            throw new PicardException(String.format("Error reading fastq '%s'", this.getAbsolutePath()), iOException);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public FastqRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when !hasNext()");
        }
        FastqRecord fastqRecord = this.nextRecord;
        this.nextRecord = this.readNextRecord();
        return fastqRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public Iterator<FastqRecord> iterator() {
        return this;
    }

    public int getLineNumber() {
        return this.line;
    }

    public File getFile() {
        return this.fastqFile;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new PicardException("IO problem in fastq file " + this.getAbsolutePath(), iOException);
        }
    }

    private void checkLine(String string2, String string3) {
        if (string2 == null) {
            throw new PicardException(this.error("File is too short - missing " + string3 + " line"));
        }
        if (StringUtil.isBlank(string2)) {
            throw new PicardException(this.error("Missing " + string3));
        }
    }

    private String error(String string2) {
        return string2 + " at line " + this.line + " in fastq " + this.getAbsolutePath();
    }

    private String getAbsolutePath() {
        if (this.fastqFile == null) {
            return "";
        }
        return this.fastqFile.getAbsolutePath();
    }
}

