/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.FileAppendStreamLRUCache;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;

public class CoordinateSortedPairInfoMap<KEY, REC>
implements Iterable<Map.Entry<KEY, REC>> {
    private final int INVALID_SEQUENCE_INDEX = -2;
    private final File workDir = IoUtil.createTempDir("CSPI.", null);
    private int sequenceIndexOfMapInRam = -2;
    private Map<KEY, REC> mapInRam = null;
    private final FileAppendStreamLRUCache outputStreams;
    private final Codec<KEY, REC> elementCodec;
    private final Map<Integer, Integer> sizeOfMapOnDisk = new HashMap<Integer, Integer>();
    private boolean iterationInProgress = false;

    CoordinateSortedPairInfoMap(int n, Codec<KEY, REC> codec) {
        this.elementCodec = codec;
        this.workDir.deleteOnExit();
        this.outputStreams = new FileAppendStreamLRUCache(n);
    }

    public REC remove(int n, KEY KEY) {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        this.ensureSequenceLoaded(n);
        return this.mapInRam.remove(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSequenceLoaded(int n) {
        block15: {
            try {
                Object object;
                File file;
                block16: {
                    if (this.sequenceIndexOfMapInRam == n) {
                        return;
                    }
                    if (this.mapInRam != null) {
                        file = this.makeFileForSequence(this.sequenceIndexOfMapInRam);
                        if (file.exists()) {
                            throw new IllegalStateException(file + " should not exist.");
                        }
                        if (!this.mapInRam.isEmpty()) {
                            object = this.getOutputStreamForSequence(this.sequenceIndexOfMapInRam);
                            this.elementCodec.setOutputStream((OutputStream)object);
                            for (Map.Entry<KEY, REC> entry : this.mapInRam.entrySet()) {
                                this.elementCodec.encode(entry.getKey(), entry.getValue());
                            }
                            this.sizeOfMapOnDisk.put(this.sequenceIndexOfMapInRam, this.mapInRam.size());
                            this.mapInRam.clear();
                        }
                    } else {
                        this.mapInRam = new HashMap<KEY, REC>();
                    }
                    this.sequenceIndexOfMapInRam = n;
                    file = this.makeFileForSequence(n);
                    if (this.outputStreams.containsKey(file)) {
                        ((FileOutputStream)this.outputStreams.remove(file)).close();
                    }
                    object = this.sizeOfMapOnDisk.remove(n);
                    if (!file.exists()) break block16;
                    if (object == null) {
                        throw new IllegalStateException("null numRecords for " + file);
                    }
                    Object object2 = null;
                    try {
                        object2 = new FileInputStream(file);
                        this.elementCodec.setInputStream((InputStream)object2);
                        for (int i = 0; i < (Integer)object; ++i) {
                            Map.Entry<KEY, REC> entry = this.elementCodec.decode();
                            if (this.mapInRam.containsKey(entry.getKey())) {
                                throw new PicardException("Value was put into PairInfoMap more than once.  " + n + ": " + entry.getKey());
                            }
                            this.mapInRam.put(entry.getKey(), entry.getValue());
                        }
                    }
                    catch (Throwable throwable) {
                        CloserUtil.close(object2);
                        throw throwable;
                    }
                    CloserUtil.close(object2);
                    IOUtil.deleteFiles(file);
                    break block15;
                }
                if (object != null && (Integer)object > 0) {
                    throw new IllegalStateException("Non-zero numRecords but " + file + " does not exist");
                }
            }
            catch (IOException iOException) {
                throw new PicardException("Error loading new map from disk.", iOException);
            }
        }
    }

    public void put(int n, KEY KEY, REC REC) {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        if (n == this.sequenceIndexOfMapInRam) {
            if (this.mapInRam.containsKey(KEY)) {
                throw new IllegalArgumentException("Putting value into PairInfoMap that already existed. " + n + ": " + KEY);
            }
            this.mapInRam.put(KEY, REC);
        } else {
            OutputStream outputStream = this.getOutputStreamForSequence(n);
            this.elementCodec.setOutputStream(outputStream);
            this.elementCodec.encode(KEY, REC);
            Integer n2 = this.sizeOfMapOnDisk.get(n);
            if (n2 == null) {
                n2 = 0;
            }
            this.sizeOfMapOnDisk.put(n, n2 + 1);
        }
    }

    private File makeFileForSequence(int n) {
        File file = new File(this.workDir, n + ".tmp");
        file.deleteOnExit();
        return file;
    }

    private OutputStream getOutputStreamForSequence(int n) {
        return (OutputStream)this.outputStreams.get(this.makeFileForSequence(n));
    }

    public int size() {
        int n = this.sizeInRam();
        for (Integer n2 : this.sizeOfMapOnDisk.values()) {
            if (n2 == null) continue;
            n += n2.intValue();
        }
        return n;
    }

    public int sizeInRam() {
        return this.mapInRam != null ? this.mapInRam.size() : 0;
    }

    @Override
    public CloseableIterator<Map.Entry<KEY, REC>> iterator() {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        this.iterationInProgress = true;
        return new MapIterator();
    }

    static /* synthetic */ Map access$100(CoordinateSortedPairInfoMap coordinateSortedPairInfoMap) {
        return coordinateSortedPairInfoMap.sizeOfMapOnDisk;
    }

    public static interface Codec<KEY, REC> {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(KEY var1, REC var2);

        public Map.Entry<KEY, REC> decode();
    }

    private class MapIterator
    implements CloseableIterator<Map.Entry<KEY, REC>> {
        private boolean closed = false;
        private Set<Integer> referenceIndices = new HashSet(CoordinateSortedPairInfoMap.access$100(CoordinateSortedPairInfoMap.this).keySet());
        private final Iterator<Integer> referenceIndexIterator;
        private Iterator<Map.Entry<KEY, REC>> currentReferenceIterator = null;

        private MapIterator() {
            if (CoordinateSortedPairInfoMap.this.sequenceIndexOfMapInRam != -2) {
                this.referenceIndices.add(CoordinateSortedPairInfoMap.this.sequenceIndexOfMapInRam);
            }
            this.referenceIndexIterator = this.referenceIndices.iterator();
            this.advanceToNextNonEmptyReferenceIndex();
        }

        private void advanceToNextNonEmptyReferenceIndex() {
            while (this.referenceIndexIterator.hasNext()) {
                int n = this.referenceIndexIterator.next();
                CoordinateSortedPairInfoMap.this.ensureSequenceLoaded(n);
                if (CoordinateSortedPairInfoMap.this.mapInRam.isEmpty()) continue;
                this.createIteratorForMapInRam();
                return;
            }
            this.currentReferenceIterator = null;
        }

        private void createIteratorForMapInRam() {
            this.currentReferenceIterator = CoordinateSortedPairInfoMap.this.mapInRam.entrySet().iterator();
        }

        @Override
        public void close() {
            this.closed = true;
            CoordinateSortedPairInfoMap.this.iterationInProgress = false;
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            if (this.currentReferenceIterator != null && !this.currentReferenceIterator.hasNext()) {
                throw new IllegalStateException("Should not happen");
            }
            return this.currentReferenceIterator != null;
        }

        @Override
        public Map.Entry<KEY, REC> next() {
            if (this.closed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry entry = this.currentReferenceIterator.next();
            if (!this.currentReferenceIterator.hasNext()) {
                this.advanceToNextNonEmptyReferenceIndex();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

