/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;

public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="SD", doc="Sequence dictionary to use when indexing the VCF.", optional=true)
    public File SEQUENCE_DICTIONARY;
    private static final Set<String> NO_SAMPLES = Collections.emptySet();

    public static void main(String[] stringArray) {
        new MakeSitesOnlyVcf().instanceMainWithExit(stringArray);
    }

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sAMSequenceDictionary;
        IoUtil.assertFileIsReadable(this.INPUT);
        if (this.SEQUENCE_DICTIONARY != null) {
            IoUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY);
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT);
        VCFHeader vCFHeader = new VCFHeader(vCFFileReader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sAMSequenceDictionary2 = sAMSequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create(this.OUTPUT, sAMSequenceDictionary, enumSet);
        variantContextWriter.writeHeader(vCFHeader);
        ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        Iterator iterator2 = vCFFileReader.iterator();
        while (iterator2.hasNext()) {
            VariantContext variantContext = (VariantContext)iterator2.next();
            variantContextWriter.add(variantContext.subContextFromSamples(NO_SAMPLES, false));
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        CloserUtil.close(iterator2);
        CloserUtil.close(vCFFileReader);
        variantContextWriter.close();
        return 0;
    }
}

