/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTagUtil;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.AsciiWriter;
import net.sf.samtools.util.RuntimeIOException;

public class SAMTextWriter
extends SAMFileWriterImpl {
    private static final String FIELD_SEPARATOR = "\t";
    private final Writer out;
    private final File file;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private final SAMTagUtil tagUtil = new SAMTagUtil();
    private static SAMTextWriter textWriter = null;
    private static StringWriter stringWriter = null;

    public SAMTextWriter(Writer writer) {
        this.out = writer;
        this.file = null;
    }

    public SAMTextWriter(File file) {
        try {
            this.file = file;
            this.out = new AsciiWriter(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public SAMTextWriter(OutputStream outputStream) {
        this.file = null;
        this.out = new AsciiWriter(outputStream);
    }

    @Override
    public void writeAlignment(SAMRecord sAMRecord) {
        try {
            this.out.write(sAMRecord.getReadName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(sAMRecord.getFlags()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(sAMRecord.getReferenceName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(sAMRecord.getAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(sAMRecord.getMappingQuality()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(sAMRecord.getCigarString());
            this.out.write(FIELD_SEPARATOR);
            if (sAMRecord.getReferenceName() == sAMRecord.getMateReferenceName() && "*" != sAMRecord.getReferenceName()) {
                this.out.write("=");
            } else {
                this.out.write(sAMRecord.getMateReferenceName());
            }
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(sAMRecord.getMateAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(sAMRecord.getInferredInsertSize()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(sAMRecord.getReadString());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(sAMRecord.getBaseQualityString());
            for (SAMBinaryTagAndValue sAMBinaryTagAndValue = sAMRecord.getBinaryAttributes(); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
                this.out.write(FIELD_SEPARATOR);
                String string2 = sAMBinaryTagAndValue.isUnsignedArray() ? this.tagCodec.encodeUnsignedArray(this.tagUtil.makeStringTag(sAMBinaryTagAndValue.tag), sAMBinaryTagAndValue.value) : this.tagCodec.encode(this.tagUtil.makeStringTag(sAMBinaryTagAndValue.tag), sAMBinaryTagAndValue.value);
                this.out.write(string2);
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    static synchronized String getSAMString(SAMRecord sAMRecord) {
        if (stringWriter == null) {
            stringWriter = new StringWriter();
        }
        if (textWriter == null) {
            textWriter = new SAMTextWriter(stringWriter);
        }
        stringWriter.getBuffer().setLength(0);
        textWriter.writeAlignment(sAMRecord);
        return stringWriter.toString();
    }

    @Override
    public void writeHeader(String string2) {
        try {
            this.out.write(string2);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public void finish() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public String getFilename() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }
}

