/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.BarcodeProcessor;
import org.broadinstitute.rnai.poolq.api.PoolQ;
import org.broadinstitute.rnai.poolq.api.PoolQArgs;
import org.broadinstitute.rnai.poolq.api.PoolQDataInputs;
import org.broadinstitute.rnai.poolq.api.PoolQDataOutputs;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.api.ReadTooShortException;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.EventTracker;
import org.broadinstitute.rnai.poolq.impl.data.InMemoryEventTracker;
import org.broadinstitute.rnai.poolq.impl.data.PoolQDataImpl;
import org.broadinstitute.rnai.poolq.impl.fileparser.ConditionsFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.MultiplexedReadsFileIterable;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsIterable;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReferenceFileParser;
import org.broadinstitute.rnai.poolq.impl.filewriter.BarcodeScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.CorrelationFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizedScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.QualityReportFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.UnexpectedSequenceFileWriter;
import org.broadinstitute.rnai.poolq.impl.reads.FixedReadProcessor;
import org.broadinstitute.rnai.poolq.impl.reads.Read;
import org.broadinstitute.rnai.poolq.impl.reads.ReadMeasurer;
import org.broadinstitute.rnai.poolq.impl.reads.ReadProcessor;
import org.broadinstitute.rnai.poolq.impl.reads.VariableReadProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolQImpl
implements PoolQ {
    private static final Logger logger = LoggerFactory.getLogger(PoolQImpl.class);

    @Override
    public void runPoolQ(PoolQArgs poolQArgs) throws PoolQException {
        InMemoryEventTracker inMemoryEventTracker = new InMemoryEventTracker();
        PoolQDataInputs poolQDataInputs = this.buildPoolQDataInputs(poolQArgs, inMemoryEventTracker);
        try (PoolQDataImpl poolQDataImpl = new PoolQDataImpl(poolQDataInputs, inMemoryEventTracker);){
            String string2;
            Object object;
            String string3;
            String string4;
            String string5;
            logger.info("Beginning PoolQ");
            PoolQDataOutputs poolQDataOutputs = poolQDataImpl.runPoolQ();
            logger.info("Reads processing complete, writing reports");
            PoolQScores poolQScores = poolQDataOutputs.getPoolQScores();
            String string6 = poolQArgs.getScoresFilename();
            if (string6 != null) {
                this.writeScoresFile(poolQScores, poolQArgs.getScoresFilename());
            }
            if ((string5 = poolQArgs.getLogNormalizedScoresFilename()) != null) {
                this.writeLogNormalizedScoresFile(poolQScores, string5);
            }
            if ((string4 = poolQArgs.getBarcodeScoresFilename()) != null) {
                this.writeBarcodeScoresFile(poolQScores, string4);
            }
            if ((string3 = poolQArgs.getQualityFilename()) != null) {
                object = poolQDataOutputs.getQualityReportData();
                this.writeQualityFile((QualityReportData)object, poolQArgs.getQualityFilename());
            }
            if ((object = poolQArgs.getUnexpectedSequenceFilename()) != null) {
                this.writeUnexpectedSequenceFile(poolQDataOutputs.getUnexpectedSequenceReportData(), poolQArgs.getUnexpectedSequenceThreshold(), (String)object);
            }
            if ((string2 = poolQArgs.getCorrelationFilename()) != null) {
                this.writeCorrelationScoresFile(poolQScores, string2);
            }
            logger.info("PoolQ completed, closing data");
        }
        catch (RuntimeException runtimeException) {
            logger.error("Caught unexpected error while running PoolQ", runtimeException);
            throw runtimeException;
        }
    }

    private PoolQDataInputs buildPoolQDataInputs(final PoolQArgs poolQArgs, EventTracker eventTracker) {
        Iterable<Read> iterable;
        final Map<String, List<String>> map2 = this.getConstructToConstructIdsMap(poolQArgs.getReferenceFilename());
        String string2 = poolQArgs.getPlatformReferenceFilename();
        final Map<Object, Object> map3 = string2 == null ? Collections.emptyMap() : this.getConstructToConstructIdsMap(string2);
        final Map<String, String> map4 = this.getBarcodeToConditionMap(poolQArgs.getConditionsFilename());
        int n = this.getConstructBarcodeLength(poolQArgs, map2);
        final ReadProcessor readProcessor = this.getReadProcessor(poolQArgs, eventTracker, n, map4);
        if (poolQArgs.getReadsFilenames().size() == 1) {
            String string3 = poolQArgs.getReadsFilenames().get(0);
            int n2 = ReadMeasurer.readLength(string3, poolQArgs.getReadsFileType(), poolQArgs.includeNonPfReads());
            int n3 = n2 - poolQArgs.getConstructBarcodeStartIndex();
            if (n3 < n) {
                throw new ReadTooShortException("Reads contained in " + string3 + " are too short to contain " + "a construct barcode of length " + n + " starting at position " + poolQArgs.getConstructBarcodeStartIndex() + ". To skip short reads, re-run PoolQ with the " + "--skip-short-reads flag. To match against the available " + "construct barcode prefix, re-run PoolQ with the argument " + "--construct-barcode-match-length " + n3 + ".");
            }
            iterable = new ReadsIterable(string3, poolQArgs.getReadsFileType(), poolQArgs.includeNonPfReads(), readProcessor);
        } else if (poolQArgs.getReadsFilenames().size() == 2) {
            String string4;
            String string5;
            int n4;
            String string6 = poolQArgs.getReadsFilenames().get(0);
            String string7 = poolQArgs.getReadsFilenames().get(1);
            int n5 = ReadMeasurer.readLength(string6, poolQArgs.getReadsFileType(), poolQArgs.includeNonPfReads());
            if (n5 < (n4 = ReadMeasurer.readLength(string7, poolQArgs.getReadsFileType(), poolQArgs.includeNonPfReads()))) {
                string5 = string6;
                string4 = string7;
            } else {
                string5 = string7;
                string4 = string6;
            }
            iterable = new MultiplexedReadsFileIterable(readProcessor, string5, string4);
        } else {
            throw new PoolQException("Must provide exactly 1 or 2 reads files. Got " + poolQArgs.getReadsFilenames().size());
        }
        return new PoolQDataInputs(){
            private final int sampleBarcodeLength;
            private final boolean findConstructBarcodesByPrefix;
            private final boolean onlyReportUnexpectedSequences;
            private final boolean countUnexpectedSequences;
            {
                this.sampleBarcodeLength = ((String)map4.keySet().iterator().next()).length();
                this.findConstructBarcodesByPrefix = poolQArgs.getConstructBarcodeSearchPrefix() != null;
                this.onlyReportUnexpectedSequences = poolQArgs.getScoresFilename() == null && poolQArgs.getQualityFilename() == null && poolQArgs.getBarcodeScoresFilename() == null && poolQArgs.getLogNormalizedScoresFilename() == null && poolQArgs.getCorrelationFilename() == null;
                this.countUnexpectedSequences = poolQArgs.getUnexpectedSequenceFilename() != null;
            }

            @Override
            public Map<String, List<String>> getConstructBarcodeToConstructIdsMap() {
                return map2;
            }

            @Override
            public Map<String, List<String>> getPlatformConstructBarcodeToConstructIdsMap() {
                return map3;
            }

            @Override
            public Map<String, String> getSampleBarcodeToConditionMap() {
                return map4;
            }

            @Override
            public int getSampleBarcodeLength() {
                return this.sampleBarcodeLength;
            }

            @Override
            public boolean requireExactMatch() {
                return poolQArgs.requireExactMatch();
            }

            @Override
            public boolean scoreAmbiguousMatches() {
                return poolQArgs.includeAmbiguous();
            }

            @Override
            public boolean skipShortReads() {
                return poolQArgs.skipShortReads();
            }

            @Override
            public BarcodeProcessor getBarcodeProcessor() {
                return readProcessor;
            }

            @Override
            public Iterable<Read> getReadsIterable() {
                return iterable;
            }

            @Override
            public boolean findConstructBarcodesByPrefix() {
                return this.findConstructBarcodesByPrefix;
            }

            @Override
            public boolean onlyReportUnexpectedSequences() {
                return this.onlyReportUnexpectedSequences;
            }

            @Override
            public boolean countUnexpectedSequences() {
                return this.countUnexpectedSequences;
            }
        };
    }

    private ReadProcessor getReadProcessor(PoolQArgs poolQArgs, EventTracker eventTracker, int n, Map<String, String> map2) {
        ReadProcessor readProcessor = poolQArgs.getConstructBarcodeSearchPrefix() != null ? VariableReadProcessor.apply(poolQArgs.getConstructBarcodeSearchPrefix(), poolQArgs.getConstructBarcodeSearchStartIndex(), poolQArgs.getConstructBarcodeSearchEndIndex(), poolQArgs.getSampleBarcodeStartIndex(), this.getKeyLength(map2), n, eventTracker) : new FixedReadProcessor(poolQArgs.getSampleBarcodeStartIndex(), this.getKeyLength(map2), poolQArgs.getConstructBarcodeStartIndex(), n);
        return readProcessor;
    }

    private int getConstructBarcodeLength(PoolQArgs poolQArgs, Map<String, ?> map2) {
        if (poolQArgs.getConstructBarcodeMatchLength() == null) {
            return this.getKeyLength(map2);
        }
        return Math.min(poolQArgs.getConstructBarcodeMatchLength(), this.getKeyLength(map2));
    }

    private Integer getKeyLength(Map<String, ?> map2) {
        Iterator<String> iterator2 = map2.keySet().iterator();
        if (iterator2.hasNext()) {
            return iterator2.next().length();
        }
        throw new IllegalStateException("Empty reference or conditions map");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> getConstructToConstructIdsMap(String string2) {
        ReferenceFileParser referenceFileParser = new ReferenceFileParser();
        try (InputStream inputStream = this.getInputStreamForFilename(string2);){
            Map<String, List<String>> map2 = referenceFileParser.parseMapFromStream(inputStream);
            return map2;
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to read reference file " + string2, iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getBarcodeToConditionMap(String string2) {
        ConditionsFileParser conditionsFileParser = new ConditionsFileParser();
        try (InputStream inputStream = this.getInputStreamForFilename(string2);){
            Map<String, String> map2 = conditionsFileParser.parseBarcodeToConditionMapFromInputStream(inputStream);
            return map2;
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to read conditions file " + string2, iOException);
        }
    }

    private InputStream getInputStreamForFilename(String string2) throws FileNotFoundException {
        File file = new File(string2);
        return new FileInputStream(file);
    }

    private void writeScoresFile(PoolQScores poolQScores, String string2) throws PoolQException {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            boolean bl = ScoresFileWriter.isGctFile(string2);
            new ScoresFileWriter(bl).writeFile(poolQScores, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write scores file", iOException);
        }
    }

    private void writeLogNormalizedScoresFile(PoolQScores poolQScores, String string2) {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            boolean bl = ScoresFileWriter.isGctFile(string2);
            new LogNormalizedScoresFileWriter(bl).writeFile(poolQScores, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write log-normalized scores file", iOException);
        }
    }

    private void writeBarcodeScoresFile(PoolQScores poolQScores, String string2) {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            boolean bl = ScoresFileWriter.isGctFile(string2);
            new BarcodeScoresFileWriter(bl).writeFile(poolQScores, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write barcode scores file", iOException);
        }
    }

    private void writeCorrelationScoresFile(PoolQScores poolQScores, String string2) {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            new CorrelationFileWriter().writeFile(poolQScores, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write correlation file", iOException);
        }
    }

    private void writeQualityFile(QualityReportData qualityReportData, String string2) throws PoolQException {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            new QualityReportFileWriter().writeQualityReportFile(qualityReportData, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write quality file", iOException);
        }
    }

    private void writeUnexpectedSequenceFile(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, String string2) throws PoolQException {
        try (OutputStream outputStream = this.getOutputStreamForFilename(string2);){
            UnexpectedSequenceFileWriter.writeUnexpectedSequenceFile(unexpectedSequenceReportData, n, outputStream);
        }
        catch (IOException iOException) {
            throw new PoolQException("Unable to write unexpected sequence file", iOException);
        }
    }

    private OutputStream getOutputStreamForFilename(String string2) throws PoolQException {
        File file = new File(string2);
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PoolQException("Problem opening file for writing: " + fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }
}

