/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.broadinstitute.rnai.poolq.api.BarcodeProcessor;
import org.broadinstitute.rnai.poolq.impl.data.BarcodeVariantToBarcodes;
import org.broadinstitute.rnai.poolq.impl.data.BarcodeVariants;
import org.broadinstitute.rnai.poolq.impl.data.ConstructReferenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructTempDatabase
extends TempDatabase
implements ConstructReferenceDatabase {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BarcodeProcessor barcodeProcessor;
    private PrimaryIndex<String, BarcodeVariantToBarcodes> constructBarcodeVariantIndex;

    public ConstructTempDatabase(BarcodeProcessor barcodeProcessor) {
        this.barcodeProcessor = barcodeProcessor;
        this.constructBarcodeVariantIndex = this.getPrimaryIndex(String.class, BarcodeVariantToBarcodes.class);
    }

    @Override
    public void buildConstructVariantDatabase(Set<String> set, boolean bl) {
        this.logger.info("Building construct barcode variant database");
        try {
            this.populateVariantDatabaseWithOriginalConstructs(set);
            if (bl) {
                this.populateVariantDatabaseWithVariants(set);
            }
        }
        catch (Exception exception) {
            throw new TempDatabaseException(exception);
        }
    }

    @Override
    public List<String> getConstructBarcodesForVariant(String string2) {
        try {
            BarcodeVariantToBarcodes barcodeVariantToBarcodes = this.constructBarcodeVariantIndex.get(string2);
            if (barcodeVariantToBarcodes == null) {
                return Collections.emptyList();
            }
            List<String> list = barcodeVariantToBarcodes.getBarcodes();
            if (list.contains(string2)) {
                return Collections.singletonList(string2);
            }
            return list;
        }
        catch (DatabaseException databaseException) {
            throw new TempDatabaseException(databaseException);
        }
    }

    private void populateVariantDatabaseWithOriginalConstructs(Set<String> set) throws DatabaseException {
        for (String string2 : set) {
            String string3 = this.barcodeProcessor.truncateConstructBarcode(string2);
            this.addConstructForVariant(string3, string2);
        }
    }

    private void populateVariantDatabaseWithVariants(Set<String> set) throws DatabaseException {
        for (String string2 : set) {
            String string3 = this.barcodeProcessor.truncateConstructBarcode(string2);
            for (String string4 : BarcodeVariants.buildVariants(string3)) {
                this.addConstructForVariant(string4, string2);
            }
        }
    }

    private void addConstructForVariant(String string2, String string3) {
        List<String> list;
        BarcodeVariantToBarcodes barcodeVariantToBarcodes = this.constructBarcodeVariantIndex.get(string2);
        if (barcodeVariantToBarcodes == null) {
            list = new ArrayList<String>();
            barcodeVariantToBarcodes = new BarcodeVariantToBarcodes(string2, list);
        } else {
            list = barcodeVariantToBarcodes.getBarcodes();
        }
        list.add(string3);
        this.constructBarcodeVariantIndex.putNoReturn(barcodeVariantToBarcodes);
    }
}

