/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.vcf.VCFLineParser;

class VCF4Parser
implements VCFLineParser {
    VCF4Parser() {
    }

    @Override
    public Map<String, String> parseLine(String string2, List<String> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        int n = 0;
        boolean bl = false;
        for (char c : string2.toCharArray()) {
            if (c == '\"') {
                bl = !bl;
            } else if (bl) {
                stringBuilder.append(c);
            } else {
                switch (c) {
                    case '<': {
                        if (n == 0) break;
                    }
                    case '>': {
                        if (n != string2.length() - 1) break;
                        linkedHashMap.put(string3, stringBuilder.toString().trim());
                        break;
                    }
                    case '=': {
                        string3 = stringBuilder.toString().trim();
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    case ',': {
                        linkedHashMap.put(string3, stringBuilder.toString().trim());
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            ++n;
        }
        n = 0;
        if (list != null) {
            if (linkedHashMap.size() > list.size()) {
                throw new TribbleException.InvalidHeader("unexpected tag count " + linkedHashMap.size() + " in line " + string2);
            }
            Object object = linkedHashMap.keySet().iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                if (!list.get(n).equals(string4)) {
                    throw new TribbleException.InvalidHeader("Unexpected tag " + string4 + " in line " + string2);
                }
                ++n;
            }
        }
        return linkedHashMap;
    }
}

